#
# TABLE STRUCTURE FOR: campaign
#

DROP TABLE IF EXISTS `campaign`;

CREATE TABLE `campaign` (
  `campaign_id` int(11) NOT NULL AUTO_INCREMENT,
  `campaign_title` varchar(255) NOT NULL,
  `campaign_form` int(11) NOT NULL,
  `campaign_status` tinyint(4) NOT NULL DEFAULT '1',
  `campaign_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `session_id` varchar(40) NOT NULL DEFAULT '0',
  `ip_address` varchar(45) NOT NULL DEFAULT '0',
  `user_agent` varchar(120) NOT NULL,
  `last_activity` int(10) unsigned NOT NULL DEFAULT '0',
  `user_data` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: lb_admin
#

DROP TABLE IF EXISTS `lb_admin`;

CREATE TABLE `lb_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `email` varchar(70) NOT NULL,
  `password` varchar(50) NOT NULL,
  `text_password` varchar(255) NOT NULL,
  `user_type` int(11) NOT NULL,
  `phone` varchar(11) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `address` varchar(500) NOT NULL,
  `dob` date DEFAULT NULL,
  `anniversary_date` datetime DEFAULT NULL,
  `city` varchar(250) NOT NULL,
  `forget_password_code` varchar(50) NOT NULL,
  `account_activation_code` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `copyright` varchar(255) NOT NULL DEFAULT 'Star Imaging',
  `copyright_url` varchar(255) NOT NULL DEFAULT 'Star Imaging',
  `logo_name_url` text NOT NULL,
  `created_at` datetime NOT NULL,
  `modified_at` datetime NOT NULL,
  `profile_img` varchar(250) DEFAULT NULL,
  `branch_name` varchar(300) DEFAULT NULL,
  `reference_code` varchar(250) NOT NULL,
  `referal_code` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `lb_admin` (`id`, `first_name`, `last_name`, `email`, `password`, `text_password`, `user_type`, `phone`, `gender`, `address`, `dob`, `anniversary_date`, `city`, `forget_password_code`, `account_activation_code`, `status`, `copyright`, `copyright_url`, `logo_name_url`, `created_at`, `modified_at`, `profile_img`, `branch_name`, `reference_code`, `referal_code`) VALUES (1, 'Dev', 'Developer', 'dev.developer@gmail.com', '9ac0ddfd98dba27fe3f5f539abb477c8', 'Infutive@#$com', 1, '1234567890', '1', 'New Delhi', '2018-03-29', '0000-00-00 00:00:00', 'Delhi', '', '', 1, 'City Xray', '#', 'City Xray', '2019-06-09 00:00:00', '0000-00-00 00:00:00', '#', NULL, '', '');
INSERT INTO `lb_admin` (`id`, `first_name`, `last_name`, `email`, `password`, `text_password`, `user_type`, `phone`, `gender`, `address`, `dob`, `anniversary_date`, `city`, `forget_password_code`, `account_activation_code`, `status`, `copyright`, `copyright_url`, `logo_name_url`, `created_at`, `modified_at`, `profile_img`, `branch_name`, `reference_code`, `referal_code`) VALUES (2, 'InFutive', 'Developer', 'developer@gmail.com', 'e10adc3949ba59abbe56e057f20f883e', '123456', 2, '9876564534', '1', 'B-282 4th floor Dwarka Sec 7 Neer Ram Phal Chowk', '2021-03-30', NULL, 'NEW DELHI', '', '', 1, 'City Xray', '#', 'City Xray', '2021-03-15 03:24:52', '2021-03-15 03:24:52', NULL, NULL, '', '');


#
# TABLE STRUCTURE FOR: lb_awards
#

DROP TABLE IF EXISTS `lb_awards`;

CREATE TABLE `lb_awards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `img` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `img_alt_tag` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` tinyint(11) NOT NULL DEFAULT '1',
  `type` tinyint(4) NOT NULL COMMENT '1=awards|2=accreditions',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (1, 'National Accreditation Board For Testing And Calibration Laboratorie', '<p>City X Ray & Scan Clinic Pvt. Ltd. has been assessed and accredited in accordance with the standard ISO 15189:2013</p>', 'award1.png', '', 'national-accreditation-board-for-testing-and-calibration-laboratorie.html', 3, 1, '2023-10-28 16:39:16');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (14, 'National Accreditation Board for Hospitals & Healthcare Providers', '<p>City X Ray & Scan Clinic Pvt. Ltd. has been assessed and found to comply with NABH accreditation standards for medical Imaging services. This certificate is valid for the scope as specified in the annexure subject to continued compliance with the accre', 'nabh-certificate.webp', '', 'nabh-certificate', 1, 2, '2023-12-16 10:42:13');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (15, 'Certificate Of Recognition - Achiever in diagnostics, Radiology & Imaging Category', '<p>Certificate Of Recognition - Achiever in diagnostics, Radiology & Imaging Category..</p>', 'certificate-of-recohnition.webp', '', 'certificate-of-recognition', 1, 1, '2023-12-16 10:43:15');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (16, 'National Accreditation Board for Testing and Calibration Laboratories', '<p>City X Ray & Scan Clinic Pvt. Ltd. has been assessed and accredited in accordance with the standard ISO 15189:2012</p>', '10022023125131nabl-award.webp', '', 'nabl-certificate', 1, 2, '2023-12-16 10:43:49');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (17, 'National Health Care Awards-2022', '<p>National Health Care Awards-2022 To City X-Ray & Scan Clinic For Most Prominent Diagnostic Centre of The Year - 2022, Delhi</p>', 'national-eide-health-care-award.webp', '', 'national-healthcare-awards-2022', 1, 1, '2023-12-16 10:44:31');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (18, 'Honour Of Dr. Lal Singh Expertise(IND) Award', '<p>Honour of Dr. Lal Singh Expertise(IND) Award for Outstanding Contributions to Society to City X-Ray & Scan Clinic</p>', 'Honourof-Drlalsinghexpertise.webp', '', 'honour-of-dr-lal-singh-expertise', 1, 1, '2023-12-16 10:44:49');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (19, 'International Healthcare Award 2022', '<p>International Healthcare Award 2022 in Healthcare Excellence (Diagnostic Centre) Of The Year 2021-22, Delhi by TIME CyberMedia Pvt. Ltd.</p>', 'TimeCyber-Media1.webp', '', 'international-healthcare-award-2022', 1, 1, '2023-12-16 10:45:06');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (20, 'The Healthcare Excellence Awards 2018', '<p>The Healthcare Excellence Awards 2018 in Recognition of Significant Contribution Made By City X-Ray & Scan Clinic</p>', 'healthcare-excellence.webp', '', 'health-care-excellence-awards-2018', 1, 1, '2023-12-16 10:45:28');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (21, 'Delhi City Icon Award For Excellence In The Category Of Diagnostic By Radio City 91.1 FM', '<p>Delhi City Icon Award for Excellence in the Category of Diagnostic for the Year 2021 is awarded to City X Ray & Scan Clinic Pvt. Ltd.</p>', 'Radiocity-Award.webp', '', 'delhi-city-icon-award', 1, 1, '2023-12-16 10:45:45');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (22, 'Certificate Of Excellence In Recognition Of Significant Contribution', '<p>Certificate of Excellence in Recognition of the significant contribution made by City X-Ray Scan Clinic (p) Ltd.</p>', 'Certificate-of-excellence.webp', '', 'certificate-of-excellence', 1, 1, '2023-12-16 10:46:05');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (23, 'tetsate asd asdasd ad', '<p>ajsdhjhjh</p>', '', '', 'tetsate-asd-asdasd-ad.html', 3, 1, '2023-12-16 12:18:46');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (24, 'test  Accredition', '<p>test Accredition</p>', '', '', 'test-accredition.html', 3, 2, '2023-12-27 15:14:02');
INSERT INTO `lb_awards` (`id`, `title`, `description`, `img`, `img_alt_tag`, `url`, `status`, `type`, `created_at`) VALUES (25, 'test award', '<p>test award</p>', '', 'test', 'test-award.html', 3, 1, '2023-12-27 15:15:53');


#
# TABLE STRUCTURE FOR: lb_blog_category_post
#

DROP TABLE IF EXISTS `lb_blog_category_post`;

CREATE TABLE `lb_blog_category_post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL,
  `prod_id` int(11) NOT NULL,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=latin1;

INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (90, 7, 40, '2023-12-20 14:17:30');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (95, 7, 34, '2023-12-20 15:44:43');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (96, 7, 35, '2023-12-20 15:46:01');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (97, 7, 29, '2023-12-20 15:47:11');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (98, 7, 30, '2023-12-20 15:49:16');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (99, 8, 31, '2023-12-20 15:50:14');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (100, 7, 32, '2023-12-20 15:51:04');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (101, 7, 33, '2023-12-20 15:51:55');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (102, 7, 36, '2023-12-20 15:52:33');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (103, 8, 36, '2023-12-20 15:52:33');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (105, 7, 38, '2023-12-20 15:53:53');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (106, 7, 39, '2023-12-20 15:54:22');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (107, 7, 41, '2023-12-20 15:55:07');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (108, 7, 42, '2023-12-20 15:55:36');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (113, 7, 45, '2023-12-27 16:04:38');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (114, 8, 46, '2024-01-03 16:02:37');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (119, 7, 43, '2024-01-04 14:37:22');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (120, 7, 37, '2024-03-05 13:02:39');
INSERT INTO `lb_blog_category_post` (`id`, `cat_id`, `prod_id`, `updated`) VALUES (131, 8, 44, '2024-03-07 13:55:44');


#
# TABLE STRUCTURE FOR: lb_blog_category_tb
#

DROP TABLE IF EXISTS `lb_blog_category_tb`;

CREATE TABLE `lb_blog_category_tb` (
  `category_id` int(125) NOT NULL AUTO_INCREMENT,
  `category_call_type` varchar(255) DEFAULT NULL,
  `category_parent_id` int(125) NOT NULL DEFAULT '0',
  `category_name` varchar(255) NOT NULL,
  `category_url` varchar(255) NOT NULL,
  `category_menu_active` tinyint(1) NOT NULL,
  `category_image` varchar(255) DEFAULT NULL,
  `category_article` text NOT NULL,
  `meta_title` text NOT NULL,
  `meta_desc` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `category_status` tinyint(1) NOT NULL DEFAULT '1',
  `category_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `category_updated` datetime NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `lb_blog_category_tb` (`category_id`, `category_call_type`, `category_parent_id`, `category_name`, `category_url`, `category_menu_active`, `category_image`, `category_article`, `meta_title`, `meta_desc`, `meta_keyword`, `category_status`, `category_created`, `category_updated`) VALUES (7, NULL, 0, 'Health Tips', 'health-tips.html', 1, 'health_tips.jpg', '', '', '', '', 1, '2024-01-04 12:09:38', '2024-01-04 12:09:38');
INSERT INTO `lb_blog_category_tb` (`category_id`, `category_call_type`, `category_parent_id`, `category_name`, `category_url`, `category_menu_active`, `category_image`, `category_article`, `meta_title`, `meta_desc`, `meta_keyword`, `category_status`, `category_created`, `category_updated`) VALUES (8, NULL, 7, 'General Health', 'general-health.html', 1, 'general-health.png', '<p>This is a category article.&nbsp;This is a category article.&nbsp;This is a category article.&nbsp;This is a category article.&nbsp;This is a category article.&nbsp;This is a category article.&nbsp;This is a category article.&nbsp;</p>\r\n', 'This is a category article. meta title', 'This is a category article. meta description', 'This is a category article. meta Keyword', 1, '2024-03-13 10:58:43', '2024-03-13 10:58:43');
INSERT INTO `lb_blog_category_tb` (`category_id`, `category_call_type`, `category_parent_id`, `category_name`, `category_url`, `category_menu_active`, `category_image`, `category_article`, `meta_title`, `meta_desc`, `meta_keyword`, `category_status`, `category_created`, `category_updated`) VALUES (9, NULL, 7, 'test', 'test.html', 1, 'pexels-junior-teixeira-2047905.jpg', '', '', '', '', 1, '2024-02-16 02:34:13', '2024-02-16 02:34:13');


#
# TABLE STRUCTURE FOR: lb_blog_comment
#

DROP TABLE IF EXISTS `lb_blog_comment`;

CREATE TABLE `lb_blog_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `user_email` varchar(255) NOT NULL,
  `user_name` varchar(255) NOT NULL,
  `blog_id` int(11) NOT NULL,
  `comment_text` text NOT NULL,
  `create_at` varchar(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `lb_blog_comment` (`id`, `parent_id`, `user_email`, `user_name`, `blog_id`, `comment_text`, `create_at`, `status`) VALUES (1, 0, 'guptaakash2835@gmail.com', 'akash', 32, 'mst hai', '2023-11-27 ', 3);
INSERT INTO `lb_blog_comment` (`id`, `parent_id`, `user_email`, `user_name`, `blog_id`, `comment_text`, `create_at`, `status`) VALUES (2, 0, 'guptaakash2835@gmail.com', 'akash', 32, 'hi', '2023-11-28 ', 3);
INSERT INTO `lb_blog_comment` (`id`, `parent_id`, `user_email`, `user_name`, `blog_id`, `comment_text`, `create_at`, `status`) VALUES (3, 0, 'test@test.com', 'test', 43, 'test', '2024-01-03 ', 3);
INSERT INTO `lb_blog_comment` (`id`, `parent_id`, `user_email`, `user_name`, `blog_id`, `comment_text`, `create_at`, `status`) VALUES (4, 0, 'test@test.com', 'test', 43, 'saesd', '2024-01-03 ', 3);
INSERT INTO `lb_blog_comment` (`id`, `parent_id`, `user_email`, `user_name`, `blog_id`, `comment_text`, `create_at`, `status`) VALUES (5, 0, 'gupta@gmail.com', 'akash', 43, 'testing purpose', '2024-02-27 ', 0);


#
# TABLE STRUCTURE FOR: lb_blog_post
#

DROP TABLE IF EXISTS `lb_blog_post`;

CREATE TABLE `lb_blog_post` (
  `post_id` int(125) NOT NULL AUTO_INCREMENT,
  `post_title` text CHARACTER SET utf8 NOT NULL,
  `post_description` text CHARACTER SET utf8 NOT NULL,
  `post_url` text NOT NULL,
  `post_img` varchar(255) DEFAULT NULL,
  `post_img_alt_tag` varchar(255) NOT NULL,
  `small_description` text CHARACTER SET utf8 NOT NULL,
  `post_status` int(11) NOT NULL DEFAULT '1',
  `meta_title` text,
  `meta_desc` mediumtext CHARACTER SET utf8,
  `meta_keyword` mediumtext CHARACTER SET utf8,
  `post_tags` text CHARACTER SET utf8,
  `post_created` date NOT NULL,
  `post_created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `post_updated` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=latin1;

INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (29, 'Asthma: What Is It? Types, Causes, Symptoms, Test', '<p>Asthma is a chronic respiratory illness characterised by narrowing and inflammation of the airways. With a test for asthma, you can undergo the proper treatment. Asthma also causes recurring episodes of coughing, wheezing, shortness of breath, etc.</p>\r\n\r\n<p>Person showing symptoms of asthma comes in contact with triggers like allergens, their airways become more sensitive. It leads to the tightening of muscles around the airways. Moreover, the airways produce excess mucous. As a result, the airways constrict, which makes it difficult for air to flow in and out of the lungs.</p>\r\n\r\n<p>Asthma is a long-term lung disease. Severe asthma can cause trouble even in daily routine. In other words, it severely affects your everyday routine. Without proper treatment, you might have to stay at the hospital often. Therefore, knowing about test for asthma can help you lead a healthy life.</p>\r\n\r\n<h2>What Is Asthma?</h2>\r\n\r\n<p>Asthma is a chronic respiratory disease that affects millions of people across the globe. It is a condition that involves the narrowing and inflammation of the airways. During asthma, you may experience recurrent episodes of coughing, wheezing, shortness of breath, etc.</p>\r\n\r\n<p>However, with proper treatment and management, individuals can lead a healthy life. Furthermore, the symptoms of asthma often change over time. So, it is crucial that you collaborate with your doctor to track the signs. A test for asthma can be beneficial to manage the symptoms and severity of asthma.</p>\r\n\r\n<h2>The Common Types Of Asthma</h2>\r\n\r\n<p>To effectively manage chronic asthma, you must know the types of asthma.</p>\r\n\r\n<p><strong>Types of asthma are:-</strong></p>\r\n\r\n<ul>\r\n <li><strong>Allergic Asthma</strong></li>\r\n</ul>\r\n\r\n<p>Triggered by allergens, this type of asthma is pretty common among post people. Common allergens like dust mites, pollens, pet dander, etc., can trigger asthma-like symptoms. Allergic asthma is often hereditary. It may also be associated with other allergic conditions like eczema.</p>\r\n\r\n<ul>\r\n <li><strong>Non-Allergic Asthma</strong></li>\r\n</ul>\r\n\r\n<p>Customary to its name, non-allergic asthma is not triggered by allergens. It is usually caused by factors like cold air, respiratory infections, irritants, etc. Proper diagnostic tests at the right time can help a patient manage their symptoms.</p>\r\n\r\n<ul>\r\n <li><strong>Exercise-Induced Asthma</strong></li>\r\n</ul>\r\n\r\n<p>This type of asthma is triggered by physical activities or strenuous exercises. The symptoms typically occur doing or after the workout. It may also include wheezing, coughing and tightness of the chest.</p>\r\n\r\n<ul>\r\n <li><strong>Intermittent Asthma</strong></li>\r\n</ul>\r\n\r\n<p>Intermittent asthma is a classification of the severity of asthma based on the intensity of the symptoms. The severe asthma symptoms occur less than twice a week on average. The common symptoms of this asthma type are coughing, shortness of breath, etc. During intermittent asthma, your lung function may also decrease.</p>\r\n\r\n<ul>\r\n <li><strong>Persistent Asthma</strong></li>\r\n</ul>\r\n\r\n<p>The symptoms of this asthma may range from mild to severe. In persistent asthma, the symptoms and lung function may vary over time. The main goal of treatment for persistent asthma is to improve the functioning of the lungs and minimise the symptoms.</p>\r\n\r\n<ul>\r\n <li><strong>Cough-Variant Asthma</strong></li>\r\n</ul>\r\n\r\n<p>Instead of the typical wheezing and shortness of breath, cough-variant asthma is characterised by a dry and persistent cough. In this type of asthma, coughing may become worse during the night. It falls under the umbrella of asthma because the coughing is caused by airway inflammation.</p>\r\n\r\n<p>The cough in this type of asthma is caused by increased sensitivity and inflammation of the airways. The airway muscles typically constrict, which leads to coughing. You must know about the proper treatment of asthma to eliminate complications.</p>\r\n\r\n<ul>\r\n <li><strong>Occupational Asthma</strong></li>\r\n</ul>\r\n\r\n<p>As the name suggests, exposure to certain irritants in the workplace cause this form of asthma. For instance, if your workplace has a higher concentration of dust and chemicals, you can develop occupational asthma.</p>\r\n\r\n<p>The symptoms of this asthma may occur during work hours and improve when you’re away from your workplace. The treatment of asthma often involves your healthcare practitioner evaluating your work history.</p>\r\n\r\n<h2>Symptoms Of Asthma- Essential Aspects To Know</h2>\r\n\r\n<p>By knowing about the symptoms, you will be better equipped to deal with this chronic respiratory illness. Here are some of the common symptoms of asthma you must know.</p>\r\n\r\n<ul>\r\n <li><strong>Wheezing</strong></li>\r\n</ul>\r\n\r\n<p>It is a characteristic whistling or high-pitched sound that occurs when you breathe. The main reason behind wheezing is narrowed and inflamed airways.</p>\r\n\r\n<ul>\r\n <li><strong>Coughing</strong></li>\r\n</ul>\r\n\r\n<p>Another hallmark symptom of asthma is persistent coughing. The cough may be dry or can produce mucous. Moreover, coughing is often worse at night compared to morning.</p>\r\n\r\n<ul>\r\n <li><strong>Tightness in the Chest</strong></li>\r\n</ul>\r\n\r\n<p>Many patients with asthma describe a sensation of pressure or constriction in their chests. The overall condition can be comfortable and contribute to breathlessness.</p>\r\n\r\n<ul>\r\n <li><strong>Shortness of Breath</strong></li>\r\n</ul>\r\n\r\n<p>Usually, shortness of breath is one of the common symptoms of asthma. Learning about the causes of asthma may help patients manage their condition.</p>\r\n\r\n<h2>What Are The Tests For Asthma?</h2>\r\n\r\n<p>To ascertain the causes of asthma and diagnose it effectively, doctors may recommend various types of tests. The primary role of these tests is to confirm the presence of asthma. By undergoing one of these tests, doctors can determine the best treatment plan.</p>\r\n\r\n<ul>\r\n <li><strong>Spirometry</strong></li>\r\n</ul>\r\n\r\n<p>It is an important diagnostic test for asthma that monitors your current symptoms. It measures the amount of air you inhale and exhale and how quickly you can do it. During the test, you will be asked to take a quick breath and exhale into a device named a spirometer. It helps to identify the presence of airway obstruction.</p>\r\n\r\n<ul>\r\n <li><strong>Peak Expiratory Flow Measurement</strong></li>\r\n</ul>\r\n\r\n<p>It is a type of test that analyses the maximum speed at which you can exhale air. The test involves the usage of a peak flow meter. It is a handheld device that measures the airflow when you exhale into it. With regular measurement of the peak expiratory flow, doctors can monitor the changes in your lung function. This test also helps with the identification of asthma triggers.</p>\r\n\r\n<p>To manage asthma, patients must be aware of the asthma attack symptoms. Thanks to the evolution of diagnostic tests, you can now manage your asthma-related symptoms properly.</p>\r\n\r\n<p><strong>Author’s Bio</strong></p>\r\n\r\n<p>Through this blog, the author has tried to bridge the gap between medical expertise and the challenges faced by asthma patients. The blog also underlines the importance of asthma tests in the management of the disease.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'asthma-types-causes-symptoms-tests', 'types-of-asthma.webp', '', 'Asthma is a chronic respiratory illness characterised by narrowing and inflammation of the airways. With a test for asthma, you can undergo the proper treatment. Asthma also causes recurring episodes of coughing, wheezing, shortness of breath, etc.', 1, 'Asthma: What Is It? Types, Causes, Symptoms, Test', 'Explore the world of asthma, its various types, common symptoms, and diagnostic tests in this informative guide. Learn to manage this respiratory condition effectively.', 'test for asthama, types of asthma, symptoms of asthama , severe asthma symptoms, treatment of asthama, causes of asthma, asthma attack symptoms, diagnostic test for asthama', 'asthama', '2023-10-16', '2023-11-03 10:25:03', '2023-12-20 03:47:11');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (30, 'Everything You Need to Know About Gestational Diabetes', '<p>Gestational diabetes in pregnancy involves abnormally higher blood sugar levels. The condition typically affects women who have never had diabetes before becoming pregnant. During pregnancy, the placenta produces hormones that can interfere with your body’s ability to use insulin effectively.</p>\r\n\r\n<p>In the human body, insulin plays a crucial role in regulating blood sugar levels. Women with gestational diabetes may develop insulin resistance, where body cannot use the insulin properly through body. Medical practitioners opine that gestational diabetes usually develops around the 24th and 28th week of pregnancy. It can occur in the early stages of pregnancy too.</p>\r\n\r\n<p>Gestational diabetes in pregnancy comes from hormonal changes and the way your bodies convert food into energy. Expectant mothers should be aware of this type of diabetes and follow a disciplined routine to avoid complications.</p>\r\n\r\n<h2>The Risk Factors Involved In Gestational Diabetes In Pregnancy</h2>\r\n\r\n<p>Managing gestational diabetes will make sure that you have a healthy pregnancy and a healthy baby. The risk factors associated with this type of diabetes are listed below:-</p>\r\n\r\n<p>Women who are 25 years or older are at higher risk</p>\r\n\r\n<ul>\r\n <li>Having a close relative with diabetes is a potential risk factor</li>\r\n <li>Women with PCOS are at a higher risk</li>\r\n <li>Obesity can increase the risk of gestational diabetes</li>\r\n <li>Women from specific ethnic backgrounds have a higher risk of developing this illness</li>\r\n</ul>\r\n\r\n<p>One of the best ways to manage diabetes during pregnancy is by modifying the lifestyle. For instance, maintaining a healthy diet and engaging in regular workouts can be helpful in controlling diabetes during pregnancy.</p>\r\n\r\n<h2>Symptoms Of Diabetes In Pregnancy – What Are The Aspects To Know?</h2>\r\n\r\n<p>Gestational diabetes typically doesn’t have any symptoms. Your medical history and whether you have any risk factors may help in the diagnosis of pregnancy during diabetes. It is crucial for expectant mothers to undergo frequent screening for diabetes during their prenatal care. Some of the symptoms associated with gestational diabetes are:-</p>\r\n\r\n<p><strong>1. Increased Thirst</strong></p>\r\n\r\n<p>Women with diabetes during pregnancy may feel excessively thirsty and need to drink more fluids periodically than usual.</p>\r\n\r\n<p><strong>2. Fatigue</strong></p>\r\n\r\n<p>Even with sufficient rest, pregnant women may feel tired or energy deficit.</p>\r\n\r\n<p><strong>3. Frequent Urination</strong></p>\r\n\r\n<p>During gestational diabetes, you may feel the sensation of urination more frequently and in larger quantities.</p>\r\n\r\n<p><strong>4. Recurrent Infections</strong></p>\r\n\r\n<p>Women with this type of diabetes may develop frequent urination tract infections.</p>\r\n\r\n<p>Knowaledge about the Symptoms of diabetes in pregnancy will be helpful in managing the condition more effectively.</p>\r\n\r\n<h2>What Are The Exact Causes Of Diabetes In Pregnancy?</h2>\r\n\r\n<p>One should be aware of the significant cause of gestational diabetes to manage the illness effectively.</p>\r\n\r\n<p><strong>1. Hormonal Changes</strong></p>\r\n\r\n<p>It is one of the major causes of diabetes during pregnancy. During pregnancy, the placenta produces hormones that can interfere with your body’s insulin production. These hormones can cause insulin resistance, wherein the cells of your body don’t respond effectively to insulin. High blood sugar levels in pregnancy can cause anomalies in the later stages.</p>\r\n\r\n<p><strong>2. Insufficient Production of Insulin</strong></p>\r\n\r\n<p>In some cases, the pancreas may not produce enough insulin to meet the increased demands of your body during pregnancy. It can contribute to elevated blood sugar levels in expectant mothers. The best way to address this problem is by thorough monitoring of  diet and lifestyle.</p>\r\n\r\n<p><strong>3. Genetic Factors</strong></p>\r\n\r\n<p>Note that genetic factors are also responsible for causing gestational diabetes. For instance, if one of your parents has diabetes, then it is likely that you can also suffer from the same. Genetic factors can influence insulin production and how your body handles glucose.</p>\r\n\r\n<p><strong>4. Increased Resistance to Insulin</strong></p>\r\n\r\n<p>It is another cause of gestational diabetes. Pregnancy naturally causes your body to become more resistant to insulin. Healthcare practitioners opine that it is an adaptive mechanism of your body to make sure that there’s an adequate supply of glucose to develop the foetus. But in some women, insulin resistance becomes excessive, which results in gestational diabetes.</p>\r\n\r\n<p><strong>5. Polycystic Ovary Syndrome (PCOS)</strong></p>\r\n\r\n<p>For effective gestational diabetes treatment, you should be aware of its causes. PCOS is an illness triggered by massive hormonal changes. In expectant others, PCOS can cause insulin resistance and hormonal imbalances. Doctors suggest that women with PCOS have a higher chance of developing diabetes during pregnancy.</p>\r\n\r\n<p><strong>6. Obesity and Excess Weight</strong></p>\r\n\r\n<p>Being overweight or obese before pregnancy can significantly increase the risk of developing gestational diabetes. Excess weight can contribute to insulin resistance and impair your body’s glucose metabolism. Therefore, proper screening is the best way to avoid gestational diabetes.</p>\r\n\r\n<p>Note that these causes don’t guarantee that gestational diabetes will occur. Moreover, women without any risk factors can still develop this disease. That’s why opting for regular prenatal care can help recognise and manage gestational diabetes.</p>\r\n\r\n<h2>Gestational Diabetes Treatment – Things To Know</h2>\r\n\r\n<p>GDM treatment mainly focusses on managing your blood sugar levels to ensure a healthy pregnancy and decrease the risk of complications. The treatment methods for gestational diabetes are as follows:</p>\r\n\r\n<p><strong>1. Medical and Dietary Management</strong></p>\r\n\r\n<p>Most cases of gestational diabetes are manageable through lifestyle modifications. Regular physical activity and adhering to a healthy diet can help you stay protected from this type of diabetes. To learn more about pregnancy diabetes diet, you should consult with a certified doctor. Monitoring blood sugar levels at home with a glucose metre can track the impact of dietary choices.</p>\r\n\r\n<p><strong>2. Regular Prenatal Check-Ups</strong></p>\r\n\r\n<p>If you have gestational diabetes, it is crucial to opt for regular prenatal check-ups. These check-ups will help you monitor the progress of your pregnancy and check the baby’s growth. It can also help in assessing and managing blood sugar. You will receive guidance and support to make necessary adjustments to the treatment plan.</p>\r\n\r\n<p><strong>3. Regular Physical Activity</strong></p>\r\n\r\n<p>Besides having a pregnancy diabetes diet, you must indulge in regular physical activities. The last thing you want is to put on weight during pregnancy. Your healthcare practitioner is the best person to suggest you a wide variety of exercises and workouts during this stage. Walking and prenatal yoga are some of the most popular workout types during pregnancy.</p>\r\n\r\n<h2>Diagnostic Tests To Manage Gestational Diabetes</h2>\r\n\r\n<p>Here are some of the common diagnostic tests to manage gestational diabetes in women.</p>\r\n\r\n<p><strong>1. Oral Glucose Tolerance Test</strong></p>\r\n\r\n<p>The Oral Glucose Tolerance Test, also known as OGTT, is accurate in diagnosing gestational pregnancy. During an OGTT, you have to fast overnight. In the morning, a experienced staff will take your baseline blood sample to measure the fasting glucose level.</p>\r\n\r\n<p>The staff will provide you with a glucose drink containing at least 70 grams of glucose. You need to consume the liquid within a specific time frame. Afterwards, the diagnostic lab will monitor your blood glucose levels every thirty minutes to two hours. You must know about the OGTT test price, it may vary centre to centre of any diagnostic lab.</p>\r\n\r\n<p><strong>2. Glucose Challenge Test in Pregnancy</strong></p>\r\n\r\n<p>This test is also known as GCT. GCT is a common prenatal test during pregnancy to screen for gestational diabetes mellitus. The GCT is typically conducted between the 24th and 28th week of your pregnancy. The test involves drinking a solution comprising glucose.</p>\r\n\r\n<p>After consuming the glucose drink, you must wait for at least an hour. During this time, your body metabolises the glucose. Lab technicians will measure your glucose level through the blood sample. The main objective of GCT is to measure how well your body processes glucose. Patients undergoing this test must be aware of the GCT test price.</p>\r\n\r\n<p>Overall, screening for gestational diabetes is a proactive measure to ensure the well-being of the mother and the baby. It allows for the timely management of the blood sugar levels.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'symptoms-of-gestational-diabetes-in-pregnancy', 'signs-of-gestational-diabetes.webp', '', 'Gestational diabetes in pregnancy involves abnormally higher blood sugar levels. The condition typically affects women who have never had diabetes before becoming pregnant. During pregnancy, the placenta produces hormones that can interfere with your body’s ability to use insulin effectively.', 1, 'Everything You Need to Know About Gestational Diabetes', 'Explore the origins, signs, and detection of Gestational Diabetes during pregnancy. Uncover its causes, symptoms, and diagnostic methods in this comprehensive guide to maternal health.', 'gestational diabetes in pregnancy, diabetes in pregnancy, symptoms of diabetes in pregnancy, cause of gestational diabetes, gestational diabetes treatment, gdm treatment, oral glucose tolerance test,', 'gestational diabetes', '2023-09-15', '2023-11-03 10:32:18', '2023-12-20 03:49:16');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (31, 'Why Does Pink Eye Occur? Symptoms, Test For Conjunctivitis Eye Flu', '<p>Viral eye flu is popular by the term pink eye, where the eyes become red. Want to learn about viral eye flu symptoms? Pink eye or conjunctivitis is an inflammation of the transparent membrane conjunctiva lining the eyeball and eyelid.</p>\r\n\r\n<p>If the small blood vessels in this area become irritated and swollen, the white portion of the eyes turns pink or red. It is conjunctivitis, which is infectious and painful. This comprehensive 5-minute post narrates the red eye symptoms, causes, treatments, and more.</p>\r\n\r\n<h2>Understanding Viral Eye Flu Symptoms: Signs Of Conjunctivitis</h2>\r\n\r\n<p>Pink eye or conjunctivitis is a viral infection caused by bacteria or allergic reactions. Several types of conjunctivitis come with a varying range of symptoms. However, the following are the common ones that patients experience at the initial stage:</p>\r\n\r\n<ul>\r\n <li>A red-toned or pink eyes</li>\r\n <li>Thick, watery discharge builds up on the eyes during the night</li>\r\n <li>A gritty feeling in the eyes</li>\r\n <li>Itching and burning sensation of eyes</li>\r\n <li>Unexplained production of tears</li>\r\n <li>Discharge (mucus or pus)</li>\r\n <li>Crusting of lashes or eyelids in the morning</li>\r\n</ul>\r\n\r\n<p>The types of viral eye flu, symptoms of conjunctivitis vary from one type to another. There are three types of conjunctivitis: allergic, chemical, and infectious. Based on the type, the symptoms may differ:</p>\r\n\r\n<p>1. Bacterial Conjunctivitis:</p>\r\n\r\n<p> <strong>The symptoms of bacterial pink eye include:</strong></p>\r\n\r\n<ul>\r\n <li>Discharge or pus, which sticks eyelids together</li>\r\n <li>Ear infection</li>\r\n</ul>\r\n\r\n<p>2. Allergic Conjunctivitis</p>\r\n\r\n<p> <strong>Symptoms of allergic conjunctivitis:</strong></p>\r\n\r\n<ul>\r\n <li>Occurs in both eyes</li>\r\n <li>Produces intense eye itching, swelling, and tearing</li>\r\n <li>Occurs with allergic symptoms, including an itchy nose, a scratchy throat, sneezing, asthma etc.</li>\r\n</ul>\r\n\r\n<p>3. Viral Conjunctivitis</p>\r\n\r\n<p> <strong>Here&#39;s a list of symptoms of conjunctivitis that one experiences in case it is viral:</strong></p>\r\n\r\n<ul>\r\n <li>Occurs with other symptoms of flu, respiratory infection, or cold</li>\r\n <li>Starts in one eye and spreads to the other within few days </li>\r\n <li>Discharge from eyes is watery</li>\r\n</ul>\r\n\r\n<p>One quick note: Conjunctivitis can also occur by irritants, which produce mucus discharge and watery eyes.</p>\r\n\r\n<h2>Conjunctivitis Causes: Why Do Pink Eye Occur?</h2>\r\n\r\n<p>Before understanding the causes of pink eye, you need to know that there are three categories – infectious, allergic, and chemical.</p>\r\n\r\n<p>Infectious conjunctivitis has two categories: viral and bacterial.</p>\r\n\r\n<ul>\r\n <li><strong>Bacterial Conjunctivitis:</strong> It occurs due to staphylococcal/streptococcal bacteria. Touching the eyes with unclean hands may result in bacterial conjunctivitis. Sharing makeup and physical contact with affected person.</li>\r\n <li><strong>Viral Conjunctivitis:</strong> It occurs due to cold viruses, which can occur when someone with a respiratory infection sneezes or coughs in front of you. It occurs if you have a cold virus and blow your nose hard. As a result, the infection pushes from the respiratory system directly to the eyes.</li>\r\n</ul>\r\n\r\n<p>Did you know chemical conjunctivitis may occur due to air pollutants, chlorine present in pools, chemical exposure, etc?</p>\r\n\r\n<p>Want to know the allergic conjunctivitis causes? Well, allergic pink eye occurs due to seasonal allergies. You may get conjunctivitis if you come in contact with pollen or other substances you are allergic to. Also regarded as giant papillary conjunctivitis, allergic conjunctivitis may develop if you wear soft or hard contact lenses that you do not replace frequently.</p>\r\n\r\n<h2>An Overview Of Conjunctivitis Test And Diagnosis</h2>\r\n\r\n<p>Diagnosing conjunctivitis is not a challenging job for a medical professional who performs the following:</p>\r\n\r\n<ul>\r\n <li>A vision screening to check whether the condition has affected your vision</li>\r\n <li>External eye tissue check: the conjunctiva, using magnification and bright light</li>\r\n <li>Inner eye test to ensure there are no tissues affected</li>\r\n <li>A conjunctival tissue smear (performed when an individual suffers from a chronic condition or it improves with treatment)</li>\r\n</ul>\r\n\r\n<p>Besides conducting the above conjunctivitis tests meticulously, the healthcare expert can detect the condition by asking a few questions. The professional may ask you whether you have eye itchiness.</p>\r\n\r\n<p>In addition, the Doctors may ask about thick or watery discharge or whether you are experiencing symptoms of conjunctivitis like hay fever or a common cold.</p>\r\n\r\n<p>Outlining the Chemical, Bacterial, and Viral Conjunctivitis Treatments</p>\r\n\r\n<h2>The Treatment For The Different Types Of Conjunctivitis:</h2>\r\n\r\n<ul>\r\n <li><strong>Chemical</strong></li>\r\n</ul>\r\n\r\n<p> The medical practitioner recommends rinsing the eye with saline to ease symptoms of chemical pink eye. The professionals can also prescribe topical steroids if the condition is severe.</p>\r\n\r\n<ul>\r\n <li><strong>Bacterial</strong></li>\r\n</ul>\r\n\r\n<p> Antibiotics are the best treatment for bacterial pink eye. For kids, professionals may recommend ointment. Antibiotic medication eases symptoms faster, but one should complete the course else the condition may reoccur.</p>\r\n\r\n<ul>\r\n <li><strong>Viral</strong></li>\r\n</ul>\r\n\r\n<p> Viral conjunctivitis treatment includes the same medicines required for easing the common cold. The doctor may suggest using a cloth moistened with warm water or a warm compress to soothe the symptoms.</p>\r\n\r\n<ul>\r\n <li><strong>Allergic</strong></li>\r\n</ul>\r\n\r\n<p> The medical professional may prescribe an antihistamine for allergic conjunctivitis to ease the inflammation. Some antihistamines are available as OTC or over-the-counter medicines to reduce allergic symptoms. Anti-inflammatory eye drops can also reduce the severity of the condition.</p>\r\n\r\n<h2>Is There Any Home Remedy Available?</h2>\r\n\r\n<p>You may use warm compresses or purchase eye drops to relieve the symptoms. But ensure that you practice these methods under the advice of a medical professional. Your healthcare practitioner may also recommend you stop wearing contact lenses for a few days.</p>\r\n\r\n<p>Pink eye may cause inflammation of the cornea in both children and adults, which may affect vision. Prompt treatment and evaluation by the health care provider mitigate the risks of complications like severe eye pain, light sensitivity, and blurred vision. In some cases, the individual may feel that there&#39;s something stuck in the eye.</p>\r\n\r\n<p>It is advisable to consult a doctor immediately in case of the following symptoms:</p>\r\n\r\n<ul>\r\n <li>The pus from the eyes is green or yellow in colour</li>\r\n <li>The infected individual is less than five years of age</li>\r\n <li>The condition is causing blurred vision</li>\r\n <li>The cornea becomes opaque instead of being clear</li>\r\n</ul>\r\n\r\n<p>The physician may ask you to undergo a few tests to assess your condition before suggesting the treatment.</p>\r\n\r\n<h2>Author Bio:</h2>\r\n\r\n<p>City X-Ray is a renowned diagnostic centre in Delhi offering diagnosis options like MRI, CT scans, PET scans, X-rays, DEXA, blood tests, and more.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'symptoms-of-conjunctivitis-viral-pink-eye-flu', 'eye-flu-symptoms.webp', '', 'Viral eye flu is popular by the term pink eye, where the eyes become red. Want to learn about viral eye flu symptoms? Pink eye or conjunctivitis is an inflammation of the transparent membrane conjunctiva lining the eyeball and eyelid.', 1, 'Why does Pink Eye Occur? Symptoms, Test For Conjunctivitis Eye Flu', 'Explore the comprehensive guide to Conjunctivitis, Pink Eye Flu: Understand their symptoms, causes, and available tests for accurate diagnosis.', 'viral eye flu symptoms, symptoms of conjunctivitis, conjunctivitis causes, conjunctivitis test, Viral conjunctivitis treatment', 'eye flu - conjunctivitis', '2023-09-01', '2023-11-03 10:36:50', '2023-12-20 03:50:14');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (32, 'What Is Dehydration & Its Symptoms, Precautions, Treatment', '<p>Dehydration is a major cause of several deaths and other critical health hazards in India and all over the world. In India, during the dry summers, many people fall sick and the doctor diagnose them as dehydrated.</p>\r\n\r\n<p>Before understanding dehydration, let’s first focus on what is dehydration and what are the most common dehydration signs and symptoms. Dehydration refers to a physiological state of the body when it lacks adequate water. There can be numerous reasons responsible for subjecting human body to such an acute water-deficient condition that further disrupts other essential physiological activities.</p>\r\n\r\n<p>All involuntary action of the body like digestion, assimilation, excretion, blood circulation, etc., relies on water. Therefore, when the level of water in the human body or any other animal body goes lower than its normal margin, dehydration sets in.</p>\r\n\r\n<p>The early symptoms or signs of dehydration can be detected and immediately treatment for dehydration should be initiated. Early detection always helps and makes the recovery process faster. The followings are a few common dehydration signs and symptoms that everyone should be aware of.</p>\r\n\r\n<h2>Symptoms Of Dehydration</h2>\r\n\r\n<p>Dehydration of the body is a gradual process in which the whole of the body does not abruptly turns water-deficient. During the initial few hours, the body begins to respond to the lack of water, the following symptoms surface.</p>\r\n\r\n<ul>\r\n <li>Fatigue</li>\r\n <li>Increased Thirst</li>\r\n <li>Dry Mouth</li>\r\n <li>Less Tear Production</li>\r\n <li>Decreased Urination</li>\r\n <li>Dry Skin</li>\r\n <li>Dizziness</li>\r\n <li>Constipation</li>\r\n <li>Headache</li>\r\n <li>Light-headedness</li>\r\n</ul>\r\n\r\n<p>However, if any of these symptoms surface and you still do not pay any attention to them, dehydration gradually starts to impact the entire body. When the majority of the body is facing an acute water supply crisis, the patient outreaches the fatal level of dehydration. The symptoms of such an advanced stage remain as follows.</p>\r\n\r\n<ul>\r\n <li>Excessive Thirst</li>\r\n <li>Low Blood Pressure</li>\r\n <li>Inadequate Sweating </li>\r\n <li>Faster Heart Rate</li>\r\n <li>Sunken Eyes</li>\r\n <li>Rapid Breathing</li>\r\n <li>Dark Urine</li>\r\n <li>Shrivelled Skin</li>\r\n</ul>\r\n\r\n<p>All these are signs that body experiences due to acute dehydration and needs immediate medical attention. In some cases, during acute dehydration, patients also suffer from issues like diarrhoea, stool with blood, and even disorientation.</p>\r\n\r\n<h2>Common Causes Of Dehydration</h2>\r\n\r\n<p>Whenever the body loses more water than it is being consumed, the process of dehydration initiates.  The common causes of dehydration remain many. There are few factors responsible for the development of mild to moderate dehydration of the body.</p>\r\n\r\n<h2>Sweating</h2>\r\n\r\n<p>Sweating is a normal and regular physiological process that ensures that the body temperature is maintained regardless of the atmospheric temperature. This is why people perspire more during the summer when the outside temperature is high.</p>\r\n\r\n<h2>Illness</h2>\r\n\r\n<p>When people suffer from critical illnesses for a long time they consume several medicines. This may lead to the consumption of more water in the body as medicine assimilation requires a lot of water. Therefore, almost all doctors suggest drinking more water when prescribing strong medicines.</p>\r\n\r\n<p>Now if a person is on regular medication and fails to follow this instruction, dehydration may set in. Additionally, diseases that make the patients throw up frequently or inflict diarrhoea can become a cause of dehydration.</p>\r\n\r\n<h2>Fever</h2>\r\n\r\n<p>Fever necessarily dries up the body every time the patient sweats heavily to keep the body temperature under check. Therefore, high fever conditions or prolonged fever can be a source of massive water and electrolyte loss, eventually leading to dehydration.</p>\r\n\r\n<h2>Urination</h2>\r\n\r\n<p>Urination is an essential physiological process to let go of the toxic elements of the body. But, the release of these elements needs an assistance of water.  A substantial portion of urine is water. Therefore, when someone urinates excessively due to chemical imbalances in the body or any other reasons the risk of dehydration increases.</p>\r\n\r\n<h2>Treatment And Precautions</h2>\r\n\r\n<p>Treatment of dehydration is not complex but timely detection of the problem helps in its treatment. Once the symptoms of dehydration surface the patient should get in touch with a medical expert instantly.</p>\r\n\r\n<p>Home remedies are applicable only for mild dehydration. For severe dehydration, a doctor consultation is a must.</p>\r\n\r\n<h2>Oral Rehydration Solutions (ORS)</h2>\r\n\r\n<p>Rehydrating the body remains the only way to reverse the dehydration process. Once the body begins to respond to dehydration, consuming plain water would not suffice. Consuming water with dissolved electrolytes would be necessary.</p>\r\n\r\n<p>The market has a wide variety of oral rehydrating solutions (ORS) available in various flavours as well. Consuming 2-3 litres of ORS within 4-58 hours might help overcome mild dehydration conditions.</p>\r\n\r\n<p>Alternatively, patients can also make a rehydrating solution at home by mixing half a teaspoon of salt and six tablespoons of sugar with one-litre water. Drinking this homemade solution repeatedly can reduce the effects of dehydration within a few hours.</p>\r\n\r\n<p>On the other hand, for severe dehydration, medical experts often administer saline to the patient to restore the body’s electrolyte levels alongside water.</p>\r\n\r\n<p>However, prevention is always better than cure. Therefore, it would be best to consume adequate water regularly so that you never face the problem of dehydration. Here are a few tips to keep your body hydrated.</p>\r\n\r\n<ul>\r\n <li>Drink enough water ( 3 litres at least) every day. In summer, drink more water. </li>\r\n <li>Stay away from caffeine, alcohol, and soda when the signs of dehydration appear.</li>\r\n <li>Try to keep your perspiration under control by wearing loose, light colour, comfortable garments in summer.</li>\r\n <li>After exercise sessions, drink water with dissolved electrolytes.</li>\r\n</ul>\r\n\r\n<h2>Impacts Of Dehydration On Health</h2>\r\n\r\n<p>The effects of dehydration can be various and sometimes even fatal. If the condition gets detected at an early stage, the treatment is easy. The common impacts of dehydration of the body remain as follows.</p>\r\n\r\n<ul>\r\n <li>Heat Exhaustion</li>\r\n <li>Heatstroke</li>\r\n <li>Heat Cramps</li>\r\n <li>Kidney Failure</li>\r\n <li>Low Blood Volume</li>\r\n <li>Coma</li>\r\n <li>Seizures Resulting From Electrolyte Loss</li>\r\n <li>Hypovolemic Shock</li>\r\n</ul>\r\n\r\n<p>Preventing dehydration is not a big task. You just have to be conscious about your daily fluid intake and must not ignore any sign of dehydration.</p>\r\n\r\n<h2>About City X-Ray & Scan Clinic Pvt. Ltd</h2>\r\n\r\n<p>City X-Ray & Scan Clinic Pvt. Ltd. is a reputed and reliable diagnostic laboratory and clinic located in Delhi. The clinic has a panel of experienced doctors who empathetically treat patients by applying their expertise and knowledge.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'what-is-dehydration-symptoms-causes', 'dehydration-symptoms.webp', '', 'Explore Dehydration - Recognize symptoms, understand causes, learn treatment options, take precautions, and be aware of its effects.', 1, 'Dehydration: Symptoms, Causes, Treatment and Precautions', 'Discover detailed insights into dehydration. Learn about its symptoms, causes, treatment, and precautions to safeguard your health. Uncover the potential effects of dehydration.', 'what is dehydration, treatment of dehydration, cause of dehydration, dehydration signs and symptoms, effects of dehydration', 'dehydration', '2023-07-28', '2023-11-18 04:39:25', '2023-12-20 03:51:04');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (33, 'What Is Chikungunya: Its Fever Symptoms, Tests & Treatment', '<p>The mosquito-borne illness, Chikungunya affects thousands of people each year. While the disease is lesser known than other mosquito-borne illnesses like malaria or dengue, its symptoms can get much more severe if left untreated.</p>\r\n\r\n<p>Chikungunya fever is a disease caused by the Chikungunya virus and is spread through mosquito bites, just like Dengue.It is most often mistake for flue or other illness because of its uncommon nature. This post will explore an overview of the Chikungunya disease, its symptoms, causes, and treatment procedure. Keep reading to find out.</p>\r\n\r\n<h2>What Exactly Is Chikungunya Fever?</h2>\r\n\r\n<p>Chikungunya fever is an illness caused due to the chikungunya virus. The virus spreads with the bite of a mosquito, and can even infect thousands of people at once, leading to a Chikungunya outbreak.</p>\r\n\r\n<p>The incubation period for Chikungunya fever is around 1-12 days (about 1 week 5 days). This means that the virus can take up to two weeks to completely show the Chikungunya fever symptoms. However, for the majority of the population, Chikungunya symptoms start showing between 3-7 days after getting bitten by the mosquito.</p>\r\n\r\n<h2>Symptoms Of The Disease</h2>\r\n\r\n<p>While Chikungunya symptoms usually match common flu or cold symptoms, they generally differ in terms of severity and intensity. This is why it is important to always get yourself checked in cases of an outbreak, or if someone close to you has been diagnosed with Chikungunya recently.</p>\r\n\r\n<h2>The Most Common Symptoms Of Chikungunya Include:</h2>\r\n\r\n<ul>\r\n <li>High fever, usually varying between 38 to 40 C.</li>\r\n <li>Severe chikungunya joint pain, or pain in the muscles and bones.</li>\r\n <li>Fatigue</li>\r\n <li>Pain in the area behind the eyes</li>\r\n <li>Rashes and redness in the body</li>\r\n <li>Continuous headaches for days</li>\r\n <li>Bleeding in extreme cases</li>\r\n <li>Diarrhoea and vomiting in case of children</li>\r\n <li>Nausea</li>\r\n</ul>\r\n\r\n<p>While death from Chikungunya is rare, symptoms can worsen before the virus leaves the body. Retro-orbital pain is most common in patients suffering from the disease.</p>\r\n\r\n<h2>How Do Dengue Symptoms Differ From Chikungunya?</h2>\r\n\r\n<p>Both diseases have some common symptoms, which can make it hard to differentiate between the two. However, some notable differences can be found between the symptoms of dengue and chikungunya.</p>\r\n\r\n<p>While both diseases can lead to rashes on the body, Dengue rashes are usually limited to the arms, legs, and feet, unlike Chikungunya, where rashes are spread over the entire body. </p>\r\n\r\n<p>Furthermore, Chikungunya does not affect the body’s natural platelet count. Additionally, dengue patients generally suffer a larger intensity of joint pain than chikungunya joint pain. Experts also believe that Chikungunya does not cause the lymph nodes in the neck and groin region to enlarge, unlike someone suffering from Dengue.</p>\r\n\r\n<h2>How Is Chikungunya Disease Caused?</h2>\r\n\r\n<p>The disease is caused primarily due to the Chikungunya virus. However, the mode by which it spreads involves the bite of an Aedes mosquito, which is the main Chikungunya cause in a way.</p>\r\n\r\n<p>When the male Aedes mosquito bites someone already infected by the disease, and then goes on to bite a healthy person. Therefore, the mosquitoes carrying the virus can act as carriers for the chikungunya disease.</p>\r\n\r\n<p>While the actual disease can only be caused by the Chikungunya virus, many other viruses like the Zika virus or the dengue virus can impose symptoms similar to those of Chikungunya. This is why it is always recommended to consult a doctor whenever these flu-like symptoms persist for a long time.</p>\r\n\r\n<h2>How Is The Disease Diagnosed?</h2>\r\n\r\n<p>When the patient goes to the hospital, the doctor might conduct a series of tests to find the underline cause of the disease. However, most of the time the doctor only recommends a blood test to provide a definitive diagnosis of the symptoms.</p>\r\n\r\n<p>Additionally, certain laboratory diagnosis tests such as neutralizing antibodies or using plasma to check for viruses can also be recommended by certain doctors. If you are living in an area that recently had an outbreak of chikungunya, it is important to get it checked as soon as possible, so that you can treat it accordingly.</p>\r\n\r\n<h2>Risk Factors For The Disease</h2>\r\n\r\n<p>It is tricky to predict who is more prone to get infected, but certain factors might make you prone to the disease. Below are some risk factors that might increase your chances of getting infected by the Chikungunya virus:-</p>\r\n\r\n<ul>\r\n <li><strong>Age</strong></li>\r\n</ul>\r\n\r\n<p>Naturally, people with lower levels of immunity are more likely to catch the disease during an outbreak. This includes the aged, children below the age of 13, and pregnant women. The infection in older citizens and infants can even be fatal, which is why it is important to keep people in these age groups quarantined during a Chikungunya outbreak.</p>\r\n\r\n<ul>\r\n <li><strong>Rainy Weather</strong></li>\r\n</ul>\r\n\r\n<p>The Aedes mosquito breeds in stagnant water, and attacks during the day. This is why the probability of catching the disease grows during the rainy season when standing water in mud pools becomes a breeding ground for these mosquitos.</p>\r\n\r\n<ul>\r\n <li><strong>General Fitness</strong></li>\r\n</ul>\r\n\r\n<p>Apart from age and weather, a person’s general fitness level can also impact their likeliness to catch the disease. People with conditions like diabetes, high blood pressure, or high cholesterol are more prone to get infected than others.</p>\r\n\r\n<h2>Precautions To Take To Prevent The Disease</h2>\r\n\r\n<p>During an epidemic, make sure to take adequate measures to prevent yourself from getting infected by the virus. Take preventive measures even when there is no outbreak, to protect yourself from other mosquito-borne illnesses and cases of flu.</p>\r\n\r\n<ul>\r\n <li>Always keep a mosquito-repellent cream or lotion with you and rub it all over your body during the night.</li>\r\n <li>Wear appropriate full-sleeved clothes that cover your arms and legs.</li>\r\n <li>Use mosquito nets while sleeping.</li>\r\n <li>Avoid keeping stagnant water inside your home or in your neighbourhood.</li>\r\n <li>Use mosquito-killing liquid vaporizers</li>\r\n</ul>\r\n\r\n<h2>Treatments For Chikungunya</h2>\r\n\r\n<p>While the viral disease cannot be cured by medicinal aid, chikungunya treatment primarily involves treating its symptoms, such as:</p>\r\n\r\n<ul>\r\n <li>Getting plenty of rest</li>\r\n <li>Eating a nutritious diet</li>\r\n <li>Drinking plenty of fluids and staying hydrated</li>\r\n <li>Taking paracetamol to treat fever</li>\r\n</ul>\r\n\r\n<h2>Conclusion</h2>\r\n\r\n<p>If you or someone you know has been recommended a blood test, it is important to choose a lab where you get the best and the most accurate results. This is why you should consider visiting City X-Ray in Delhi NCR for any sort of scans including ultrasounds, X-Rays, Mammography, TMT tests, CT scans, MRIs, blood tests, etc.</p>\r\n\r\n<p><strong>DISCLAIMER</strong>: THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'chikungunya-fever', 'chikungunya-symptoms.webp', '', 'Discover how to recognize, diagnose, and treat Chikungunya disease. Learn about its symptoms and effective methods of diagnosis and treatment.', 1, 'What Is Chikungunya Fever, Symptoms, Cause, Test and Prevention', 'Learn about Chikungunya fever: its symptoms, causes, diagnostic tests, and prevention methods. Understand this viral disease in just a few words.', 'chikungunya disease, chikungunya causes, chikungunya symptoms, symptoms of chikungunya, chikungunya fever, chikungunya fever symptoms, chikungunya treatment', 'Chikungunya', '2023-07-06', '2023-11-18 05:42:58', '2023-12-20 03:51:55');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (34, 'Pneumonia Outbreak: Know The Type, Symptoms, Causes And Test', '<p>Pneumonia is a lung infection affecting one or two lungs. The disease occurs due to bacteria, fungi, or viruses. In today&#39;s world, it has become a serious health condition. Patients with chronic signs of pneumonia may have their air sacs filled with liquids and pus. Lobar pneumonia affects the lung lobes, while bronchial pneumonia affects the patches throughout both lungs. Let&#39;s learn the types, causes, symptoms, and more.</p>\r\n\r\n<h2>How Do You Get Pneumonia</h2>\r\n\r\n<p>Pneumonia is the inflammation in the lungs due to viral, bacterial, and fungal infections. Patients may develop signs like cough and fever. The COVID-19 may be one of the causes of pneumonia. Treatment varies depending on the disease&#39;s severity.</p>\r\n\r\n<p>A patient may develop symptoms through the air (via bacteria and viruses). The following are the prime causes of pneumonia in adults and infants:</p>\r\n\r\n<ul>\r\n <li><strong>Viruses</strong></li>\r\n</ul>\r\n\r\n<p>Viruses, including coronavirus, cause the flu and colds, which lead to pneumonia. In short, viruses are common causes of the disease, especially in children below five years of age. Although viral pneumonia is mild, the world has seen real-life examples of COVID-19 pneumonia. So, it may also become serious depending on the condition of the patient.</p>\r\n\r\n<ul>\r\n <li><strong>Bacteria</strong></li>\r\n</ul>\r\n\r\n<p>Bacterial pneumonia is the most common among other types. Streptococcus pneumonia is the common type occurring in patients with symptoms of flu or cold. Alternatively, it develops on its own. It affects the lobe (one part) of your lung and causes lobar pneumonia.</p>\r\n\r\n<ul>\r\n <li><strong>Fungi</strong></li>\r\n</ul>\r\n\r\n<p>The next type is fungal pneumonia, caused due to already existing chronic health issues or a weak immune system. The fungi causing it lie in the bird droppings or soil, varying depending on the geographical factor.</p>\r\n\r\n<ul>\r\n <li><strong>Bacteria-Like Organisms</strong></li>\r\n</ul>\r\n\r\n<p>There are other bacteria-like organisms which may contribute to the condition. For instance, Mycoplasma pneumonia is a type that produces milder symptoms. Another example is walking pneumonia, which isn&#39;t that severe, but doctors may instruct you to take complete bed rest.</p>\r\n\r\n<h2>Understanding The Types Of Pneumonia: What Are They?</h2>\r\n\r\n<p>Pneumonia is an infection where viruses, fungi, or bacteria affect one or both the lungs. The following are the types of pneumonia:</p>\r\n\r\n<h2>Community-Acquired Pneumonia</h2>\r\n\r\n<p>CAP, or community-acquired pneumonia, is a common acute infection. If a patient develops symptoms, they may need to take admission to the hospital. Its prime causative pathogens are influenza A, Streptococcus pneumoniae, Chlamydophila pneumoniae, and Mycoplasma pneumonia. Risk factors that may result in developing this infection are smoking, comorbidities, or age.</p>\r\n\r\n<h2>Hospital-Acquired Pneumonia</h2>\r\n\r\n<p>The next type is HAP or Hospital-acquired pneumonia. A patient can get hospital-acquired pneumonia (HAP) when admitted to a hospital due to other severe illnesses. HAP is a serious pneumonia type, as antibiotic-resistant bacteria can cause it. The most common antibiotic-resistant bacterium is the MRSA or methicillin-resistant Staphylococcus aureus. HAP symptoms are severe and aren&#39;t easily treatable.</p>\r\n\r\n<h2>Ventilator-Associated Pneumonia</h2>\r\n\r\n<p>VAP or ventilator-associated pneumonia is a lung infection developing in an individual in ventilation. Anyone using an artificial breathing machine may tend to develop this pneumonia. The bacteria developing community-acquired pneumonia is the one that causes this illness.</p>\r\n\r\n<h2>Healthcare-Associated Pneumonia</h2>\r\n\r\n<p>HCAP develops in patients who are in a long-term care facility, for instance, a nursing home. Anyone in an extended-stay clinic may develop the symptoms. The symptoms are the same as hospital-acquired pneumonia caused by antibiotic-resistant bacteria.</p>\r\n\r\n<h2>Aspiration Pneumonia</h2>\r\n\r\n<p>Aspiration pneumonia occurs in individuals when liquid or food gets inside the lungs or airways instead of getting swallowed. Vomit or spit can also trap inside the trachea (or windpipe), from where it travels to the lungs. That&#39;s how it affects the lungs.</p>\r\n\r\n<h2>What Are The Symptoms Of Pneumonia</h2>\r\n\r\n<p>The common signs of pneumonia include the following:</p>\r\n\r\n<ul>\r\n <li>Yellow, bloody, or green cough</li>\r\n <li>Excessive sweating</li>\r\n <li>Fever</li>\r\n <li>Confused mental state, especially in elders</li>\r\n <li>Loss of appetite</li>\r\n <li>Bluish colour to fingernails or lips</li>\r\n <li>Fatigue or low-energy</li>\r\n <li>Rapid pulse</li>\r\n <li>Breathing difficulties</li>\r\n <li>Chills</li>\r\n <li>Stabbing or sharp chest pain worsening with coughing or deep breathing</li>\r\n</ul>\r\n\r\n<h2>The Early Symptoms Of Viral Or Bacterial Pneumonia Include The Following:</h2>\r\n\r\n<ul>\r\n <li>Shortness of Breath</li>\r\n <li>Headache</li>\r\n <li>Weakness</li>\r\n <li>Worsening cough</li>\r\n <li>Muscle pain</li>\r\n</ul>\r\n\r\n<p>Besides, older adults may experience weakened immune systems or mental issues. Pneumonia in newborn babies and infants might not show any other early signs apart from vomiting, fever, tiredness, restlessness, and cough.</p>\r\n\r\n<h2>What Is The Main Cause Of Pneumonia?</h2>\r\n\r\n<p>The prime cause of pneumonia is bacterial, viral, or fungal infection. The pathogens enter your lungs and contribute to inflammation, thereby weakening your immune system. Some health-related parameters may increase the chances of developing symptoms of pneumonia in infants.</p>\r\n\r\n<p>The factors affecting individuals are the immune system, underlying health issues and age. Ever germs may lead to the disease which you breathe. The body usually prevents the germs from infecting the lungs. However, there are times when these germs weaken the immune system and lead to crucial health concerns.</p>\r\n\r\n<h2>What Causes Pneumonia In Adults?</h2>\r\n\r\n<p>The causes of pneumonia in adults and new-borns may be due to bacteria, viruses, and some fungi. Bacterial pneumonia is easily treatable, resulting from Haemophilus influenzae, Streptococcus pneumoniae, or Staphylococcus aureus. On the contrary, viral pneumonia occurs due to respiratory syncytial viruses, influenza viruses, or coronaviruses.</p>\r\n\r\n<p>Pneumocystis jirovecii is the fungus causing symptoms of pneumonia in adults with weak immune systems. There are risk factors where adults can develop pneumonia: respiratory conditions, smoking, weak immune systems, diseases, and environmental pollutants.</p>\r\n\r\n<p>So, treating symptoms of pneumonia in adults requires identifying the causes and diagnosis for managing the condition seamlessly.</p>\r\n\r\n<p>The treatment and test for pneumonia are vital to help manage pneumonia, thereby preventing the condition from worsening.</p>\r\n\r\n<h2>How Long Does Pneumonia Last?</h2>\r\n\r\n<p>Some individuals may return to their schedule within 1 to 2 weeks of rest. But it may take more than a month (or even longer) for people with weakened immune systems. During the healing phase, patients may feel fatigued or need complete bed rest. One should consult the medical associate to learn about the diagnostic test for pneumonia.</p>\r\n\r\n<p>City X-ray is a renowned diagnostic centre in Delhi. Consult this path lab that offers the COVID-19 test for pneumonia, CT scan, MRI, PET scan, X-ray, Ultrasound, DEXA, Blood tests, Mammogram and more in Delhi NCR.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'pneumonia-type-symptoms-causes', 'pneumonia-symptoms.webp', '', 'Pneumonia is a lung infection Which primarily affecting the small air sacs known as alveoli gernally it caused by viruses or bacteria.', 1, 'Pneumonia Outbreak: Know the Type, Symptoms, Causes and Test', 'Pneumonia outbreak primarily affecting the small air sacs, other symptoms like difficulty breathing, chest pain, persistent fever of 102F and cough. Book a Test', 'bacterial pneumonia, types of pneumonia, causes of pneumonia, signs of pneumonia, pneumonia in newborn, symptoms of pneumonia in adults, symptoms of pneumonia in infants, causes of pneumonia in adults', 'Pneumonia', '2023-12-15', '2023-12-18 05:40:54', '2023-12-20 03:44:43');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (35, 'Silent Threat - Blood Cancer Symptoms, Type, Causes, And Test', '<p>Cancer is a severe ailment that affects different parts of the body. One of the types is blood cancer, also referred to as haematological malignancy or haematologic cancer. Commonly, there are three types of blood cancer.</p>\r\n\r\n<p>It occurs with abnormal cell growth in bone marrow (spongy tissues inside the bones where blood cells produce) or blood. These abnormal cells infer the functions of normal blood cells, combating infections and producing new blood cells. This all-encompassing post elaborates on the symptoms of blood cancer, its types, causes, diagnosis, and treatments.</p>\r\n\r\n<h2>An Overview Of The Various Types Of Blood Cancer</h2>\r\n\r\n<p>Blood cancer alters the way blood cells behave inside the body. In general, there are three types of blood cells:</p>\r\n\r\n<ul>\r\n <li>White blood (combating infection)</li>\r\n <li>Red blood cells (carrying oxygen to different organs and tissues and bringing CO2 to lungs)</li>\r\n <li>Platelets (forming blood clots when injured)</li>\r\n</ul>\r\n\r\n<p>There are three prime types of blood cancer: lymphoma, myeloma, and leukaemia. Considering these types, the following are the subcategories of blood cancer:</p>\r\n\r\n<h2>Leukaemia</h2>\r\n\r\n<p>This type originates in the bone marrow and blood. The malignant tumour forms when the body creates multiple abnormal WBCs and interferes with the ability of bone marrow to produce RBS and platelets.</p>\r\n\r\n<h2>Hodgkin Lymphoma</h2>\r\n\r\n<p>It usually occurs in the lymphatic system from cells, also known as lymphocytes. When abnormal lymphocyte is present in the system, it forms cancer. These abnormal cells are Reed-Sternberg cells.</p>\r\n\r\n<h2>Non-Hodgkin Lymphoma</h2>\r\n\r\n<p>Non-Hodgkin lymphoma is another type of blood cancer developing in the lymphatic system. It forms from lymphocytes, the white blood cells responsible for fighting infections.</p>\r\n\r\n<h2>Multiple Myeloma</h2>\r\n\r\n<p>This type originates in the plasma cells in the bone marrow. There are various stages involved in this type.</p>\r\n\r\n<p>Other less common categories of blood cancer are below:</p>\r\n\r\n<h2>MPNs Or Myeloproliferative Neoplasms</h2>\r\n\r\n<p>MPNs are rare blood cancers that form with the overproduction of platelets, red blood cells, and white blood cells. The three prime categories of this cancer include the following:</p>\r\n\r\n<ul>\r\n <li>Myelofibrosis (MF)</li>\r\n <li>Thrombocythemia (ET)</li>\r\n <li>Polycythemia Vera (PV)</li>\r\n</ul>\r\n\r\n<h2>MDS Or Myelodysplastic Syndromes</h2>\r\n\r\n<p>Again, MDS is a rare type of blood cancer that occurs due to the damage in blood-producing cells in the bone marrow.</p>\r\n\r\n<h2>Waldenstrom Macroglobulinemia</h2>\r\n\r\n<p>Also referred to as Waldenström&#39;s, it is another rare cancer in the white blood cell. This cancer type is slow-growing compared to non-Hodgkin lymphoma. It occurs in the bone marrow and slows the growth of blood cells. This leads to anaemia and a weak immune system.</p>\r\n\r\n<h2>Aplastic Anaemia</h2>\r\n\r\n<p>Although it&#39;s a rare blood cancer, it&#39;s a severe type occurring when the bone marrow fails to make new blood cells naturally. Some surveys suggest that it&#39;s not a type of cancer, but the treatments are similar to therapies used for lymphomas and leukaemia.</p>\r\n\r\n<h2>Amyloidosis</h2>\r\n\r\n<p>Amyloidosis might have a close association with blood cancers (multiple myeloma), but it is not a cancer itself. Characterised by abnormal protein (amyloid) build-up, it results in a severe condition.</p>\r\n\r\n<h2>Outlining The Signs And Symptoms Of Blood Cancer</h2>\r\n\r\n<p>The various signs and symptoms of blood cancer include the following:</p>\r\n\r\n<ul>\r\n <li>Severe fatigue</li>\r\n <li>Chills and fever</li>\r\n <li>Loss of appetite</li>\r\n <li>Nausea</li>\r\n <li>Inexplainable weight loss</li>\r\n <li>Joint or bone pain</li>\r\n <li>Night sweats</li>\r\n <li>Headaches</li>\r\n <li>Abdominal discomfort</li>\r\n <li>Breathing difficulties</li>\r\n <li>Skin rashes and itchiness</li>\r\n <li>Swollen lymph nodes in underarms, groin, or neck</li>\r\n <li>Reoccurrence of infections</li>\r\n</ul>\r\n\r\n<h2>Everything About The Causes Of Blood Cancer</h2>\r\n\r\n<p>Blood cancer occurs due to mutations in DNA within the blood cells. It causes blood cells to start working abnormally. The changes have a close relation to people&#39;s lifestyles. Although there are no evident surveys based on the causes of cancer development, a few parameters might affect the risk. The following might be a few causes of blood cancer:</p>\r\n\r\n<ul>\r\n <li>Advancing age</li>\r\n <li>Sexual habits</li>\r\n <li>Ethnicity</li>\r\n <li>Family history or genetics</li>\r\n <li>Exposure to chemicals or high doses of radiation</li>\r\n <li>History of other blood cancers</li>\r\n <li>Obesity</li>\r\n <li>Other health conditions like autoimmune diseases (lupus or rheumatoid arthritis)</li>\r\n <li>Compromised or weakened immune system</li>\r\n</ul>\r\n\r\n<h2>Test For Blood Cancer: Understanding The Diagnosis Options For Blood Cancer</h2>\r\n\r\n<p>Diagnosis for blood cancer begins with a physical examination to assess the patient&#39;s medical condition. The doctors first reviews the medical history before examining the body and lymph nodes. Then, the expert doctors looks for signs of blood cancer.</p>\r\n\r\n<p>Through different tests, the medical professional diagnoses blood cancer. Here&#39;s the list explaining each test for blood cancer in detail:</p>\r\n\r\n<ul>\r\n <li><strong>Biopsies</strong></li>\r\n</ul>\r\n\r\n<p>It collects samples of cells in a laboratory. For lymphoma, patients require a lymph node biopsy for the sample of lymph tissue or the lymph node. With the help of bone marrow screening, diagnosis of the type of cancer occurs.</p>\r\n\r\n<p>Oncologists use bone marrow aspiration, a process to eliminate a small sample of the bone marrow, bone, and blood. They eliminate it from the breastbone or hip bone. In the lab, the sample assesses whether there are any abnormal cells.</p>\r\n\r\n<ul>\r\n <li><strong>Blood Tests</strong></li>\r\n</ul>\r\n\r\n<p>CBC, or complete blood count, demonstrates the cell count of various blood components like RBCs, WBCs, and platelets. Blood chemistry screening measures the levels of substances in blood. Abnormal protein levels offer details about the health condition of the patient.</p>\r\n\r\n<p>In case of multiple myeloma, the medical associate checks the blood calcium level of the patient. On the contrary, the oncologist measures an enzyme (lactate dehydrogenase) for suspected lymphoma.</p>\r\n\r\n<ul>\r\n <li><strong>Imaging Scans</strong></li>\r\n</ul>\r\n\r\n<p>An imaging scan detects the enlarged lymph node, commonly occurring in case of lymphoma. Scans help to detect whether the cancer has spread to different part of the body. A few scans include the following:</p>\r\n\r\n<ul>\r\n <li>X-Ray</li>\r\n <li>MRI or Magnetic resonance imaging</li>\r\n <li>CT (computed tomography) scan</li>\r\n <li>Ultrasound</li>\r\n <li>PET (positron emission tomography) scan</li>\r\n</ul>\r\n\r\n<p>Medical associates can also use imaging scans during biopsies to identify the affected area.</p>\r\n\r\n<h2>Learning The Various Blood Cancer Treatments</h2>\r\n\r\n<p>The following are the categories of blood cancer therapies:</p>\r\n\r\n<ul>\r\n <li>Chemotherapy</li>\r\n <li>Radiation therapy</li>\r\n <li>Targeted therapies</li>\r\n <li>Stem cell transplantation</li>\r\n <li>Cancer Surgery</li>\r\n <li>Immunotherapy</li>\r\n</ul>\r\n\r\n<p>About the Company: City X-Ray & Scan Clinic Pvt. Ltd. is a renowned diagnostic clinic and path lab in Delhi. Our expert Professionals collect free blood samples. At the company, experts conduct accurate screening like CT scans, ultrasound, and many more for blood cancer detecting tests and other ailments.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'blood-cancer-symptoms-type-causes-and-test', 'blood-cancer-symptoms.webp', '', 'Unveiling the Silent Threat: Exploring Blood Cancer - Symptoms, Types, Causes, and Tests for Early Detection', 1, 'Silent Threat - Blood Cancer Symptoms, Type, Causes, and Test', 'Blood Cancer is a Silent Killer: In this article let\'s explore Blood Cancer -  its Symptoms, Types, Causes, and Tests for Early Detection', 'types of blood cancer,  blood cancer treatment, symptoms of blood cancer, test for blood cancer, causes of blood cancer', 'Blood cancer', '2023-11-15', '2023-12-18 05:42:34', '2023-12-20 03:46:01');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (36, 'Malaria Fever And Its Symptoms How To Treat And Prevent Malaria Fever', '<p>Malaria fever is one of the most dreaded diseases in the Indian subcontinent that afflicts people who have been bitten by mosquitoes which are infected with tiny parasites. The serious disease is caused by parasites, and not by any virus or bacteria. Malaria needs to be treated quickly because if left untreated, it can lead to several serious conditions such as seizures, trouble in breathing, organ failure, and even death. However, most patients of malaria today get the treatment and recover soon.</p>\r\n\r\n<h2>Symptoms Of Malaria Fever</h2>\r\n\r\n<p>Some of the signs and symptoms of malaria fever include fever, sweating, muscle aches, headaches, fatigue, chills that shake the entire body, diarrhoea, chest pain, cough, vomiting, and nausea.</p>\r\n\r\n<p>When these symptoms of malaria fever are left untreated, they can lead to anaemia and jaundice. There is a very severe form of the disease that can lead to a fever of the brain. It can cause deaths in both children and adults.</p>\r\n\r\n<p>An important point to note about the disease is that symptoms not become apparent immediately after the infection. It can take several days and even sometimes more than a week for symptoms to become apparent after the person has been infected. Also, depending on the kind of parasites that have infected the particular person, symptoms can range from mild to severe. In fact, research shows that parasites can live in the body for several years before the symptoms appear!</p>\r\n\r\n<p>Malaria symptoms reoccur when the parasites start circulating in the bloodstream after being dormant for a long time.</p>\r\n\r\n<p>Prevention of Malaria</p>\r\n\r\n<p>Protect yourself and your family in several ways from the dreaded disease. Take prevention and proactive steps so that the disease cannot affect your family. India almost completely eradicated the disease but it came back with a vengeance in the 1970s, taking root in most rural and urban areas. </p>\r\n\r\n<h2>Preventive Measures For Malaria </h2>\r\n\r\n<ol>\r\n <li>Traveling to a Mosquito-infested Place: If you have plans to travel to a place that is infested with mosquitoes, take preventive measures. Go to your doctor or health care provider and ask for vaccination you can take to protect yourself. Try and stay clear of areas where there are too many mosquitoes.</li>\r\n <li>Clothing: Wear protective clothing such as ones that cover your arms and legs as much as possible when going out.</li>\r\n <li>Repellent: Common malaria symptoms can be prevented if you apply mosquito repellants on the exposed parts of your body. This holds especially true for the face, hands, and feet, where mosquitoes find it easy to access human skin. There are few mosquito repellants available that are not harmful to the skin.</li>\r\n <li>Sleep: Prevention of malaria is also quite easy when you take effective precautions while you sleep. Mosquito nets are ubiquitous in the country and have been holding out strong for decades. They keep the insects and pests away and using them over the bed at night gives you great protection. You must use one if you don’t have a screening on your windows or air-conditioner.</li>\r\n <li>Cleanliness: Prevention of malaria is easy when you keep your home and surroundings neat and tidy. Throw away things that are no longer in use. This is useful because mosquitoes find it easy to breed in or near things that are not being used much or lie around without being touched. Thrown them out and make sure there is no way these pests find space in your home.</li>\r\n <li>Get Rid of Stagnant Water: The symptoms of malaria fever persist for a long time. Get rid of any collecting or stagnant water in the surroundings because these are area where mosquitoes breed.</li>\r\n <li>Listen to Your Doctor: In case you get malarial symptoms or a family member does, go and see the doctor as soon as possible. Don’t take symptoms lightly because, within a few hours or days, these symptoms can worsen, leaving you horrified and in need of immediate hospitalization! If the doctor has asked you to start a medicinal course, do it and make sure to complete the course. Always make sure the fever is kept under control and in case it gets too high, let the doctor know and follow the instructions.</li>\r\n</ol>\r\n\r\n<h2>Treatment Of Malaria Fever</h2>\r\n\r\n<p>Malaria fever treatment will commence only after the doctor has diagnosed the disease. A few steps are involved:</p>\r\n\r\n<ul>\r\n <li>Give your travel and medical history.</li>\r\n <li>Undergo a test that will reveal whether you have malarial parasites in your bloodstream.</li>\r\n <li>Get tested to see if there are any serious complications.</li>\r\n</ul>\r\n\r\n<p>Remember, that there may be more than one test involved to detect malaria and the results may take up to a few days to come. Once diagnosed, your treatment starts. Here are things to know:</p>\r\n\r\n<p>Anti-malaria medications are the first line of treatment. The idea is to kill the parasites. Now the type of medication given to you will be dependent on several factors like your age, whether you are pregnant or nursing, and what medical history you have.</p>\r\n\r\n<p>After the malaria fever test, the most common medications usually given to patients are ACTs and Chloroquine phosphate.</p>\r\n\r\n<h2>What Malaria Can Feel Like?</h2>\r\n\r\n<p>Malaria is one of the most common diseases in India. The duration of malaria fever will be at least 2 weeks. During this period, symptoms can get better for some time and then worsen but if proper treatment is provided, it usually takes around 3 weeks to recover. Most patients of malaria who experience life-threatening symptoms ignore earlier symptoms and does not get the treatment required. That is why it is extremely important to provide a proper treatment action plan as soon as possible.</p>\r\n\r\n<p><strong>About City X-Ray & Scan Clinic Pvt. Ltd.:</strong> City X-Ray & Scan Clinic Pvt. Ltd. is a well-known diagnostic lab and clinic in Delhi with the availabity of free home collection of samples. They perform accurate tests for malaria fever and more.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'malaria-fever-symptoms', 'malaria-fever-symptoms.webp', '', 'Learn about Malaria Fever, its symptoms, effective treatment options, and essential prevention methods in this concise guide.', 1, 'Common Symptoms of Malaria Fever Treatment, and Prevention', 'Learn about Malaria Fever, its symptoms, effective treatment options, and essential prevention methods in this concise guide. Stay informed and safeguard your health.', 'symptoms of malaria fever, malaria symptoms, common malaria symptoms, malaria fever treatment, malaria fever test, prevention of malaria, duration of malaria fever', 'malaria fever', '2023-06-17', '2023-12-18 06:02:50', '2023-12-20 03:52:33');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (37, 'Common Monsoon Diseases In Rainy Season | Symptoms | Prevention - 2023', '<p>The monsoon season in India brings great enjoyment in most parts of the country because of the relief it brings from the hot summer months. The plains especially have severely hot weather all through the summer and people wait for the monsoon season. Though it is a time when people breathe a sigh of relief at the rains, it is also when a host of diseases crop up. Many monsoon diseases and infections can affect the life and health of you and your family. Let’s look at them and how most of them can be prevented with ease and precautions.</p>\r\n\r\n<h2>Diseases Caused By Mosquitoes</h2>\r\n\r\n<p>In rainy season, mosquitoes breed and India has a real problem with mosquito-borne illnesses. Some of the diseases caused by mosquitoes during the season are:</p>\r\n\r\n<ul>\r\n <li><strong>Malaria:</strong> It is a major concern for both children and adults during the monsoons. Plasmodium, which is a single-cell parasite, causes this disease. The parasites breed in streams and water channels and are usually accompanied by intermittent fever that can last for several days to weeks.</li>\r\n <li><strong>Chikungunya:</strong> The non-fatal viral disease is caused by mosquitoes. Mosquitoes that breed and live in stagnant water cause this disease. These mosquitoes bite not just during the daytime but also during the night so precautionary measures are required.</li>\r\n <li><strong>Dengue:</strong> The mosquitoes that cause this monsoon disease also breed and live in stagnant water and bite human beings all through the day and night. Dengue patients will experience stiffness in the arms and legs and also joint pains.</li>\r\n</ul>\r\n\r\n<h2>Diseases Caused By Substandard Water</h2>\r\n\r\n<p>The diseases in the rainy season can be caused by substandard quality of water. The worst affected by water-borne diseases are children though and the most common of them are mentioned below:</p>\r\n\r\n<ul>\r\n <li><strong>Typhoid:</strong> dangerous bacteria and poor sanitation is usually the reason for the disease. Children drinking contaminated water or eating uncovered or contaminated food will usually be afflicted with diseases during the rainy season. Sore throat, joint pain, headache, and fever are the most common symptoms of this dreaded disease.</li>\r\n <li><strong>Jaundice:</strong> One of the most common diseases during rainy season, Jaundice, which is caused by eating contaminated food or drinking contaminated water. Caused by the unsanitary conditions people live in, the monsoons make the situation worst. Jaundice can be identified by symptoms such as vomiting, yellowing of eyes, yellow urine, fatigue, and weakness.</li>\r\n <li><strong>Cholera:</strong> Once upon a time, Cholera was one of the most fatal monsoon diseases in India. It created havoc within the society. Though its efficacy is now much lower across the country, the disease is still dreaded across the country.</li>\r\n <li><strong>Hepatitis A:</strong> The viral infection can be terrible for the body and can cause sudden loss of appetite. It can affect the liver and lungs.</li>\r\n</ul>\r\n\r\n<h2>Diseases That Spread Through Air</h2>\r\n\r\n<p>Some monsoon diseases spread through air and these are pretty common across the length and breadth of the country. Air-borne infections get transmitted by disease-causing pathogens and the good news is, these are usually mild. However, do not assume that they are always going to have a mild effect on the body. Children and senior people with weak immune systems can be greatly affected by them.</p>\r\n\r\n<ul>\r\n <li><strong>Common Cold and Flu:</strong> These are very common and are usually caused as temperatures keep fluctuating during the rainy season. The diseases in the monsoon season can affect the body more in case the immune system is weak. Fever, chills, sore throat, and runny nose are common symptoms.</li>\r\n <li><strong>Influenza:</strong> This is also described as the common flu and gets transmitted from one person to the next through the air.</li>\r\n</ul>\r\n\r\n<h2>Preventing Common Diseases During Rainy Season</h2>\r\n\r\n<p>With diseases and infections incredibly common during the monsoons, prevention is always better than cure. Here are some tips that will help:</p>\r\n\r\n<ul>\r\n <li>With common diseases in the rainy season such as those that are mosquito-borne, keep yourself and your family safe with mosquito nets during the night. Use them during the day as well if a family member is napping as there is always possibility that mosquitoes will bite.</li>\r\n <li>Wash bathrooms thoroughly as frequently as possible and maintain sanitized spaces all the time.</li>\r\n <li>Stop collecting water anywhere in and around the house if you have a habit of doing so. They are great places for mosquitoes to breed. Also, throw away any stagnant water that may already be present.</li>\r\n <li>Mosquito repellants and creams are great for the rainy season and protect adults and children from many mosquito-borne diseases. Apply liberally on the skin or spray on clothes before stepping out.</li>\r\n <li>High-quality water is essential for human health and fitness therefore, Avoid drinking water from the roadside or any unsanitary place. Carry your own water at all times whenever outside. At home, make sure to drink water from a water purifier. If you do not have one, boil the water, and straining, is one of the safest ways to ensure potable drinking water for the whole family.</li>\r\n <li>Vegetables and fruits are another cause of monsoon diseases in India. Wash vegetables and fruits before consumption. Do it thoroughly.</li>\r\n <li>If there are potholes or open drains in the locality, make sure they get covered.</li>\r\n <li>Maintain personal hygiene all the time especially when you are traveling.</li>\r\n <li>To prevent diseases that get transmitted through the air, stay away from people who are openly coughing or sneezing. Cover your nose and mouth when you are sneezing or coughing. Monsoon fever can be prevented by ensuring the home is well-ventilated at all and clean.</li>\r\n</ul>\r\n\r\n<p>The excessive moisture content during Indian monsoons is what causes most of the diseases and infections that affect adults and children during the season. Eating fresh and homemade food and ensuring personal hygiene will keep you safe from most of them.</p>\r\n\r\n<p><strong>DISCLAIMER: </strong>THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE. The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'common-monsoon-diseases', 'common-diseases-in-rainy-season.webp', '', 'Explore common monsoon diseases in the rainy season, their symptoms, and effective prevention strategies.', 1, 'Most Common Monsoon Diseases During Rainy Season in India', 'Explore common monsoon diseases in the rainy season, their symptoms, and effective prevention strategies. Know common fever caused by mosquito bite', 'monsoon diseases, diseases in rainy season, common diseases during rainy season, monsoon diseases in india, monsoon fever', 'monsoon diseases', '2022-08-27', '2023-12-18 06:08:16', '2024-03-05 01:02:39');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (38, 'Know Diabetes And Type, Symptoms, Causes, Treatment, And Prevention', '<p>As the diabetes capital of the world, it can be safely said that diabetes symptoms are something that should be made common in knowledge. While this is a notorious title to possess, the thing to understand is that it does not refer to just one disease alone. In fact, Diabetes Mellitus refers to a group of diseases that affects the way your body uses glucose, commonly known as sugar. Low blood sugar symptoms can be incredibly common among people in India.</p>\r\n\r\n<p>While there are still many people who think that consuming sugar causes diabetes, the truth is wholly different and quite complicated. This is because glucose is one of the most important sources of energy for the cells in the body and it is the main source of energy for the brain cells primarily. How your body uses glucose and whether your blood contains a lot of it is a point of concern and something that gets tested. This article talks about the types, symptoms, causes, treatment, and prevention of diabetes.</p>\r\n\r\n<h2>Types Of Diabetes</h2>\r\n\r\n<p>There are three types of diabetes, check all about them below</p>\r\n\r\n<ul>\r\n <li>\r\n <p>Type 1 Diabetes</p>\r\n </li>\r\n</ul>\r\n\r\n<p> This is considered an autoimmune condition and people who are affected by it have their immune system mistakenly attack the beta cells in the pancreas that are responsible for producing insulin. The reasons are known to be genetic and environmental.</p>\r\n\r\n<ul>\r\n <li>\r\n <p>Type 2 Diabetes</p>\r\n </li>\r\n</ul>\r\n\r\n<p>This condition starts out as insulin resistance where your body is not able to use insulin efficiently. This has the pancreas working extra hard to produce insulin after which it just can&#39;t keep up with the supply. This finally causes high blood sugar. Genetics, obesity, and a sedentary lifestyle are responsible for the condition.</p>\r\n\r\n<ul>\r\n <li>\r\n <p>Gestational Diabetes</p>\r\n </li>\r\n</ul>\r\n\r\n<p>This is a condition that happens when a woman is pregnant and will often go away after the birth of the baby. It is usually witnessed in people who have pre-existing diabetes or have a long family history of diabetes.</p>\r\n\r\n<h2>Causes Of Diabetes</h2>\r\n\r\n<p>When looking at diabetes symptoms, it can be pretty easy to get to the root of the condition: the causes. It has been found that people suffering from diabetes usually have a predisposition toward the condition if they have a family history of it. They often are people who lead a sedentary lifestyle and are obese or overweight. Some pregnant women develop gestational diabetes and about 50% of these cases go on to be diagnosed with Type 2 diabetes.</p>\r\n\r\n<h2>Early Signs And Symptoms Of Diabetes</h2>\r\n\r\n<p>Your diabetes symptoms will be dependent on exactly how high the level of your blood sugar is. The fact is that you may not be even getting any symptoms if you are pre-diabetic or if you have Type 2 diabetes. With Type 1 diabetes though, the symptoms become apparent quickly. And the effects are more severe.</p>\r\n\r\n<p>Here are some of the common symptoms of diabetes though:</p>\r\n\r\n<ul>\r\n <li>Frequent urination</li>\r\n <li>Feeling thirsty very often</li>\r\n <li>Tiredness and weakness</li>\r\n <li>Blurry vision</li>\r\n <li>Loss of weight without trying</li>\r\n <li>Presence of ketones in the urine</li>\r\n <li>Being susceptible to infections of the skin, vagina, and other parts of the body</li>\r\n <li>Suffering from mood changes or being irritable</li>\r\n <li>Having sores that do not heal easily</li>\r\n</ul>\r\n\r\n<h2>Treatment </h2>\r\n\r\n<p>It all begins with the proper diagnosis. If you are considering going to a doctor because of suspected diabetes, here are the things to note:</p>\r\n\r\n<ul>\r\n <li>You have low blood sugar symptoms</li>\r\n <li>You have noticed possible symptoms of diabetes in you or your child</li>\r\n <li>You have got your test reports for diabetes back and that is when you need to see a doctor as soon as possible to stabilize your blood sugar levels.</li>\r\n</ul>\r\n\r\n<p>Here are things you will need to know about starting diabetes treatment. Diabetes treatment can be classified into two types mentioned below:</p>\r\n\r\n<p><strong>Medication:</strong> Most people diagnosed with the condition will not need any medication. If you are one of those who need medication, then you will either be given oral medication or insulin injections depending on the severity of your condition.</p>\r\n\r\n<p><strong>Lifestyle Changes:</strong> Very probably you will be asked by your doctor to make lifestyle changes. This will include making changes in your diet and switching to better and healthier meals as well as increasing your activity levels every day.</p>\r\n\r\n<h2>Prevention Of Diabetes</h2>\r\n\r\n<p>Here’s what you need to know about preventing the disease.</p>\r\n\r\n<p><strong>Type 1 Diabetes:</strong> It cannot be prevented. This is because the condition stems from hereditary and possibly environmental reasons. But some lifestyle choices can help prevent both Type 2 and Gestational diabetes.</p>\r\n\r\n<ul>\r\n <li><strong>Eat Healthier</strong></li>\r\n</ul>\r\n\r\n<p>Choosing foods that are lower in calories and fats and higher in fiber will be a better choice and focusing meals on whole grains, fruits and vegetables are necessary. You must keep eating a variety of such foods to prevent boredom from taking over.</p>\r\n\r\n<ul>\r\n <li><strong>Stop Being Sedentary</strong></li>\r\n</ul>\r\n\r\n<p>If you live a sedentary life, then it is time to start being more active. This can be simply as easy as starting with a physical activity every day such as yoga, brisk walking, or jogging. Some people have got positive effect by choosing to join a local gym.</p>\r\n\r\n<ul>\r\n <li><strong>Lose Weight</strong></li>\r\n</ul>\r\n\r\n<p>If you have a lot of extra weight, it is time to drop as much of it as possible.</p>\r\n\r\n<p>Diabetes may easily be preventable by putting your mind towards it. All types of diabetes can lead to further health complications.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> <em>THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE.</em> The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'all-about-diabetes', 'causes-and-prevention-of-diabetes.webp', '', 'How your body uses glucose and whether your blood contains a lot of it is a point of concern and something that gets tested. Let\'s talk about types', 1, 'Blood Sugar - Diabetes Type, Symptoms, Causes, Treatment & More', 'Don\'t let diabetes rule over you, know diabetes Type, Symptoms, Causes, and Treatment before it affects the way your body works. Know high and low sugar level', 'signs of diabetes, diabetes symptoms, high sugar level symptoms, low blood sugar symptoms', 'diabetes', '2023-02-08', '2023-12-18 06:13:26', '2023-12-20 03:53:53');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (39, '9 Amazing Lotus Seeds Benefits For Your Overall Health', '<p>Lotus is the National Flower of India, symbolising spirituality, knowledge, fruitfulness, illumination and wealth. Aside from its significance as a National Symbol of India, lotus seeds benefits and nutritional value are also crucial factors that make the plant highly regarded.</p>\r\n\r\n<p>Lotus seeds, aka Makhana, come from the Euryale Ferox plant or the lotus plant. These are cultivated widely throughout Asia and have long been used to treat a wide variety of health conditions. Lotus seeds nutritional value makes them the perfect evening snack and can be added to desserts, side dishes or curries.</p>\r\n\r\n<h2>Lotus Seed Nutrition Facts </h2>\r\n\r\n<p>Here is a quick insight into the nutrition facts of lotus seeds.</p>\r\n\r\n<p>Per 100 grams of lotus seeds contain:</p>\r\n\r\n<p>- 350 calories</p>\r\n\r\n<p>- 63-68 grams of carbohydrates</p>\r\n\r\n<p>- 17-18 grams of protein</p>\r\n\r\n<p>- 1.9-2.5 grams of fat</p>\r\n\r\n<p>In addition to the above, lotus seeds nutritional value also comprises Vitamin A, Vitamin B, Vitamin C, Vitamin E and essential minerals such as Sodium, Potassium and Magnesium. They also contain a large amount of water and phytochemicals that have antioxidant and anti-inflammatory properties.</p>\r\n\r\n<p>Health Benefits of Lotus Seeds</p>\r\n\r\n<p>Let’s understand the nine most incredible benefits of eating lotus seeds.  </p>\r\n\r\n<p><strong>1. Rich in Antioxidants</strong></p>\r\n\r\n<p>Lotus seeds are known to be a powerhouse of various antioxidants. These essential compounds help neutralise the release of harmful free radicals, thereby, preventing oxidative stress. According to research studies, antioxidants play an integral role in helping protect the body against chronic health conditions such as heart diseases, type 2 diabetes and cancer.</p>\r\n\r\n<p>Having makhana in the right amount regularly can also help reduce inflammation, thus, alleviating the symptoms of gout, rheumatoid arthritis, inflammatory bowel disease or psoriasis.</p>\r\n\r\n<p><strong>2. May Support Healthy Weight Loss</strong></p>\r\n\r\n<p>Lotus seeds uses are wide-spanning, including the ability to support healthy weight loss. Eating lotus seeds regularly can increase your intake of healthy protein and fibre which are essential nutrients that help promote weight loss.</p>\r\n\r\n<p>Research shows that adding protein to your daily diet can help improve your metabolism and cut down food cravings. On the other hand, fibre moves through the digestive tract slowly, keeping you feeling full for longer.</p>\r\n\r\n<p>As you feel fuller, you are less inclined to eat more. This way, makhana may help promote healthy weight loss.</p>\r\n\r\n<p><strong>3. May Help Manage Diabetes</strong></p>\r\n\r\n<p>Another key aspect of lotus seeds is they have a low glycemic index unlike other carbohydrate-rich foods like rice, bread, etc. They are also known to maintain an optimum glucose content in the bloodstream and monitor the body’s insulin response. Hence, eating roasted or dried lotus seeds can help manage diabetes.</p>\r\n\r\n<p>Makhana is also good for diabetic patients who have a risk of high blood pressure or hypertension. Studies suggest that lotus seeds may help stabilize the body’s blood pressure levels.</p>\r\n\r\n<p><strong>4. Lotus Seeds May Be Good for Kidney Health</strong></p>\r\n\r\n<p>Ayurveda suggests that makhana contains a powerful astringent which may help restore optimum kidney function. The astringent helps eliminate harmful wastes, toxins and free radicals from the body. This may prevent the formation of kidney stones and also lower acidity levels. The diuretic properties of lotus seeds may help eliminate fluid wastes and urine, thus, improving the overall functioning and health of your kidney.</p>\r\n\r\n<p><strong>5. Skin Benefits of Lotus Seeds</strong></p>\r\n\r\n<p>Lotus seeds contain essential nutrients, proteins, anti-oxidants and anti-inflammatory properties that may have potential skin benefits. Makhana contains the enzyme L-isoaspartyl methyltransferase that may help rejuvenate the skin, boost collagen synthesis and prevent the signs of ageing. Rich in water, lotus seeds have essential hydrating properties that moisturise your skin and improve skin elasticity.</p>\r\n\r\n<p>The flavonoids present in lotus seeds have anti-inflammatory properties that can naturally repair damaged skin cells and prevent inflammation. Vitamin A and Vitamin C may help reduce dark spots and add radiance to your skin. In addition to lotus seed benefits for skin, it also helps ensure healthy hair.</p>\r\n\r\n<p><strong>6. May Help Promote Sleep</strong> </p>\r\n\r\n<p>Studies suggest that lotus seeds are antispasmodic and have calming effects on the body. This means they may be beneficial in helping relax your nerves and provide better sleep. Lotus seeds may also help the blood vessels to dilate optimally. They contain isoquinoline alkaloids that may help alleviate the symptoms of anxiety and depression.</p>\r\n\r\n<p><strong>7. May Support Healthy Heart Functions</strong></p>\r\n\r\n<p>Although research is still in its nascent stage, certain studies indicate that lotus seeds may help promote heart health. They are rich in magnesium which may help improve the flow of oxygen and blood in the body. Additionally, folate present in lotus seeds may also reduce the risks of getting coronary heart disease or other heart-related conditions.</p>\r\n\r\n<p>They are rich in antioxidants which can help neutralize free radicals and protect the heart against injuries. Other animal studies suggest that lotus seeds may help reduce triglyceride and cholesterol levels, improving heart health.</p>\r\n\r\n<p><strong>8. It may be helpful in Diarrhoea</strong> </p>\r\n\r\n<p>Lotus seeds are known to contain high levels of astringent properties which may help alleviate the symptoms of diarrhoea. It may also be effective in regulating appetite in patients suffering from diarrhoea. However, people with constipation should avoid it.</p>\r\n\r\n<p><strong>9. Promotes Sexual Health</strong> </p>\r\n\r\n<p>Makhana is rich in plant-based bioactive chemicals that work as an incredible aphrodisiac. This may help increase the sexual drive and libido in men and women. Lotus seeds help promote the flow of blood into the reproductive organs, enriching the tissues in these body parts with energy and essential nutrients.</p>\r\n\r\n<p>This is the primary reason why the lotus has long been the symbol of fertility and fruitfulness. Including the right dosage of roasted makhana in the diet may help alleviate the conditions of poor sex drive in women or erectile dysfunction in women.</p>\r\n\r\n<p>So, these are the most common lotus seeds uses and benefits you should be aware of.</p>\r\n\r\n<h2>How To Eat Lotus Seeds</h2>\r\n\r\n<p>To have the best lotus seeds benefits for your health and overall wellbeing, it is important that you consume them in the right way.</p>\r\n\r\n<p>Makhana can be eaten roasted and tossed with some olive oil and rock salt, to make a delicious & nutritious savoury snack. You can also add puffed makhana into curries, kheers, etc. Make a paste of raw lotus seeds and use it to use in desserts. </p>\r\n\r\n<p>Eating lotus seeds regularly can help ensure overall health and well-being.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> <em>THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE.</em> The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'lotus-seeds-benefits', 'lotus-seed-benefits.webp', '', 'Lotus is the National Flower of India, symbolising spirituality, knowledge, fruitfulness, illumination and wealth.', 1, 'Health benefits of lotus seeds (Makhana) | Skin Care | Nutrition', 'Know the benefits of lotus seeds and how helpful is in improving skin care, weight loss, diabetes care, kidney health, heart functions & sexual health', 'lotus seeds benefits, lotus seeds uses, makhana benefits, makhana health benefits, lotus seeds nutritional value, benefits of eating lotus seeds', 'lotus seeds', '2022-10-03', '2023-12-20 02:17:13', '2023-12-20 03:54:22');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (41, 'What Is Typhoid: Symptoms, Causes And Treatment', '<p>Typhoid fever is an acute bacterial infection characterised by severe illness and often spreads to multiple organs of the body. Lack of prompt diagnosis and treatment can result in serious health implications and even cause death. </p>\r\n\r\n<p>Being a highly contagious disease, it is one of the primary causes of morbidity and mortality in unhygienic and overcrowded areas. The course of the disease may range from systematic illness to gastrointestinal problems but if left untreated, it may cause several complications. Typically, typhoid comes with fever, abdominal pain and headache. </p>\r\n\r\n<p>In this blog, we will understand what causes typhoid, its common symptoms, diagnosis and treatment. </p>\r\n\r\n<h2>Causes Of Typhoid</h2>\r\n\r\n<p>The cause of typhoid is a type of bacteria named Salmonella typhi. </p>\r\n\r\n<p>When people eat food or drink water that is contaminated by bacteria, it causes typhoid. It is highly contagious and spreads among people through the faeces of the infected person, and sometimes, through the urine. If the infected person does not wash his hands properly after using the toilet, he or she may contaminate the food they touch. If anyone eats this contaminated food, he or she will also become infected by typhoid fever.</p>\r\n\r\n<p>While typhoid fever causes remain the same – Salmonella typhi – there are various other ways the disease can be contracted. These include: </p>\r\n\r\n<ul>\r\n <li>Contamination of water supply caused by infected human waste in underdeveloped and developing regions with poor sanitation</li>\r\n <li>Using a contaminated toilet and not washing your hands properly after that </li>\r\n <li>Consuming unwashed and uncooked vegetables that have been grown using human waste fertiliser </li>\r\n <li>Drinking contaminated milk products</li>\r\n</ul>\r\n\r\n<p>It is important to know here that even after proper treatment, some people continue to bear the bacteria. They are called typhoid carriers. They no longer show typhoid fever symptoms but can still carry the bacteria in their faeces. Hence, these chronic carriers continue to infect others. </p>\r\n\r\n<h2>Symptoms Of Typhoid</h2>\r\n\r\n<p>The most common typhoid symptoms are:</p>\r\n\r\n<ul>\r\n <li>Headache</li>\r\n <li>A high temperature that increases persistently each day</li>\r\n <li>Fatigue or extreme tiredness</li>\r\n <li>Constipation</li>\r\n <li>Cough</li>\r\n <li>General body pain and ache</li>\r\n</ul>\r\n\r\n<p>However, as the bacterial infection progresses, one may experience more severe typhoid fever symptoms such as feeling sick, diarrhoea, loss of appetite, rashes and tummy ache. </p>\r\n\r\n<p>Lack of proper typhoid treatment at this stage will worsen the symptoms further and the risks of the infection getting potentially fatal. </p>\r\n\r\n<h2>Complications Of Typhoid </h2>\r\n\r\n<p>Complications typically arise when a person is not treated right away or does not get appropriate antibiotics. Such health implications arise during the 3rd week of the infection and commonly include: </p>\r\n\r\n<ul>\r\n <li>Intestinal bleeding</li>\r\n <li>Perforation in a section of the bowel or digestive system which causes the infection to spread to nearby tissues</li>\r\n</ul>\r\n\r\n<p>Other, less common implications include pneumonia, inflammation of the heart muscle, kidney infections, inflammation of the pancreas and psychiatric problems like hallucinations, etc.</p>\r\n\r\n<h2>Typhoid Fever Diagnosis</h2>\r\n\r\n<p>If you have any of the symptoms discussed above, it is important to visit a doctor. To see if you have the infection, the doctor will recommend a test for typhoid fever which typically includes analysing the samples of your blood, faeces or urine.</p>\r\n\r\n<p>After you come in contact with contaminated water or food, the bacteria will attack the small intestine and then enter your bloodstream. The white blood cells carry the bacteria to the bone marrow, liver and spleen where they multiply. At this point, people get symptoms like fever. Thereafter, it starts to spread in the bowel tissues, biliary system, gall bladder and intestinal tract.</p>\r\n\r\n<p>Therefore, initially, the test for typhoid fever is to check the stool samples. However, if the results are not evident, your doctor may recommend a urine or blood test for further diagnosis. A small sample is collected and cultured on a special medium and then checked under a microscope to detect the presence of Salmonella typhi.</p>\r\n\r\n<p>In addition to a test culture, other tests may also be done to validate the presence of this infection. These include tests that help check typhoid DNA or antibodies in your blood. Whatever typhoid test your doctor suggests, make sure you choose a good diagnostic centre that has the expertise and technology to perform the test and provide accurate results.</p>\r\n\r\n<h2>How To Typhoid Treated?</h2>\r\n\r\n<p>Typhoid treatment usually includes taking a full course of antibiotic medicines. The infection can be treated at home and does not require hospital admission unless complications arise.</p>\r\n\r\n<p>If diagnosed at an early stage, you may need to take antibiotics for 7-14 days. Within 2-3 days of taking the antibiotics, the symptoms should start to improve. But make sure you complete the course to ensure the bacteria gets completely removed from the body.</p>\r\n\r\n<p><br>\r\nAt the same time, you should eat nutritious food, drink plenty of fluids and take a rest. Also, ensure that you maintain proper hygiene like washing your hands regularly with warm water and soap. This will help prevent the risk of spreading the disease. If typhoid fever symptoms get worse, get in touch with your doctor immediately.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> <em>THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE.</em> The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'what-is-typhoid-symptoms-causes-treatment', 'typhoid-symptoms.webp', '', 'Typhoid fever is an acute bacterial infection characterised by severe illness and often spreads to multiple organs of the body.', 1, 'Early Symptoms of Typhoid Fever & Cause | Test | Treatment', 'Typhoid fever is acute bacterial infection that affects multiple organs of the body, don\'t let him down you know typhoid fever symptoms, treatment, and causes', 'typhoid fever, typhoid treatment, typhoid fever symptoms, test for typhoid fever, typhoid fever causes', 'typhoid fever', '2022-08-30', '2023-12-20 02:20:52', '2023-12-20 03:55:07');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (42, 'Viral Fever | Symptoms, Causes, Diagnosis And Treatment', '<p>During season changes, especially in Monsoon, you will find more people getting fever and other flu-like symptoms. This is primarily called viral fever, caused by a variety of viruses. It is not considered an illness or disease but an indication or result of an underlying viral infection. The fever occurs due to the body’s response to viral antigens, indicating an infection.</p>\r\n\r\n<p>Viral fevers are more acute and may last for 3-5 days. However, in some cases, the fever may last long for up to 14 days. People may experience mild to high fever, depending on the type of viral infection the person has. But at times, the symptoms of viral fever may go completely undiagnosed. This can cause severe complications at a later stage.</p>\r\n\r\n<p>If you have a fever that does not go away in 1-3 days, seek prompt medical attention to diagnose the underlying infection and get proper treatment. </p>\r\n\r\n<h2>What Are The Symptoms Of Viral Fever?</h2>\r\n\r\n<p>Depending on the underlying viral infection, the symptoms of viral fever may include:</p>\r\n\r\n<ul>\r\n <li>Body temperatures ranging from 99°F to over 103°F</li>\r\n <li>Frequent chills</li>\r\n <li>Headache</li>\r\n <li>Running nose</li>\r\n <li>Sore throat</li>\r\n <li>Loss of appetite</li>\r\n <li>Muscle aches and pains</li>\r\n <li>Dehydration</li>\r\n</ul>\r\n\r\n<p>In addition to the above symptoms, check out for other signs such as redness of the eyes, loss of appetite and skin rashes. Some people may also experience swelling of the face, nausea or vomiting, abdominal pain, diarrhoea, or dizziness.</p>\r\n\r\n<p>Typically, viral fevers are self-limiting. Hence, you can expect the symptoms of viral fever to subside in a few days. If the symptoms worsen or persist, consult a doctor immediately and get medical advice.</p>\r\n\r\n<h2>Causes Of Viral Fever</h2>\r\n\r\n<p>Viral fever happens when the body naturally produces pyrogens as a defensive mechanism against viral antigens. The causes may vary depending on the types of viral fever you have. However, some of the most common causes are:</p>\r\n\r\n<ul>\r\n <li>Eating food or drinking beverages that have been contaminated by some kind of virus, eventually causing an infection</li>\r\n <li>Unknowingly inhaling the air droplets when a person infected by viral fever coughs or sneezes nearby</li>\r\n <li>Coming in contact with viruses borne by animals or insects may also cause viral infection, such as rabies or fever</li>\r\n <li>Exchanging body fluids through needle prick or blood transfusion from an infected person to a healthy person</li>\r\n <li>Lack of immunity in children and aged people is one of the common causes of viral fever</li>\r\n <li>Coming in contact with a contaminated area</li>\r\n</ul>\r\n\r\n<h2>Types Of Viral Fever</h2>\r\n\r\n<p>Depending on the part of the body being affected, there are different types of viral fever as classified herewith:</p>\r\n\r\n<ul>\r\n <li><strong>Respiratory Viral Fever:</strong> In this condition, the virus affects the upper or lower part of the respiratory tract, causing conditions like common cold, flu, rhinovirus, laryngitis, viral bronchitis, measles, polio, SARS COVID-19, etc.</li>\r\n</ul>\r\n\r\n<ul>\r\n <li><strong>Exanthematous Viral Fever:</strong> In addition to causing fever, this type of viral infection also affects the skin. Rashes and skin eruptions are common symptoms. Examples include chickenpox, measles, roseola and rubella.</li>\r\n</ul>\r\n\r\n<ul>\r\n <li><strong>Viral Enteritis:</strong> This viral infection affects the digestive tract and is also known as stomach flu. Common gastrointestinal viral fever conditions are rotavirus, norovirus, adenovirus and astrovirus.</li>\r\n</ul>\r\n\r\n<p>In addition to the above, haemorrhagic viral fever and neurologic viral fever are two other common types of viral infections.</p>\r\n\r\n<h2>Diagnosis Of Viral Fever</h2>\r\n\r\n<p>Reviewing the signs and symptoms isn’t enough to diagnose a viral infection. This is because fever is a common health condition caused due to various underlying ailments. Additionally, the symptoms of viral and bacterial infections often seem similar, making the former difficult to diagnose.</p>\r\n\r\n<p>Therefore, your doctor may get started with understanding the severity of the symptoms, your health status, history of the fever or whether the symptoms are improving or worsening. For effective diagnosis, he may recommend diagnostic tests such as urine tests, blood tests, swab tests, sputum tests, or specific antibody or viral antigen tests.</p>\r\n\r\n<p>If bacteria are not found in the above tests, it is concluded that the person may have a viral infection.</p>\r\n\r\n<h2>Treatment For Viral Fever</h2>\r\n\r\n<p>Typically, there is no treatment for viral fever because antibiotics do not work in viral infections. However, your doctor may recommend certain medications that may alleviate the symptoms. Here are some common viral fever treatment methods:</p>\r\n\r\n<ul>\r\n <li>Over-the-counter medicines such as ibuprofen or paracetamol can help reduce fever and its symptoms</li>\r\n <li>Drink plenty of fluids to stay well hydrated. It also helps replenish the fluid you lose while sweating</li>\r\n <li>Take anti-viral medications when applicable</li>\r\n <li>To lower your body temperature in case of high fever, take a lukewarm bath or apply a damp cloth to the forehead</li>\r\n</ul>\r\n\r\n<p>Complications</p>\r\n\r\n<p>Viral fever is usually not serious but if left undiagnosed and untreated, it may result in a few complications like dehydration, seizures, hallucination, nervous system malfunctions, shock, liver & kidney failure, organ failure, respiratory dysfunction and even coma.<br>\r\nIf you get a fever that does not subside in 1-3 days, seek a doctor’s advice for proper diagnosis and viral fever treatment.</p>\r\n\r\n<p>How Long Does Viral Fever Last?</p>\r\n\r\n<p>The majority of viral fevers last 3 to 4 days and goes up to a week, and some, like dengue fever can last up to 10 days or longer. Although, the duration of fever varies to the type of fever you suffering from</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> <em>THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE.</em> The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'viral-fever-symptoms-causes-treatment', 'viral-fever-symptoms.webp', '', 'This is primarily called viral fever, caused by a variety of viruses. It is not considered an illness or disease but an indication or result...', 1, 'Viral Fever Duration, Types, Symptoms, Causes, and Treatment', 'Find early symptoms of viral fever and how long does last. know about its type, cause, treatments to prevent yourself and fight against viral fever', 'types of viral fever, symptoms of viral fever, causes of viral fever, viral fever treatment', 'viral fever', '2022-08-30', '2023-12-20 02:23:26', '2023-12-20 03:55:36');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (43, 'Things To Know About Dengue Fever| Symptoms, Causes, Treatment & Prevention', '<p><a href=\"https://flashdeal.in/demo/cityx-blog/\">Dengue fever</a>, also known as “break-bone fever,” is a mosquito-borne disease that can be extremely debilitating and painful. Mild dengue causes flu-like symptoms and high fever but it can also get severe in certain cases – causing an acute drop in blood pressure and serious bleeding.</p>\r\n\r\n<p>Millions of people suffer from dengue each year. According to the National Centre for Vector Borne Diseases Control (NVBDCP), a total of 10,172 dengue cases have been reported till 31st May 2022, in India.</p>\r\n\r\n<p>Dengue can be life-threatening at times and therefore, it is crucial to seek prompt medical attention, proper diagnosis and treatment. This blog covers everything you should know about dengue infection.</p>\r\n\r\n<h2>Symptoms Of Dengue Fever</h2>\r\n\r\n<p>The symptoms may vary from mild to severe and may last up to 10 days. The signs typically appear 4-6 days after the person has been infected by the virus. The symptoms may include:</p>\r\n\r\n<ul>\r\n <li>High fever that can go up to 104°F</li>\r\n <li>Pain behind the eyes and headache</li>\r\n <li>Fatigue</li>\r\n <li>Severe muscle and joint pain</li>\r\n <li>Skin rashes which usually appear 2-5 days after the onset of fever</li>\r\n <li>Vomiting</li>\r\n <li>Nausea</li>\r\n <li>Mild bleeding, including easy bruising, bleeding gums, or nose bleed</li>\r\n</ul>\r\n\r\n<p>When the symptoms of dengue are mild, they are often mistaken for flu or other viral infections. While most people may recover within 1-2 weeks, the symptoms may worsen in some cases and become life-threatening. This is termed dengue haemorrhagic fever, severe dengue or dengue shock syndrome</p>\r\n\r\n<p>This situation arises when the blood vessels get damaged, resulting in leaks. The platelet count also drops significantly. Together, these lead to organ failure, internal bleeding, shocks and in some cases, even death.</p>\r\n\r\n<p>Severe dengue fever is a life-threatening situation and can develop quickly even before you could know. Therefore, it is important to keep a check on the following warning signs:</p>\r\n\r\n<ul>\r\n <li>Persistent vomiting</li>\r\n <li>Restlessness or irritability</li>\r\n <li>Blood in stool, urine or vomit</li>\r\n <li>Severe pain in the stomach</li>\r\n <li>Difficulty breathing or breathlessness</li>\r\n <li>Bleeding from your nose or gums</li>\r\n <li>Internal bleeding such as under the skin</li>\r\n <li>Fatigue</li>\r\n</ul>\r\n\r\n<p>If you develop any of the above dengue symptoms, seek immediate medical attention.</p>\r\n\r\n<h2>Causes Of Dengue</h2>\r\n\r\n<p>Dengue is caused by any of the following four viruses, namely DENV-1, DENV-2, DENV-3 and DENV-4. However, it is transmitted through mosquito bites. When a mosquito bites someone who is infected by the dengue virus, the mosquito becomes the carrier of the virus and spread it among human beings. When the dengue mosquito bites a person, it causes the virus to enter his or her bloodstream.</p>\r\n\r\n<p>The virus then multiplies in the person’s bloodstream and the common symptoms start showing up. However, very quickly the virus can start destroying your blood vessels and the platelet count rises. These may cause the blood to leak out of the vessels, resulting in internal bleeding. Hence, the person may develop life-threatening signs of severe dengue fever.</p>\r\n\r\n<p>While the causes of dengue are ‘viruses,’ the infection is transmitted through Aedes mosquitos. It is not contagious in the sense that it does not spread directly from one person to another unless an infected mother passes it on to the baby during her pregnancy or childbirth.</p>\r\n\r\n<p><strong>Diagnosis of Dengue</strong></p>\r\n\r\n<p>Since the symptoms of dengue are often similar to that of influenza, typhoid fever, measles or malaria, the doctor will recommend taking blood tests for proper diagnosis of the infection. These include the Non-Structural Protein 1 test, complete blood count, Immunoglobulin M/Immunoglobulin G test, etc.</p>\r\n\r\n<p><strong>Test For Dengue</strong></p>\r\n\r\n<p>There are primarily four diagnostic tests that are recommended by your doctors/physician on the basis of your symptoms of fever. These are the following tests to confirm the dengue:-</p>\r\n\r\n<ul>\r\n <li>Dengue NS 1 Antigen</li>\r\n <li>Dengue IgM Antibody</li>\r\n <li>Dengue IgG Antibody</li>\r\n <li>platelet count</li>\r\n</ul>\r\n\r\n<p>Choose an accredited diagnostic centre that has the infrastructure and expertise to perform dengue fever tests.</p>\r\n\r\n<h2>Treatment For Dengue</h2>\r\n\r\n<p>Unfortunately, there is no specific treatment of dengue yet. Since the infection is caused by a virus, doctors do not prescribe antibiotics. However, mild pain relievers such as paracetamol may help alleviate the conditions of muscle and joint pain. Do not take non-steroidal inflammatory medications like ibuprofen or aspirin because they can increase internal bleeding.</p>\r\n\r\n<p>Take adequate rest and stay well-hydrated.</p>\r\n\r\n<h2>Prevention Of Dengue</h2>\r\n\r\n<p>Since there is no definitive dengue fever treatment, it is crucial to take proper preventive measures:</p>\r\n\r\n<ul>\r\n <li>Avoid mosquito bites in all cases</li>\r\n <li>Use mosquito repellents, both indoors and outdoors</li>\r\n <li>Use mosquito nets when sleeping at night</li>\r\n <li>If you live in a mosquito-prone area, do not leave body parts exposed, especially when you are going out</li>\r\n</ul>\r\n\r\n<p>If you develop signs of dengue fever, seek medical attention immediately and get a proper diagnosis done.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> <em>THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE.</em> The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'know-all-about-dengue-fever', 'causes-of-dengue-fever1.webp', '', 'Dengue fever, also known as “break-bone fever,” is a mosquito-borne disease that can be extremely debilitating and painful.', 1, 'Dengue Fever - Early Symptoms, Causes, Treatment, and more', 'Dengue fever is also known as a mosquito-borne illness, know the right symptoms and treatment to fight against dengue', 'dengue fever, dengue symptoms, dengue fever treatment, causes of dengue', 'dengue fever', '2022-08-29', '2023-12-20 02:26:25', '2024-01-04 02:37:22');
INSERT INTO `lb_blog_post` (`post_id`, `post_title`, `post_description`, `post_url`, `post_img`, `post_img_alt_tag`, `small_description`, `post_status`, `meta_title`, `meta_desc`, `meta_keyword`, `post_tags`, `post_created`, `post_created_at`, `post_updated`) VALUES (44, 'Causes of Joint Pain and How Does It Diagnose - Winter', '<p>When a person suffers from joint pain, that means facing discomfort, soreness, or even inflammation. These symptoms may arise from any part of a joint in the body. Joints enables movement and flexibility in the body. Other symptoms of joint pain are swelling, redness, warmth, stiffness, and restricted motion.</p>\r\n\r\n<h2>Joint Pain Causes</h2>\r\n\r\n<p>Joint pain may impact any joint, and it may be mild or severe. Joint pain causes may be injury, inflammation, arthritis, or other medical conditions. Sometimes, cold weather may also result in joint pain in winter. Let us see the different reasons for joint pain.</p>\r\n\r\n<ul>\r\n <li>Arthritis- Arthritis can cause joint pain.</li>\r\n <li>Injury- Fractures, dislocation or a sprain can lead to injury leading to joint pain. In such a case, injured ligaments or tendons may cause joint discomfort</li>\r\n <li>Infections- Viral or bacterial infections can cause joint inflammation, leading to joint pain. An example of joint disease is septic arthritis.</li>\r\n <li>Joint Degeneration- Joint degeneration can be the result of ageing and wear-and-tear.</li>\r\n <li>Tumours- Tumours developed in and around joint areas can also lead to joint pain.</li>\r\n <li>Season Change- During the winter season, when the temperature is low, there is decreased blood circulation in the body. This can cause muscle contractions, like knee pain in winter. Stiffness in joints can lead to joint pain in winter.</li>\r\n</ul>\r\n\r\n<h2>Joint Pain Diagnosis</h2>\r\n\r\n<p>There are different diagnostic tests like MRI scans, X-rays, and ultrasounds.</p>\r\n\r\n<h3>MRI Scans</h3>\r\n\r\n<p>MRI stands for Magnetic Resonance Imaging. It is a medical imaging method. There are MRI diagnostic services in the city. One needs to look for advanced, affordable, and reliable MRI diagnostic services. Nowadays, MRI diagnostic services have become investigative, safe, non-invasive, and painless.</p>\r\n\r\n<p>These MRI scans are conducted by trained and experienced radiologists and technicians. The modern MRI scan machines are 1.5 MRI and 3 Tesla scanners. These machines ensure accurate image quality processing, precise and quick reporting, patient comfort and care, and streamlined operations. It has no radiation exposure and no side effects.</p>\r\n\r\n<p>Apart from detecting joint pains, MRI scans also help to diagnose bone disorders, cysts, cardiovascular diseases, tumours, and breast cancer. It can also diagnose liver cancer, womb cancer, spinal and brain problems, pelvic pain in women, endometriosis, and uterine abnormalities. The cost of an MRI scan can depend on the MRI scan machine, duration, body part being scanned, and the type of procedure.</p>\r\n\r\n<h4>Procedure for An MRI Scan</h4>\r\n\r\n<p>An MRI scan demands the patient’s comfort, safety, and care. There should be a high standard of quality in the scan procedure. Before the scanning procedure starts, a patient needs to wear a hospital gown. They should also remove any metal objects that they may be wearing or on their body.</p>\r\n\r\n<p>After this preparation, the patient lies down on a retractile table on their back. This table then gradually moves into a semicircular-shaped scanner. The patient either goes in feet first or head first. Patients are strongly advised to remain still during the scanning process.</p>\r\n\r\n<p>The patient may hear loud tapping or thumping noises while the scan is going on. These noises are of the electric current. This electric current runs through the MRI scanner coil. This helps to generate in-depth and accurate images.</p>\r\n\r\n<p>The duration of the scan depends on the number of pictures and the body part. On average, it takes about 15 minutes to about an hour. After finishing the scan, a radiologist studies the images and writes a report. This report mentions any abnormalities, if any.</p>\r\n\r\n<p>Thus, we can see how MRI scans can detect joint pain causes and other diseases mentioned above. While an MRI itself does not directly detect pain, it is instrumental in identifying and visualising abnormalities, injuries, or conditions within the joints that may be causing pain.</p>\r\n\r\n<h3>How X-Rays Can Detect Joint Pain</h3>\r\n\r\n<p>X-rays are also commonly used to study bones and joint structures. X-rays can help to identify any abnormalities within the joints that may lead to pain. Modern X-ray machines and skilled radiologists can help diagnose and assist in joint pain treatment.</p>\r\n\r\n<p>Digital X-ray has led to the invention of a digital radiology system. These machines are time-efficient, provide accurate images, reduce radiation exposure, and simplify digitalised reporting. The digital x-ray machines take high-definition images during the x-ray scan and transfer them to a computer. The computer helps convert the X-ray radiation into electric currents and digital photos.</p>\r\n\r\n<p>The digital 800 MA X-ray machine should be medically certified. They should also meet the current industry standards. This machine helps to diagnose and prepare chest, hand, abdominal, pelvis, joint, cervical, hip, skull, knee, and neck x-rays. The radiologists and technicians should be able to perform these X-ray procedures and maintain high safety standards.</p>\r\n\r\n<p>These machines should also be clean and in a hygienic environment. Taking X-rays does not have any side effects. But repetitive X-rays can lead to many side effects like hair fall or even cancer. Ultimately, X-rays are a valuable tool in the diagnostic process. This helps healthcare providers assess the skeletal aspects of joints and identify the reasons for joint pain.</p>\r\n\r\n<h3>Ultrasound Imaging Helping to Detect Joint Pain</h3>\r\n\r\n<p>Ultrasound imaging uses sound waves to create real-time images of the body’s anatomy. It can also help to evaluate and diagnose medical conditions like joint pain. It assists in diagnosing joint pain in many ways. These are soft tissue visualising, dynamic imaging, tendon and ligament evaluation, synovial fluid abnormality identification, and bursae evaluation. Other ways are blood flow assessment and monitoring treatment progress.</p>\r\n\r\n<p>Ultrasound has its limitations, such as not being able to visualise deeper structures or bones. Overall, it is a dynamic imaging technique that plays a vital role in the evaluation and diagnosis of joint pain and related conditions.</p>\r\n\r\n<p>Therefore, we can see the different processes and technology used to diagnose joint pains. For instance, these technologies can help to detect different kinds of joint pain in winter. An example of this would be knee pain in winter.</p>\r\n\r\n<p>City X-Ray and Scan Clinic has been a high-quality diagnostic centre. Their facilities include MRI, CT scans, digital X-rays, neurology tests, nuclear imaging, and pathology laboratory, and others.</p>\r\n\r\n<p><strong>DISCLAIMER:</strong> <em>THIS WEBSITE DOES NOT PROVIDE MEDICAL ADVICE.</em> The information including text, graphics, images, and other material contained on this website is for informational purposes only. No material on this site is intended to be a substitute for professional medical advice, diagnosis, or treatment. Contact a health expert if you have questions about your health.</p>', 'causes-of-joint-pain-in-winters', 'joint_pain_blog_(1).webp', 'Why Joint Pain Increases When It\'s Cold? Tests Used to Diagnose it.', 'Learn why joint pain worsens in winter and explore various diagnostic tests to identify underlying causes for effective treatment.', 1, 'Reasons for Joint Pain in Winter? Different Types of Diagnostics Tests', 'It\'s true, cold weather can make your joints stiffen up and hurt. We explain the causes and explore diagnostic tests for relief.', 'joint pain in winter, joint pain causes, joint pain treatment, reasons for joint pain, knee pain in winter', 'Joint Pain,  Joint Health,', '2024-03-07', '2024-03-07 10:31:59', '2024-03-07 01:55:44');


#
# TABLE STRUCTURE FOR: lb_city
#

DROP TABLE IF EXISTS `lb_city`;

CREATE TABLE `lb_city` (
  `city_id` int(11) NOT NULL AUTO_INCREMENT,
  `city_name` varchar(30) NOT NULL,
  `state_id` int(11) NOT NULL,
  `city_status` int(11) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`city_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5742 DEFAULT CHARSET=latin1;

INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1, 'Bombuflat', 1, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2, 'Garacharma', 1, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3, 'Port Blair', 1, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4, 'Rangat', 1, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5, 'Addanki', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (6, 'Adivivaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (7, 'Adoni', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (8, 'Aganampudi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (9, 'Ajjaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (10, 'Akividu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (11, 'Akkarampalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (12, 'Akkayapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (13, 'Akkireddipalem', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (14, 'Alampur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (15, 'Amalapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (16, 'Amudalavalasa', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (17, 'Amur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (18, 'Anakapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (19, 'Anantapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (20, 'Andole', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (21, 'Atmakur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (22, 'Attili', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (23, 'Avanigadda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (24, 'Badepalli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (25, 'Badvel', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (26, 'Balapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (27, 'Bandarulanka', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (28, 'Banganapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (29, 'Bapatla', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (30, 'Bapulapadu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (31, 'Belampalli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (32, 'Bestavaripeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (33, 'Betamcherla', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (34, 'Bhattiprolu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (35, 'Bhimavaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (36, 'Bhimunipatnam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (37, 'Bobbili', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (38, 'Bombuflat', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (39, 'Bommuru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (40, 'Bugganipalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (41, 'Challapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (42, 'Chandur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (43, 'Chatakonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (44, 'Chemmumiahpet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (45, 'Chidiga', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (46, 'Chilakaluripet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (47, 'Chimakurthy', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (48, 'Chinagadila', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (49, 'Chinagantyada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (50, 'Chinnachawk', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (51, 'Chintalavalasa', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (52, 'Chipurupalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (53, 'Chirala', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (54, 'Chittoor', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (55, 'Chodavaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (56, 'Choutuppal', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (57, 'Chunchupalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (58, 'Cuddapah', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (59, 'Cumbum', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (60, 'Darnakal', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (61, 'Dasnapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (62, 'Dauleshwaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (63, 'Dharmavaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (64, 'Dhone', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (65, 'Dommara Nandyal', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (66, 'Dowlaiswaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (67, 'East Godavari Dist.', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (68, 'Eddumailaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (69, 'Edulapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (70, 'Ekambara kuppam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (71, 'Eluru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (72, 'Enikapadu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (73, 'Fakirtakya', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (74, 'Farrukhnagar', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (75, 'Gaddiannaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (76, 'Gajapathinagaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (77, 'Gajularega', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (78, 'Gajuvaka', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (79, 'Gannavaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (80, 'Garacharma', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (81, 'Garimellapadu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (82, 'Giddalur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (83, 'Godavarikhani', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (84, 'Gopalapatnam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (85, 'Gopalur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (86, 'Gorrekunta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (87, 'Gudivada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (88, 'Gudur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (89, 'Guntakal', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (90, 'Guntur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (91, 'Guti', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (92, 'Hindupur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (93, 'Hukumpeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (94, 'Ichchapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (95, 'Isnapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (96, 'Jaggayyapeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (97, 'Jallaram Kamanpur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (98, 'Jammalamadugu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (99, 'Jangampalli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (100, 'Jarjapupeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (101, 'Kadiri', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (102, 'Kaikalur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (103, 'Kakinada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (104, 'Kallur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (105, 'Kalyandurg', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (106, 'Kamalapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (107, 'Kamareddi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (108, 'Kanapaka', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (109, 'Kanigiri', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (110, 'Kanithi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (111, 'Kankipadu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (112, 'Kantabamsuguda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (113, 'Kanuru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (114, 'Karnul', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (115, 'Katheru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (116, 'Kavali', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (117, 'Kazipet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (118, 'Khanapuram Haveli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (119, 'Kodar', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (120, 'Kollapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (121, 'Kondapalem', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (122, 'Kondapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (123, 'Kondukur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (124, 'Kosgi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (125, 'Kothavalasa', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (126, 'Kottapalli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (127, 'Kovur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (128, 'Kovurpalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (129, 'Kovvur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (130, 'Krishna', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (131, 'Kuppam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (132, 'Kurmannapalem', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (133, 'Kurnool', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (134, 'Lakshettipet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (135, 'Lalbahadur Nagar', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (136, 'Machavaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (137, 'Macherla', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (138, 'Machilipatnam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (139, 'Madanapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (140, 'Madaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (141, 'Madhuravada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (142, 'Madikonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (143, 'Madugule', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (144, 'Mahabubnagar', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (145, 'Mahbubabad', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (146, 'Malkajgiri', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (147, 'Mamilapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (148, 'Mancheral', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (149, 'Mandapeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (150, 'Mandasa', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (151, 'Mangalagiri', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (152, 'Manthani', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (153, 'Markapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (154, 'Marturu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (155, 'Metpalli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (156, 'Mindi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (157, 'Mirpet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (158, 'Moragudi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (159, 'Mothugudam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (160, 'Nagari', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (161, 'Nagireddipalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (162, 'Nandigama', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (163, 'Nandikotkur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (164, 'Nandyal', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (165, 'Narasannapeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (166, 'Narasapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (167, 'Narasaraopet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (168, 'Narayanavanam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (169, 'Narsapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (170, 'Narsingi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (171, 'Narsipatnam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (172, 'Naspur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (173, 'Nathayyapalem', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (174, 'Nayudupeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (175, 'Nelimaria', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (176, 'Nellore', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (177, 'Nidadavole', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (178, 'Nuzvid', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (179, 'Omerkhan daira', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (180, 'Ongole', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (181, 'Osmania University', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (182, 'Pakala', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (183, 'Palakole', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (184, 'Palakurthi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (185, 'Palasa', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (186, 'Palempalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (187, 'Palkonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (188, 'Palmaner', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (189, 'Pamur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (190, 'Panjim', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (191, 'Papampeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (192, 'Parasamba', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (193, 'Parvatipuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (194, 'Patancheru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (195, 'Payakaraopet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (196, 'Pedagantyada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (197, 'Pedana', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (198, 'Peddapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (199, 'Pendurthi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (200, 'Penugonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (201, 'Penukonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (202, 'Phirangipuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (203, 'Pithapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (204, 'Ponnur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (205, 'Port Blair', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (206, 'Pothinamallayyapalem', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (207, 'Prakasam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (208, 'Prasadampadu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (209, 'Prasantinilayam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (210, 'Proddatur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (211, 'Pulivendla', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (212, 'Punganuru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (213, 'Puttur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (214, 'Qutubullapur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (215, 'Rajahmundry', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (216, 'Rajamahendri', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (217, 'Rajampet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (218, 'Rajendranagar', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (219, 'Rajoli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (220, 'Ramachandrapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (221, 'Ramanayyapeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (222, 'Ramapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (223, 'Ramarajupalli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (224, 'Ramavarappadu', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (225, 'Rameswaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (226, 'Rampachodavaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (227, 'Ravulapalam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (228, 'Rayachoti', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (229, 'Rayadrug', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (230, 'Razam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (231, 'Razole', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (232, 'Renigunta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (233, 'Repalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (234, 'Rishikonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (235, 'Salur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (236, 'Samalkot', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (237, 'Sattenapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (238, 'Seetharampuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (239, 'Serilungampalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (240, 'Shankarampet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (241, 'Shar', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (242, 'Singarayakonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (243, 'Sirpur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (244, 'Sirsilla', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (245, 'Sompeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (246, 'Sriharikota', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (247, 'Srikakulam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (248, 'Srikalahasti', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (249, 'Sriramnagar', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (250, 'Sriramsagar', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (251, 'Srisailam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (252, 'Srisailamgudem Devasthanam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (253, 'Sulurpeta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (254, 'Suriapet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (255, 'Suryaraopet', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (256, 'Tadepalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (257, 'Tadepalligudem', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (258, 'Tadpatri', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (259, 'Tallapalle', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (260, 'Tanuku', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (261, 'Tekkali', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (262, 'Tenali', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (263, 'Tigalapahad', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (264, 'Tiruchanur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (265, 'Tirumala', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (266, 'Tirupati', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (267, 'Tirvuru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (268, 'Trimulgherry', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (269, 'Tuni', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (270, 'Turangi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (271, 'Ukkayapalli', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (272, 'Ukkunagaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (273, 'Uppal Kalan', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (274, 'Upper Sileru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (275, 'Uravakonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (276, 'Vadlapudi', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (277, 'Vaparala', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (278, 'Vemalwada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (279, 'Venkatagiri', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (280, 'Venkatapuram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (281, 'Vepagunta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (282, 'Vetapalem', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (283, 'Vijayapuri', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (284, 'Vijayapuri South', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (285, 'Vijayawada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (286, 'Vinukonda', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (287, 'Visakhapatnam', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (288, 'Vizianagaram', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (289, 'Vuyyuru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (290, 'Wanparti', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (291, 'West Godavari Dist.', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (292, 'Yadagirigutta', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (293, 'Yarada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (294, 'Yellamanchili', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (295, 'Yemmiganur', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (296, 'Yenamalakudru', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (297, 'Yendada', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (298, 'Yerraguntla', 2, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (299, 'Along', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (300, 'Basar', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (301, 'Bondila', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (302, 'Changlang', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (303, 'Daporijo', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (304, 'Deomali', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (305, 'Itanagar', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (306, 'Jairampur', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (307, 'Khonsa', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (308, 'Naharlagun', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (309, 'Namsai', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (310, 'Pasighat', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (311, 'Roing', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (312, 'Seppa', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (313, 'Tawang', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (314, 'Tezu', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (315, 'Ziro', 3, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (316, 'Abhayapuri', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (317, 'Ambikapur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (318, 'Amguri', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (319, 'Anand Nagar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (320, 'Badarpur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (321, 'Badarpur Railway Town', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (322, 'Bahbari Gaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (323, 'Bamun Sualkuchi', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (324, 'Barbari', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (325, 'Barpathar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (326, 'Barpeta', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (327, 'Barpeta Road', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (328, 'Basugaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (329, 'Bihpuria', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (330, 'Bijni', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (331, 'Bilasipara', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (332, 'Biswanath Chariali', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (333, 'Bohori', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (334, 'Bokajan', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (335, 'Bokokhat', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (336, 'Bongaigaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (337, 'Bongaigaon Petro-chemical Town', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (338, 'Borgolai', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (339, 'Chabua', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (340, 'Chandrapur Bagicha', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (341, 'Chapar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (342, 'Chekonidhara', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (343, 'Choto Haibor', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (344, 'Dergaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (345, 'Dharapur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (346, 'Dhekiajuli', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (347, 'Dhemaji', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (348, 'Dhing', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (349, 'Dhubri', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (350, 'Dhuburi', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (351, 'Dibrugarh', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (352, 'Digboi', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (353, 'Digboi Oil Town', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (354, 'Dimaruguri', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (355, 'Diphu', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (356, 'Dispur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (357, 'Doboka', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (358, 'Dokmoka', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (359, 'Donkamokan', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (360, 'Duliagaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (361, 'Duliajan', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (362, 'Duliajan No.1', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (363, 'Dum Duma', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (364, 'Durga Nagar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (365, 'Gauripur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (366, 'Goalpara', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (367, 'Gohpur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (368, 'Golaghat', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (369, 'Golakganj', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (370, 'Gossaigaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (371, 'Guwahati', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (372, 'Haflong', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (373, 'Hailakandi', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (374, 'Hamren', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (375, 'Hauli', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (376, 'Hauraghat', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (377, 'Hojai', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (378, 'Jagiroad', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (379, 'Jagiroad Paper Mill', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (380, 'Jogighopa', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (381, 'Jonai Bazar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (382, 'Jorhat', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (383, 'Kampur Town', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (384, 'Kamrup', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (385, 'Kanakpur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (386, 'Karimganj', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (387, 'Kharijapikon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (388, 'Kharupetia', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (389, 'Kochpara', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (390, 'Kokrajhar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (391, 'Kumar Kaibarta Gaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (392, 'Lakhimpur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (393, 'Lakhipur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (394, 'Lala', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (395, 'Lanka', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (396, 'Lido Tikok', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (397, 'Lido Town', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (398, 'Lumding', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (399, 'Lumding Railway Colony', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (400, 'Mahur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (401, 'Maibong', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (402, 'Majgaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (403, 'Makum', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (404, 'Mangaldai', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (405, 'Mankachar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (406, 'Margherita', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (407, 'Mariani', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (408, 'Marigaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (409, 'Moran', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (410, 'Moranhat', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (411, 'Nagaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (412, 'Naharkatia', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (413, 'Nalbari', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (414, 'Namrup', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (415, 'Naubaisa Gaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (416, 'Nazira', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (417, 'New Bongaigaon Railway Colony', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (418, 'Niz-Hajo', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (419, 'North Guwahati', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (420, 'Numaligarh', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (421, 'Palasbari', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (422, 'Panchgram', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (423, 'Pathsala', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (424, 'Raha', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (425, 'Rangapara', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (426, 'Rangia', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (427, 'Salakati', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (428, 'Sapatgram', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (429, 'Sarthebari', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (430, 'Sarupathar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (431, 'Sarupathar Bengali', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (432, 'Senchoagaon', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (433, 'Sibsagar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (434, 'Silapathar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (435, 'Silchar', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (436, 'Silchar Part-X', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (437, 'Sonari', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (438, 'Sorbhog', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (439, 'Sualkuchi', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (440, 'Tangla', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (441, 'Tezpur', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (442, 'Tihu', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (443, 'Tinsukia', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (444, 'Titabor', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (445, 'Udalguri', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (446, 'Umrangso', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (447, 'Uttar Krishnapur Part-I', 4, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (448, 'Amarpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (449, 'Ara', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (450, 'Araria', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (451, 'Areraj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (452, 'Asarganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (453, 'Aurangabad', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (454, 'Bagaha', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (455, 'Bahadurganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (456, 'Bairgania', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (457, 'Bakhtiyarpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (458, 'Banka', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (459, 'Banmankhi', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (460, 'Bar Bigha', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (461, 'Barauli', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (462, 'Barauni Oil Township', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (463, 'Barh', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (464, 'Barhiya', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (465, 'Bariapur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (466, 'Baruni', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (467, 'Begusarai', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (468, 'Behea', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (469, 'Belsand', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (470, 'Bettiah', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (471, 'Bhabua', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (472, 'Bhagalpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (473, 'Bhimnagar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (474, 'Bhojpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (475, 'Bihar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (476, 'Bihar Sharif', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (477, 'Bihariganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (478, 'Bikramganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (479, 'Birpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (480, 'Bodh Gaya', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (481, 'Buxar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (482, 'Chakia', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (483, 'Chanpatia', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (484, 'Chhapra', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (485, 'Chhatapur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (486, 'Colgong', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (487, 'Dalsingh Sarai', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (488, 'Darbhanga', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (489, 'Daudnagar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (490, 'Dehri', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (491, 'Dhaka', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (492, 'Dighwara', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (493, 'Dinapur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (494, 'Dinapur Cantonment', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (495, 'Dumra', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (496, 'Dumraon', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (497, 'Fatwa', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (498, 'Forbesganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (499, 'Gaya', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (500, 'Gazipur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (501, 'Ghoghardiha', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (502, 'Gogri Jamalpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (503, 'Gopalganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (504, 'Habibpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (505, 'Hajipur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (506, 'Hasanpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (507, 'Hazaribagh', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (508, 'Hilsa', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (509, 'Hisua', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (510, 'Islampur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (511, 'Jagdispur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (512, 'Jahanabad', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (513, 'Jamalpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (514, 'Jamhaur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (515, 'Jamui', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (516, 'Janakpur Road', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (517, 'Janpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (518, 'Jaynagar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (519, 'Jha Jha', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (520, 'Jhanjharpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (521, 'Jogbani', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (522, 'Kanti', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (523, 'Kasba', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (524, 'Kataiya', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (525, 'Katihar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (526, 'Khagaria', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (527, 'Khagaul', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (528, 'Kharagpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (529, 'Khusrupur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (530, 'Kishanganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (531, 'Koath', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (532, 'Koilwar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (533, 'Lakhisarai', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (534, 'Lalganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (535, 'Lauthaha', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (536, 'Madhepura', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (537, 'Madhubani', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (538, 'Maharajganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (539, 'Mahnar Bazar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (540, 'Mairwa', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (541, 'Makhdumpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (542, 'Maner', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (543, 'Manihari', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (544, 'Marhaura', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (545, 'Masaurhi', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (546, 'Mirganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (547, 'Mohiuddinagar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (548, 'Mokama', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (549, 'Motihari', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (550, 'Motipur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (551, 'Munger', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (552, 'Murliganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (553, 'Muzaffarpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (554, 'Nabinagar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (555, 'Narkatiaganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (556, 'Nasriganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (557, 'Natwar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (558, 'Naugachhia', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (559, 'Nawada', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (560, 'Nirmali', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (561, 'Nokha', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (562, 'Paharpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (563, 'Patna', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (564, 'Phulwari', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (565, 'Piro', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (566, 'Purnia', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (567, 'Pusa', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (568, 'Rafiganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (569, 'Raghunathpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (570, 'Rajgir', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (571, 'Ramnagar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (572, 'Raxaul', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (573, 'Revelganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (574, 'Rusera', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (575, 'Sagauli', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (576, 'Saharsa', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (577, 'Samastipur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (578, 'Sasaram', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (579, 'Shahpur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (580, 'Shaikhpura', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (581, 'Sherghati', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (582, 'Shivhar', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (583, 'Silao', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (584, 'Sitamarhi', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (585, 'Siwan', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (586, 'Sonepur', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (587, 'Sultanganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (588, 'Supaul', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (589, 'Teghra', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (590, 'Tekari', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (591, 'Thakurganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (592, 'Vaishali', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (593, 'Waris Aliganj', 5, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (594, 'Chandigarh', 6, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (595, 'Ahiwara', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (596, 'Akaltara', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (597, 'Ambagarh Chauki', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (598, 'Ambikapur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (599, 'Arang', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (600, 'Bade Bacheli', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (601, 'Bagbahara', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (602, 'Baikunthpur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (603, 'Balod', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (604, 'Baloda', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (605, 'Baloda Bazar', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (606, 'Banarsi', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (607, 'Basna', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (608, 'Bemetra', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (609, 'Bhanpuri', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (610, 'Bhatapara', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (611, 'Bhatgaon', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (612, 'Bhilai', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (613, 'Bilaspur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (614, 'Bilha', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (615, 'Birgaon', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (616, 'Bodri', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (617, 'Champa', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (618, 'Charcha', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (619, 'Charoda', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (620, 'Chhuikhadan', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (621, 'Chirmiri', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (622, 'Dantewada', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (623, 'Deori', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (624, 'Dhamdha', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (625, 'Dhamtari', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (626, 'Dharamjaigarh', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (627, 'Dipka', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (628, 'Doman Hill Colliery', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (629, 'Dongargaon', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (630, 'Dongragarh', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (631, 'Durg', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (632, 'Frezarpur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (633, 'Gandai', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (634, 'Gariaband', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (635, 'Gaurela', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (636, 'Gelhapani', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (637, 'Gharghoda', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (638, 'Gidam', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (639, 'Gobra Nawapara', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (640, 'Gogaon', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (641, 'Hatkachora', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (642, 'Jagdalpur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (643, 'Jamui', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (644, 'Jashpurnagar', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (645, 'Jhagrakhand', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (646, 'Kanker', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (647, 'Katghora', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (648, 'Kawardha', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (649, 'Khairagarh', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (650, 'Khamhria', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (651, 'Kharod', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (652, 'Kharsia', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (653, 'Khonga Pani', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (654, 'Kirandu', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (655, 'Kirandul', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (656, 'Kohka', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (657, 'Kondagaon', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (658, 'Korba', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (659, 'Korea', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (660, 'Koria Block', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (661, 'Kota', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (662, 'Kumhari', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (663, 'Kumud Katta', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (664, 'Kurasia', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (665, 'Kurud', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (666, 'Lingiyadih', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (667, 'Lormi', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (668, 'Mahasamund', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (669, 'Mahendragarh', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (670, 'Mehmand', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (671, 'Mongra', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (672, 'Mowa', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (673, 'Mungeli', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (674, 'Nailajanjgir', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (675, 'Namna Kalan', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (676, 'Naya Baradwar', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (677, 'Pandariya', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (678, 'Patan', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (679, 'Pathalgaon', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (680, 'Pendra', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (681, 'Phunderdihari', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (682, 'Pithora', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (683, 'Raigarh', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (684, 'Raipur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (685, 'Rajgamar', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (686, 'Rajhara', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (687, 'Rajnandgaon', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (688, 'Ramanuj Ganj', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (689, 'Ratanpur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (690, 'Sakti', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (691, 'Saraipali', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (692, 'Sarajpur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (693, 'Sarangarh', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (694, 'Shivrinarayan', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (695, 'Simga', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (696, 'Sirgiti', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (697, 'Takhatpur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (698, 'Telgaon', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (699, 'Tildanewra', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (700, 'Urla', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (701, 'Vishrampur', 7, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (702, 'Amli', 8, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (703, 'Silvassa', 8, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (704, 'Daman', 9, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (705, 'Diu', 9, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (706, 'Delhi', 10, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (707, 'New Delhi', 10, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (708, 'Aldona', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (709, 'Altinho', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (710, 'Aquem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (711, 'Arpora', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (712, 'Bambolim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (713, 'Bandora', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (714, 'Bardez', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (715, 'Benaulim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (716, 'Betora', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (717, 'Bicholim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (718, 'Calapor', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (719, 'Candolim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (720, 'Caranzalem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (721, 'Carapur', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (722, 'Chicalim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (723, 'Chimbel', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (724, 'Chinchinim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (725, 'Colvale', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (726, 'Corlim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (727, 'Cortalim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (728, 'Cuncolim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (729, 'Curchorem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (730, 'Curti', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (731, 'Davorlim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (732, 'Dona Paula', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (733, 'Goa', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (734, 'Guirim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (735, 'Jua', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (736, 'Kalangat', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (737, 'Kankon', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (738, 'Kundaim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (739, 'Loutulim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (740, 'Madgaon', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (741, 'Mapusa', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (742, 'Margao', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (743, 'Margaon', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (744, 'Miramar', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (745, 'Morjim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (746, 'Mormugao', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (747, 'Navelim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (748, 'Pale', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (749, 'Panaji', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (750, 'Parcem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (751, 'Parra', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (752, 'Penha de Franca', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (753, 'Pernem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (754, 'Pilerne', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (755, 'Pissurlem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (756, 'Ponda', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (757, 'Porvorim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (758, 'Quepem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (759, 'Queula', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (760, 'Raia', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (761, 'Reis Magos', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (762, 'Salcette', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (763, 'Saligao', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (764, 'Sancoale', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (765, 'Sanguem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (766, 'Sanquelim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (767, 'Sanvordem', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (768, 'Sao Jose-de-Areal', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (769, 'Sattari', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (770, 'Serula', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (771, 'Sinquerim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (772, 'Siolim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (773, 'Taleigao', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (774, 'Tivim', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (775, 'Valpoi', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (776, 'Varca', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (777, 'Vasco', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (778, 'Verna', 11, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (779, 'Abrama', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (780, 'Adalaj', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (781, 'Adityana', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (782, 'Advana', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (783, 'Ahmedabad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (784, 'Ahwa', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (785, 'Alang', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (786, 'Ambaji', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (787, 'Ambaliyasan', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (788, 'Amod', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (789, 'Amreli', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (790, 'Amroli', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (791, 'Anand', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (792, 'Andada', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (793, 'Anjar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (794, 'Anklav', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (795, 'Ankleshwar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (796, 'Anklesvar INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (797, 'Antaliya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (798, 'Arambhada', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (799, 'Asarma', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (800, 'Atul', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (801, 'Babra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (802, 'Bag-e-Firdosh', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (803, 'Bagasara', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (804, 'Bahadarpar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (805, 'Bajipura', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (806, 'Bajva', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (807, 'Balasinor', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (808, 'Banaskantha', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (809, 'Bansda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (810, 'Bantva', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (811, 'Bardoli', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (812, 'Barwala', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (813, 'Bayad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (814, 'Bechar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (815, 'Bedi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (816, 'Beyt', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (817, 'Bhachau', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (818, 'Bhanvad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (819, 'Bharuch', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (820, 'Bharuch INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (821, 'Bhavnagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (822, 'Bhayavadar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (823, 'Bhestan', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (824, 'Bhuj', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (825, 'Bilimora', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (826, 'Bilkha', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (827, 'Billimora', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (828, 'Bodakdev', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (829, 'Bodeli', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (830, 'Bopal', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (831, 'Boria', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (832, 'Boriavi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (833, 'Borsad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (834, 'Botad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (835, 'Cambay', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (836, 'Chaklasi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (837, 'Chala', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (838, 'Chalala', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (839, 'Chalthan', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (840, 'Chanasma', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (841, 'Chandisar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (842, 'Chandkheda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (843, 'Chanod', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (844, 'Chaya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (845, 'Chenpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (846, 'Chhapi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (847, 'Chhaprabhatha', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (848, 'Chhatral', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (849, 'Chhota Udepur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (850, 'Chikhli', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (851, 'Chiloda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (852, 'Chorvad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (853, 'Chotila', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (854, 'Dabhoi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (855, 'Dadara', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (856, 'Dahod', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (857, 'Dakor', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (858, 'Damnagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (859, 'Deesa', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (860, 'Delvada', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (861, 'Devgadh Baria', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (862, 'Devsar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (863, 'Dhandhuka', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (864, 'Dhanera', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (865, 'Dhangdhra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (866, 'Dhansura', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (867, 'Dharampur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (868, 'Dhari', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (869, 'Dhola', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (870, 'Dholka', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (871, 'Dholka Rural', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (872, 'Dhoraji', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (873, 'Dhrangadhra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (874, 'Dhrol', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (875, 'Dhuva', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (876, 'Dhuwaran', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (877, 'Digvijaygram', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (878, 'Disa', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (879, 'Dungar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (880, 'Dungarpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (881, 'Dungra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (882, 'Dwarka', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (883, 'Flelanganj', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (884, 'GSFC Complex', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (885, 'Gadhda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (886, 'Gandevi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (887, 'Gandhidham', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (888, 'Gandhinagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (889, 'Gariadhar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (890, 'Ghogha', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (891, 'Godhra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (892, 'Gondal', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (893, 'Hajira INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (894, 'Halol', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (895, 'Halvad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (896, 'Hansot', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (897, 'Harij', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (898, 'Himatnagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (899, 'Ichchhapor', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (900, 'Idar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (901, 'Jafrabad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (902, 'Jalalpore', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (903, 'Jambusar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (904, 'Jamjodhpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (905, 'Jamnagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (906, 'Jasdan', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (907, 'Jawaharnagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (908, 'Jetalsar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (909, 'Jetpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (910, 'Jodiya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (911, 'Joshipura', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (912, 'Junagadh', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (913, 'Kadi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (914, 'Kadodara', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (915, 'Kalavad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (916, 'Kali', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (917, 'Kaliawadi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (918, 'Kalol', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (919, 'Kalol INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (920, 'Kandla', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (921, 'Kanjari', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (922, 'Kanodar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (923, 'Kapadwanj', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (924, 'Karachiya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (925, 'Karamsad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (926, 'Karjan', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (927, 'Kathial', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (928, 'Kathor', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (929, 'Katpar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (930, 'Kavant', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (931, 'Keshod', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (932, 'Kevadiya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (933, 'Khambhaliya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (934, 'Khambhat', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (935, 'Kharaghoda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (936, 'Khed Brahma', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (937, 'Kheda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (938, 'Kheralu', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (939, 'Kodinar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (940, 'Kosamba', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (941, 'Kundla', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (942, 'Kutch', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (943, 'Kutiyana', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (944, 'Lakhtar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (945, 'Lalpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (946, 'Lambha', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (947, 'Lathi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (948, 'Limbdi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (949, 'Limla', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (950, 'Lunavada', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (951, 'Madhapar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (952, 'Maflipur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (953, 'Mahemdavad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (954, 'Mahudha', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (955, 'Mahuva', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (956, 'Mahuvar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (957, 'Makarba', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (958, 'Makarpura', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (959, 'Makassar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (960, 'Maktampur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (961, 'Malia', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (962, 'Malpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (963, 'Manavadar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (964, 'Mandal', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (965, 'Mandvi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (966, 'Mangrol', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (967, 'Mansa', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (968, 'Meghraj', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (969, 'Mehsana', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (970, 'Mendarla', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (971, 'Mithapur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (972, 'Modasa', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (973, 'Mogravadi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (974, 'Morbi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (975, 'Morvi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (976, 'Mundra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (977, 'Nadiad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (978, 'Naliya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (979, 'Nanakvada', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (980, 'Nandej', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (981, 'Nandesari', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (982, 'Nandesari INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (983, 'Naroda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (984, 'Navagadh', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (985, 'Navagam Ghed', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (986, 'Navsari', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (987, 'Ode', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (988, 'Okaf', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (989, 'Okha', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (990, 'Olpad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (991, 'Paddhari', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (992, 'Padra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (993, 'Palanpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (994, 'Palej', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (995, 'Pali', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (996, 'Palitana', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (997, 'Paliyad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (998, 'Pandesara', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (999, 'Panoli', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1000, 'Pardi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1001, 'Parnera', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1002, 'Parvat', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1003, 'Patan', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1004, 'Patdi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1005, 'Petlad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1006, 'Petrochemical Complex', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1007, 'Porbandar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1008, 'Prantij', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1009, 'Radhanpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1010, 'Raiya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1011, 'Rajkot', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1012, 'Rajpipla', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1013, 'Rajula', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1014, 'Ramod', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1015, 'Ranavav', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1016, 'Ranoli', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1017, 'Rapar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1018, 'Sahij', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1019, 'Salaya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1020, 'Sanand', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1021, 'Sankheda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1022, 'Santrampur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1023, 'Saribujrang', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1024, 'Sarigam INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1025, 'Sayan', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1026, 'Sayla', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1027, 'Shahpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1028, 'Shahwadi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1029, 'Shapar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1030, 'Shivrajpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1031, 'Siddhapur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1032, 'Sidhpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1033, 'Sihor', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1034, 'Sika', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1035, 'Singarva', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1036, 'Sinor', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1037, 'Sojitra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1038, 'Sola', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1039, 'Songadh', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1040, 'Suraj Karadi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1041, 'Surat', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1042, 'Surendranagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1043, 'Talaja', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1044, 'Talala', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1045, 'Talod', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1046, 'Tankara', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1047, 'Tarsali', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1048, 'Thangadh', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1049, 'Tharad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1050, 'Thasra', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1051, 'Udyognagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1052, 'Ukai', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1053, 'Umbergaon', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1054, 'Umbergaon INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1055, 'Umrala', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1056, 'Umreth', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1057, 'Un', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1058, 'Una', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1059, 'Unjha', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1060, 'Upleta', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1061, 'Utran', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1062, 'Uttarsanda', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1063, 'V.U. Nagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1064, 'V.V. Nagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1065, 'Vadia', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1066, 'Vadla', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1067, 'Vadnagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1068, 'Vadodara', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1069, 'Vaghodia INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1070, 'Valbhipur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1071, 'Vallabh Vidyanagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1072, 'Valsad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1073, 'Valsad INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1074, 'Vanthali', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1075, 'Vapi', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1076, 'Vapi INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1077, 'Vartej', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1078, 'Vasad', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1079, 'Vasna Borsad INA', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1080, 'Vaso', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1081, 'Veraval', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1082, 'Vidyanagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1083, 'Vijalpor', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1084, 'Vijapur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1085, 'Vinchhiya', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1086, 'Vinzol', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1087, 'Virpur', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1088, 'Visavadar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1089, 'Visnagar', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1090, 'Vyara', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1091, 'Wadhwan', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1092, 'Waghai', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1093, 'Waghodia', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1094, 'Wankaner', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1095, 'Zalod', 12, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1096, 'Ambala', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1097, 'Ambala Cantt', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1098, 'Asan Khurd', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1099, 'Asandh', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1100, 'Ateli', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1101, 'Babiyal', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1102, 'Bahadurgarh', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1103, 'Ballabgarh', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1104, 'Barwala', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1105, 'Bawal', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1106, 'Bawani Khera', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1107, 'Beri', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1108, 'Bhiwani', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1109, 'Bilaspur', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1110, 'Buria', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1111, 'Charkhi Dadri', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1112, 'Chhachhrauli', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1113, 'Chita', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1114, 'Dabwali', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1115, 'Dharuhera', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1116, 'Dundahera', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1117, 'Ellenabad', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1118, 'Farakhpur', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1119, 'Faridabad', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1120, 'Farrukhnagar', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1121, 'Fatehabad', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1122, 'Firozpur Jhirka', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1123, 'Gannaur', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1124, 'Ghraunda', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1125, 'Gohana', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1126, 'Gurgaon', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1127, 'Haileymandi', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1128, 'Hansi', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1129, 'Hasanpur', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1130, 'Hathin', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1131, 'Hisar', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1132, 'Hissar', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1133, 'Hodal', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1134, 'Indri', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1135, 'Jagadhri', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1136, 'Jakhal Mandi', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1137, 'Jhajjar', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1138, 'Jind', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1139, 'Julana', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1140, 'Kaithal', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1141, 'Kalanur', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1142, 'Kalanwali', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1143, 'Kalayat', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1144, 'Kalka', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1145, 'Kanina', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1146, 'Kansepur', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1147, 'Kardhan', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1148, 'Karnal', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1149, 'Kharkhoda', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1150, 'Kheri Sampla', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1151, 'Kundli', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1152, 'Kurukshetra', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1153, 'Ladrawan', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1154, 'Ladwa', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1155, 'Loharu', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1156, 'Maham', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1157, 'Mahendragarh', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1158, 'Mustafabad', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1159, 'Nagai Chaudhry', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1160, 'Narayangarh', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1161, 'Narnaul', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1162, 'Narnaund', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1163, 'Narwana', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1164, 'Nilokheri', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1165, 'Nuh', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1166, 'Palwal', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1167, 'Panchkula', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1168, 'Panipat', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1169, 'Panipat Taraf Ansar', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1170, 'Panipat Taraf Makhdum Zadgan', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1171, 'Panipat Taraf Rajputan', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1172, 'Pehowa', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1173, 'Pinjaur', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1174, 'Punahana', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1175, 'Pundri', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1176, 'Radaur', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1177, 'Raipur Rani', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1178, 'Rania', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1179, 'Ratiya', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1180, 'Rewari', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1181, 'Rohtak', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1182, 'Ropar', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1183, 'Sadauri', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1184, 'Safidon', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1185, 'Samalkha', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1186, 'Sankhol', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1187, 'Sasauli', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1188, 'Shahabad', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1189, 'Sirsa', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1190, 'Siwani', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1191, 'Sohna', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1192, 'Sonipat', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1193, 'Sukhrali', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1194, 'Taoru', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1195, 'Taraori', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1196, 'Tauru', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1197, 'Thanesar', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1198, 'Tilpat', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1199, 'Tohana', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1200, 'Tosham', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1201, 'Uchana', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1202, 'Uklana Mandi', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1203, 'Uncha Siwana', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1204, 'Yamunanagar', 13, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1205, 'Arki', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1206, 'Baddi', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1207, 'Bakloh', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1208, 'Banjar', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1209, 'Bhota', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1210, 'Bhuntar', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1211, 'Bilaspur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1212, 'Chamba', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1213, 'Chaupal', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1214, 'Chuari Khas', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1215, 'Dagshai', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1216, 'Dalhousie', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1217, 'Dalhousie Cantonment', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1218, 'Damtal', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1219, 'Daulatpur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1220, 'Dera Gopipur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1221, 'Dhalli', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1222, 'Dharamshala', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1223, 'Gagret', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1224, 'Ghamarwin', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1225, 'Hamirpur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1226, 'Jawala Mukhi', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1227, 'Jogindarnagar', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1228, 'Jubbal', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1229, 'Jutogh', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1230, 'Kala Amb', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1231, 'Kalpa', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1232, 'Kangra', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1233, 'Kasauli', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1234, 'Kot Khai', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1235, 'Kullu', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1236, 'Kulu', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1237, 'Manali', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1238, 'Mandi', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1239, 'Mant Khas', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1240, 'Mehatpur Basdehra', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1241, 'Nadaun', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1242, 'Nagrota', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1243, 'Nahan', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1244, 'Naina Devi', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1245, 'Nalagarh', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1246, 'Narkanda', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1247, 'Nurpur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1248, 'Palampur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1249, 'Pandoh', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1250, 'Paonta Sahib', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1251, 'Parwanoo', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1252, 'Parwanu', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1253, 'Rajgarh', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1254, 'Rampur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1255, 'Rawalsar', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1256, 'Rohru', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1257, 'Sabathu', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1258, 'Santokhgarh', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1259, 'Sarahan', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1260, 'Sarka Ghat', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1261, 'Seoni', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1262, 'Shimla', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1263, 'Sirmaur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1264, 'Solan', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1265, 'Solon', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1266, 'Sundarnagar', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1267, 'Sundernagar', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1268, 'Talai', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1269, 'Theog', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1270, 'Tira Sujanpur', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1271, 'Una', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1272, 'Yol', 14, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1273, 'Achabal', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1274, 'Akhnur', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1275, 'Anantnag', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1276, 'Arnia', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1277, 'Awantipora', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1278, 'Badami Bagh', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1279, 'Bandipur', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1280, 'Banihal', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1281, 'Baramula', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1282, 'Baramulla', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1283, 'Bari Brahmana', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1284, 'Bashohli', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1285, 'Batote', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1286, 'Bhaderwah', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1287, 'Bijbiara', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1288, 'Billawar', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1289, 'Birwah', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1290, 'Bishna', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1291, 'Budgam', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1292, 'Charari Sharief', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1293, 'Chenani', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1294, 'Doda', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1295, 'Duru-Verinag', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1296, 'Gandarbat', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1297, 'Gho Manhasan', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1298, 'Gorah Salathian', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1299, 'Gulmarg', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1300, 'Hajan', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1301, 'Handwara', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1302, 'Hiranagar', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1303, 'Jammu', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1304, 'Jammu Cantonment', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1305, 'Jammu Tawi', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1306, 'Jourian', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1307, 'Kargil', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1308, 'Kathua', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1309, 'Katra', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1310, 'Khan Sahib', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1311, 'Khour', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1312, 'Khrew', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1313, 'Kishtwar', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1314, 'Kud', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1315, 'Kukernag', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1316, 'Kulgam', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1317, 'Kunzer', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1318, 'Kupwara', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1319, 'Lakhenpur', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1320, 'Leh', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1321, 'Magam', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1322, 'Mattan', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1323, 'Naushehra', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1324, 'Pahalgam', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1325, 'Pampore', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1326, 'Parole', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1327, 'Pattan', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1328, 'Pulwama', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1329, 'Punch', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1330, 'Qazigund', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1331, 'Rajauri', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1332, 'Ramban', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1333, 'Ramgarh', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1334, 'Ramnagar', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1335, 'Ranbirsingh Pora', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1336, 'Reasi', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1337, 'Rehambal', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1338, 'Samba', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1339, 'Shupiyan', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1340, 'Sopur', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1341, 'Srinagar', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1342, 'Sumbal', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1343, 'Sunderbani', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1344, 'Talwara', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1345, 'Thanamandi', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1346, 'Tral', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1347, 'Udhampur', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1348, 'Uri', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1349, 'Vijaypur', 15, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1350, 'Adityapur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1351, 'Amlabad', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1352, 'Angarpathar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1353, 'Ara', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1354, 'Babua Kalan', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1355, 'Bagbahra', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1356, 'Baliapur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1357, 'Baliari', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1358, 'Balkundra', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1359, 'Bandhgora', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1360, 'Barajamda', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1361, 'Barhi', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1362, 'Barka Kana', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1363, 'Barki Saraiya', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1364, 'Barughutu', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1365, 'Barwadih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1366, 'Basaria', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1367, 'Basukinath', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1368, 'Bermo', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1369, 'Bhagatdih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1370, 'Bhaurah', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1371, 'Bhojudih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1372, 'Bhuli', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1373, 'Bokaro', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1374, 'Borio Bazar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1375, 'Bundu', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1376, 'Chaibasa', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1377, 'Chaitudih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1378, 'Chakradharpur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1379, 'Chakulia', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1380, 'Chandaur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1381, 'Chandil', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1382, 'Chandrapura', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1383, 'Chas', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1384, 'Chatra', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1385, 'Chhatatanr', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1386, 'Chhotaputki', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1387, 'Chiria', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1388, 'Chirkunda', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1389, 'Churi', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1390, 'Daltenganj', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1391, 'Danguwapasi', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1392, 'Dari', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1393, 'Deoghar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1394, 'Deorikalan', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1395, 'Devghar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1396, 'Dhanbad', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1397, 'Dhanwar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1398, 'Dhaunsar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1399, 'Dugda', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1400, 'Dumarkunda', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1401, 'Dumka', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1402, 'Egarkunr', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1403, 'Gadhra', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1404, 'Garwa', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1405, 'Ghatsila', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1406, 'Ghorabandha', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1407, 'Gidi', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1408, 'Giridih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1409, 'Gobindpur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1410, 'Godda', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1411, 'Godhar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1412, 'Golphalbari', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1413, 'Gomoh', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1414, 'Gua', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1415, 'Gumia', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1416, 'Gumla', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1417, 'Haludbani', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1418, 'Hazaribag', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1419, 'Hesla', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1420, 'Husainabad', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1421, 'Isri', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1422, 'Jadugora', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1423, 'Jagannathpur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1424, 'Jamadoba', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1425, 'Jamshedpur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1426, 'Jamtara', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1427, 'Jarangdih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1428, 'Jaridih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1429, 'Jasidih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1430, 'Jena', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1431, 'Jharia', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1432, 'Jharia Khas', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1433, 'Jhinkpani', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1434, 'Jhumri Tilaiya', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1435, 'Jorapokhar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1436, 'Jugsalai', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1437, 'Kailudih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1438, 'Kalikapur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1439, 'Kandra', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1440, 'Kanke', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1441, 'Katras', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1442, 'Kedla', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1443, 'Kenduadih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1444, 'Kharkhari', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1445, 'Kharsawan', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1446, 'Khelari', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1447, 'Khunti', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1448, 'Kiri Buru', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1449, 'Kiriburu', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1450, 'Kodarma', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1451, 'Kuju', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1452, 'Kurpania', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1453, 'Kustai', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1454, 'Lakarka', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1455, 'Lapanga', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1456, 'Latehar', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1457, 'Lohardaga', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1458, 'Loiya', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1459, 'Loyabad', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1460, 'Madhupur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1461, 'Mahesh Mundi', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1462, 'Maithon', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1463, 'Malkera', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1464, 'Mango', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1465, 'Manoharpur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1466, 'Marma', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1467, 'Meghahatuburu Forest village', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1468, 'Mera', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1469, 'Meru', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1470, 'Mihijam', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1471, 'Mugma', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1472, 'Muri', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1473, 'Mushabani', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1474, 'Nagri Kalan', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1475, 'Netarhat', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1476, 'Nirsa', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1477, 'Noamundi', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1478, 'Okni', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1479, 'Orla', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1480, 'Pakaur', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1481, 'Palamau', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1482, 'Palawa', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1483, 'Panchet', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1484, 'Panrra', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1485, 'Paratdih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1486, 'Pathardih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1487, 'Patratu', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1488, 'Phusro', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1489, 'Pondar Kanali', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1490, 'Rajmahal', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1491, 'Ramgarh', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1492, 'Ranchi', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1493, 'Ray', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1494, 'Rehla', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1495, 'Religara', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1496, 'Rohraband', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1497, 'Sahibganj', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1498, 'Sahnidih', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1499, 'Saraidhela', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1500, 'Saraikela', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1501, 'Sarjamda', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1502, 'Saunda', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1503, 'Sewai', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1504, 'Sijhua', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1505, 'Sijua', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1506, 'Simdega', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1507, 'Sindari', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1508, 'Sinduria', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1509, 'Sini', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1510, 'Sirka', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1511, 'Siuliban', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1512, 'Surubera', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1513, 'Tati', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1514, 'Tenudam', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1515, 'Tisra', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1516, 'Topa', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1517, 'Topchanchi', 16, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1518, 'Adityanagar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1519, 'Adityapatna', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1520, 'Afzalpur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1521, 'Ajjampur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1522, 'Aland', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1523, 'Almatti Sitimani', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1524, 'Alnavar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1525, 'Alur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1526, 'Ambikanagara', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1527, 'Anekal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1528, 'Ankola', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1529, 'Annigeri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1530, 'Arkalgud', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1531, 'Arsikere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1532, 'Athni', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1533, 'Aurad', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1534, 'Badagavettu', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1535, 'Badami', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1536, 'Bagalkot', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1537, 'Bagepalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1538, 'Bailhongal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1539, 'Baindur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1540, 'Bajala', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1541, 'Bajpe', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1542, 'Banavar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1543, 'Bangarapet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1544, 'Bankapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1545, 'Bannur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1546, 'Bantwal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1547, 'Basavakalyan', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1548, 'Basavana Bagevadi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1549, 'Belagula', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1550, 'Belakavadiq', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1551, 'Belgaum', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1552, 'Belgaum Cantonment', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1553, 'Bellary', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1554, 'Belluru', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1555, 'Beltangadi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1556, 'Belur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1557, 'Belvata', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1558, 'Bengaluru', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1559, 'Bhadravati', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1560, 'Bhalki', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1561, 'Bhatkal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1562, 'Bhimarayanagudi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1563, 'Bhogadi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1564, 'Bidar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1565, 'Bijapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1566, 'Bilgi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1567, 'Birur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1568, 'Bommanahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1569, 'Bommasandra', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1570, 'Byadgi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1571, 'Byatarayanapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1572, 'Chakranagar Colony', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1573, 'Challakere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1574, 'Chamrajnagar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1575, 'Chamundi Betta', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1576, 'Channagiri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1577, 'Channapatna', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1578, 'Channarayapatna', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1579, 'Chickballapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1580, 'Chik Ballapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1581, 'Chikkaballapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1582, 'Chikmagalur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1583, 'Chiknayakanhalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1584, 'Chikodi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1585, 'Chincholi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1586, 'Chintamani', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1587, 'Chitaguppa', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1588, 'Chitapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1589, 'Chitradurga', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1590, 'Coorg', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1591, 'Dandeli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1592, 'Dargajogihalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1593, 'Dasarahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1594, 'Davangere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1595, 'Devadurga', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1596, 'Devagiri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1597, 'Devanhalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1598, 'Dharwar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1599, 'Dhupdal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1600, 'Dod Ballapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1601, 'Donimalai', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1602, 'Gadag', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1603, 'Gajendragarh', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1604, 'Ganeshgudi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1605, 'Gangawati', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1606, 'Gangoli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1607, 'Gauribidanur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1608, 'Gokak', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1609, 'Gokak Falls', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1610, 'Gonikoppal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1611, 'Gorur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1612, 'Gottikere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1613, 'Gubbi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1614, 'Gudibanda', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1615, 'Gulbarga', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1616, 'Guledgudda', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1617, 'Gundlupet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1618, 'Gurmatkal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1619, 'Haliyal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1620, 'Hangal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1621, 'Harihar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1622, 'Harpanahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1623, 'Hassan', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1624, 'Hatti', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1625, 'Hatti Gold Mines', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1626, 'Haveri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1627, 'Hebbagodi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1628, 'Hebbalu', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1629, 'Hebri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1630, 'Heggadadevanakote', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1631, 'Herohalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1632, 'Hidkal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1633, 'Hindalgi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1634, 'Hirekerur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1635, 'Hiriyur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1636, 'Holalkere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1637, 'Hole Narsipur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1638, 'Homnabad', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1639, 'Honavar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1640, 'Honnali', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1641, 'Hosakote', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1642, 'Hosanagara', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1643, 'Hosangadi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1644, 'Hosdurga', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1645, 'Hoskote', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1646, 'Hospet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1647, 'Hubli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1648, 'Hukeri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1649, 'Hunasagi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1650, 'Hunasamaranahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1651, 'Hungund', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1652, 'Hunsur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1653, 'Huvina Hadagalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1654, 'Ilkal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1655, 'Indi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1656, 'Jagalur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1657, 'Jamkhandi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1658, 'Jevargi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1659, 'Jog Falls', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1660, 'Kabini Colony', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1661, 'Kadur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1662, 'Kalghatgi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1663, 'Kamalapuram', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1664, 'Kampli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1665, 'Kanakapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1666, 'Kangrali BK', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1667, 'Kangrali KH', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1668, 'Kannur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1669, 'Karkala', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1670, 'Karwar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1671, 'Kemminja', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1672, 'Kengeri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1673, 'Kerur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1674, 'Khanapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1675, 'Kodigenahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1676, 'Kodiyal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1677, 'Kodlipet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1678, 'Kolar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1679, 'Kollegal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1680, 'Konanakunte', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1681, 'Konanur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1682, 'Konnur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1683, 'Koppa', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1684, 'Koppal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1685, 'Koratagere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1686, 'Kotekara', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1687, 'Kothnur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1688, 'Kotturu', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1689, 'Krishnapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1690, 'Krishnarajanagar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1691, 'Krishnarajapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1692, 'Krishnarajasagara', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1693, 'Krishnarajpet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1694, 'Kudchi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1695, 'Kudligi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1696, 'Kudremukh', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1697, 'Kumsi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1698, 'Kumta', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1699, 'Kundapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1700, 'Kundgol', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1701, 'Kunigal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1702, 'Kurgunta', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1703, 'Kushalnagar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1704, 'Kushtagi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1705, 'Kyathanahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1706, 'Lakshmeshwar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1707, 'Lingsugur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1708, 'Londa', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1709, 'Maddur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1710, 'Madhugiri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1711, 'Madikeri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1712, 'Magadi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1713, 'Magod Falls', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1714, 'Mahadeswara Hills', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1715, 'Mahadevapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1716, 'Mahalingpur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1717, 'Maisuru', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1718, 'Maisuru Cantonment', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1719, 'Malavalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1720, 'Mallar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1721, 'Malpe', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1722, 'Malur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1723, 'Manchenahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1724, 'Mandya', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1725, 'Mangalore', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1726, 'Mangaluru', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1727, 'Manipal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1728, 'Manvi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1729, 'Maski', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1730, 'Mastikatte Colony', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1731, 'Mayakonda', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1732, 'Melukote', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1733, 'Molakalmuru', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1734, 'Mudalgi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1735, 'Mudbidri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1736, 'Muddebihal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1737, 'Mudgal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1738, 'Mudhol', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1739, 'Mudigere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1740, 'Mudushedde', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1741, 'Mulbagal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1742, 'Mulgund', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1743, 'Mulki', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1744, 'Mulur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1745, 'Mundargi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1746, 'Mundgod', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1747, 'Munirabad', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1748, 'Munnur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1749, 'Murudeshwara', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1750, 'Mysore', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1751, 'Nagamangala', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1752, 'Nanjangud', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1753, 'Naragund', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1754, 'Narasimharajapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1755, 'Naravi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1756, 'Narayanpur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1757, 'Naregal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1758, 'Navalgund', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1759, 'Nelmangala', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1760, 'Nipani', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1761, 'Nitte', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1762, 'Nyamati', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1763, 'Padu', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1764, 'Pandavapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1765, 'Pattanagere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1766, 'Pavagada', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1767, 'Piriyapatna', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1768, 'Ponnampet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1769, 'Puttur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1770, 'Rabkavi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1771, 'Raichur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1772, 'Ramanagaram', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1773, 'Ramdurg', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1774, 'Ranibennur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1775, 'Raybag', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1776, 'Robertsonpet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1777, 'Ron', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1778, 'Sadalgi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1779, 'Sagar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1780, 'Sakleshpur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1781, 'Saligram', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1782, 'Sandur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1783, 'Sanivarsante', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1784, 'Sankeshwar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1785, 'Sargur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1786, 'Sathyamangala', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1787, 'Saundatti Yellamma', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1788, 'Savanur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1789, 'Sedam', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1790, 'Shahabad', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1791, 'Shahabad A.C.C.', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1792, 'Shahapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1793, 'Shahpur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1794, 'Shaktinagar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1795, 'Shiggaon', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1796, 'Shikarpur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1797, 'Shimoga', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1798, 'Shirhatti', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1799, 'Shorapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1800, 'Shravanabelagola', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1801, 'Shrirangapattana', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1802, 'Siddapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1803, 'Sidlaghatta', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1804, 'Sindgi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1805, 'Sindhnur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1806, 'Sira', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1807, 'Sirakoppa', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1808, 'Sirsi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1809, 'Siruguppa', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1810, 'Someshwar', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1811, 'Somvarpet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1812, 'Sorab', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1813, 'Sringeri', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1814, 'Srinivaspur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1815, 'Sulya', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1816, 'Suntikopa', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1817, 'Talikota', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1818, 'Tarikera', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1819, 'Tekkalakota', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1820, 'Terdal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1821, 'Thokur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1822, 'Thumbe', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1823, 'Tiptur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1824, 'Tirthahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1825, 'Tirumakudal Narsipur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1826, 'Tonse', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1827, 'Tumkur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1828, 'Turuvekere', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1829, 'Udupi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1830, 'Ullal', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1831, 'Uttarahalli', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1832, 'Venkatapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1833, 'Vijayapura', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1834, 'Virarajendrapet', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1835, 'Wadi', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1836, 'Wadi A.C.C.', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1837, 'Yadgir', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1838, 'Yelahanka', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1839, 'Yelandur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1840, 'Yelbarga', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1841, 'Yellapur', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1842, 'Yenagudde', 17, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1843, 'Adimaly', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1844, 'Adoor', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1845, 'Adur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1846, 'Akathiyur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1847, 'Alangad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1848, 'Alappuzha', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1849, 'Aluva', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1850, 'Ancharakandy', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1851, 'Angamaly', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1852, 'Aroor', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1853, 'Arukutti', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1854, 'Attingal', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1855, 'Avinissery', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1856, 'Azhikode North', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1857, 'Azhikode South', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1858, 'Azhiyur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1859, 'Balussery', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1860, 'Bangramanjeshwar', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1861, 'Beypur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1862, 'Brahmakulam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1863, 'Chala', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1864, 'Chalakudi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1865, 'Changanacheri', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1866, 'Chauwara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1867, 'Chavakkad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1868, 'Chelakkara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1869, 'Chelora', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1870, 'Chendamangalam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1871, 'Chengamanad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1872, 'Chengannur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1873, 'Cheranallur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1874, 'Cheriyakadavu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1875, 'Cherthala', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1876, 'Cherukunnu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1877, 'Cheruthazham', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1878, 'Cheruvannur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1879, 'Cheruvattur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1880, 'Chevvur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1881, 'Chirakkal', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1882, 'Chittur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1883, 'Chockli', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1884, 'Churnikkara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1885, 'Dharmadam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1886, 'Edappal', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1887, 'Edathala', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1888, 'Elayavur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1889, 'Elur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1890, 'Eranholi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1891, 'Erattupetta', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1892, 'Ernakulam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1893, 'Eruvatti', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1894, 'Ettumanoor', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1895, 'Feroke', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1896, 'Guruvayur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1897, 'Haripad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1898, 'Hosabettu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1899, 'Idukki', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1900, 'Iringaprom', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1901, 'Irinjalakuda', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1902, 'Iriveri', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1903, 'Kadachira', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1904, 'Kadalundi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1905, 'Kadamakkudy', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1906, 'Kadirur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1907, 'Kadungallur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1908, 'Kakkodi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1909, 'Kalady', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1910, 'Kalamassery', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1911, 'Kalliasseri', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1912, 'Kalpetta', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1913, 'Kanhangad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1914, 'Kanhirode', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1915, 'Kanjikkuzhi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1916, 'Kanjikode', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1917, 'Kanjirappalli', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1918, 'Kannadiparamba', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1919, 'Kannangad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1920, 'Kannapuram', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1921, 'Kannur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1922, 'Kannur Cantonment', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1923, 'Karunagappally', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1924, 'Karuvamyhuruthy', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1925, 'Kasaragod', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1926, 'Kasargod', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1927, 'Kattappana', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1928, 'Kayamkulam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1929, 'Kedamangalam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1930, 'Kochi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1931, 'Kodamthuruthu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1932, 'Kodungallur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1933, 'Koduvally', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1934, 'Koduvayur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1935, 'Kokkothamangalam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1936, 'Kolazhy', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1937, 'Kollam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1938, 'Komalapuram', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1939, 'Koothattukulam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1940, 'Koratty', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1941, 'Kothamangalam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1942, 'Kottarakkara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1943, 'Kottayam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1944, 'Kottayam Malabar', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1945, 'Kottuvally', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1946, 'Koyilandi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1947, 'Kozhikode', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1948, 'Kudappanakunnu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1949, 'Kudlu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1950, 'Kumarakom', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1951, 'Kumily', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1952, 'Kunnamangalam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1953, 'Kunnamkulam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1954, 'Kurikkad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1955, 'Kurkkanchery', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1956, 'Kuthuparamba', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1957, 'Kuttakulam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1958, 'Kuttikkattur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1959, 'Kuttur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1960, 'Malappuram', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1961, 'Mallappally', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1962, 'Manjeri', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1963, 'Manjeshwar', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1964, 'Mannancherry', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1965, 'Mannar', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1966, 'Mannarakkat', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1967, 'Maradu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1968, 'Marathakkara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1969, 'Marutharod', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1970, 'Mattannur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1971, 'Mavelikara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1972, 'Mavilayi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1973, 'Mavur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1974, 'Methala', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1975, 'Muhamma', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1976, 'Mulavukad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1977, 'Mundakayam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1978, 'Munderi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1979, 'Munnar', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1980, 'Muthakunnam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1981, 'Muvattupuzha', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1982, 'Muzhappilangad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1983, 'Nadapuram', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1984, 'Nadathara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1985, 'Narath', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1986, 'Nattakam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1987, 'Nedumangad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1988, 'Nenmenikkara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1989, 'New Mahe', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1990, 'Neyyattinkara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1991, 'Nileshwar', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1992, 'Olavanna', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1993, 'Ottapalam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1994, 'Ottappalam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1995, 'Paduvilayi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1996, 'Palai', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1997, 'Palakkad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1998, 'Palayad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (1999, 'Palissery', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2000, 'Pallikkunnu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2001, 'Paluvai', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2002, 'Panniyannur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2003, 'Pantalam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2004, 'Panthiramkavu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2005, 'Panur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2006, 'Pappinisseri', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2007, 'Parassala', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2008, 'Paravur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2009, 'Pathanamthitta', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2010, 'Pathanapuram', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2011, 'Pathiriyad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2012, 'Pattambi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2013, 'Pattiom', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2014, 'Pavaratty', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2015, 'Payyannur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2016, 'Peermade', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2017, 'Perakam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2018, 'Peralasseri', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2019, 'Peringathur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2020, 'Perinthalmanna', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2021, 'Perole', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2022, 'Perumanna', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2023, 'Perumbaikadu', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2024, 'Perumbavoor', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2025, 'Pinarayi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2026, 'Piravam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2027, 'Ponnani', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2028, 'Pottore', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2029, 'Pudukad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2030, 'Punalur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2031, 'Puranattukara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2032, 'Puthunagaram', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2033, 'Puthuppariyaram', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2034, 'Puzhathi', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2035, 'Ramanattukara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2036, 'Shoranur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2037, 'Sultans Battery', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2038, 'Sulthan Bathery', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2039, 'Talipparamba', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2040, 'Thaikkad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2041, 'Thalassery', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2042, 'Thannirmukkam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2043, 'Theyyalingal', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2044, 'Thiruvalla', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2045, 'Thiruvananthapuram', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2046, 'Thiruvankulam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2047, 'Thodupuzha', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2048, 'Thottada', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2049, 'Thrippunithura', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2050, 'Thrissur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2051, 'Tirur', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2052, 'Udma', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2053, 'Vadakara', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2054, 'Vaikam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2055, 'Valapattam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2056, 'Vallachira', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2057, 'Varam', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2058, 'Varappuzha', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2059, 'Varkala', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2060, 'Vayalar', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2061, 'Vazhakkala', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2062, 'Venmanad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2063, 'Villiappally', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2064, 'Wayanad', 19, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2065, 'Agethi', 20, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2066, 'Amini', 20, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2067, 'Androth Island', 20, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2068, 'Kavaratti', 20, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2069, 'Minicoy', 20, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2070, 'Agar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2071, 'Ajaigarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2072, 'Akoda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2073, 'Akodia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2074, 'Alampur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2075, 'Alirajpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2076, 'Alot', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2077, 'Amanganj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2078, 'Amarkantak', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2079, 'Amarpatan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2080, 'Amarwara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2081, 'Ambada', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2082, 'Ambah', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2083, 'Amla', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2084, 'Amlai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2085, 'Anjad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2086, 'Antri', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2087, 'Anuppur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2088, 'Aron', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2089, 'Ashoknagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2090, 'Ashta', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2091, 'Babai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2092, 'Bada Malhera', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2093, 'Badagaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2094, 'Badagoan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2095, 'Badarwas', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2096, 'Badawada', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2097, 'Badi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2098, 'Badkuhi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2099, 'Badnagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2100, 'Badnawar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2101, 'Badod', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2102, 'Badoda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2103, 'Badra', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2104, 'Bagh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2105, 'Bagli', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2106, 'Baihar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2107, 'Baikunthpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2108, 'Bakswaha', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2109, 'Balaghat', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2110, 'Baldeogarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2111, 'Bamaniya', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2112, 'Bamhani', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2113, 'Bamor', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2114, 'Bamora', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2115, 'Banda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2116, 'Bangawan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2117, 'Bansatar Kheda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2118, 'Baraily', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2119, 'Barela', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2120, 'Barghat', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2121, 'Bargi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2122, 'Barhi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2123, 'Barigarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2124, 'Barwaha', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2125, 'Barwani', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2126, 'Basoda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2127, 'Begamganj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2128, 'Beohari', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2129, 'Berasia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2130, 'Betma', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2131, 'Betul', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2132, 'Betul Bazar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2133, 'Bhainsdehi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2134, 'Bhamodi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2135, 'Bhander', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2136, 'Bhanpura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2137, 'Bharveli', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2138, 'Bhaurasa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2139, 'Bhavra', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2140, 'Bhedaghat', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2141, 'Bhikangaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2142, 'Bhilakhedi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2143, 'Bhind', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2144, 'Bhitarwar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2145, 'Bhopal', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2146, 'Bhuibandh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2147, 'Biaora', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2148, 'Bijawar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2149, 'Bijeypur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2150, 'Bijrauni', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2151, 'Bijuri', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2152, 'Bilaua', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2153, 'Bilpura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2154, 'Bina Railway Colony', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2155, 'Bina-Etawa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2156, 'Birsinghpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2157, 'Boda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2158, 'Budhni', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2159, 'Burhanpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2160, 'Burhar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2161, 'Chachaura Binaganj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2162, 'Chakghat', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2163, 'Chandameta Butar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2164, 'Chanderi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2165, 'Chandia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2166, 'Chandla', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2167, 'Chaurai Khas', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2168, 'Chhatarpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2169, 'Chhindwara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2170, 'Chhota Chhindwara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2171, 'Chichli', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2172, 'Chitrakut', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2173, 'Churhat', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2174, 'Daboh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2175, 'Dabra', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2176, 'Damoh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2177, 'Damua', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2178, 'Datia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2179, 'Deodara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2180, 'Deori', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2181, 'Deori Khas', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2182, 'Depalpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2183, 'Devendranagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2184, 'Devhara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2185, 'Dewas', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2186, 'Dhamnod', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2187, 'Dhana', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2188, 'Dhanpuri', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2189, 'Dhar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2190, 'Dharampuri', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2191, 'Dighawani', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2192, 'Diken', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2193, 'Dindori', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2194, 'Dola', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2195, 'Dumar Kachhar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2196, 'Dungariya Chhapara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2197, 'Gadarwara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2198, 'Gairatganj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2199, 'Gandhi Sagar Hydel Colony', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2200, 'Ganjbasoda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2201, 'Garhakota', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2202, 'Garhi Malhara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2203, 'Garoth', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2204, 'Gautapura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2205, 'Ghansor', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2206, 'Ghuwara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2207, 'Gogaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2208, 'Gogapur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2209, 'Gohad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2210, 'Gormi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2211, 'Govindgarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2212, 'Guna', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2213, 'Gurh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2214, 'Gwalior', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2215, 'Hanumana', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2216, 'Harda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2217, 'Harpalpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2218, 'Harrai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2219, 'Harsud', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2220, 'Hatod', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2221, 'Hatpipalya', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2222, 'Hatta', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2223, 'Hindoria', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2224, 'Hirapur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2225, 'Hoshangabad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2226, 'Ichhawar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2227, 'Iklehra', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2228, 'Indergarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2229, 'Indore', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2230, 'Isagarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2231, 'Itarsi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2232, 'Jabalpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2233, 'Jabalpur Cantonment', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2234, 'Jabalpur G.C.F', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2235, 'Jaisinghnagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2236, 'Jaithari', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2237, 'Jaitwara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2238, 'Jamai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2239, 'Jaora', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2240, 'Jatachhapar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2241, 'Jatara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2242, 'Jawad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2243, 'Jawar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2244, 'Jeronkhalsa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2245, 'Jhabua', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2246, 'Jhundpura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2247, 'Jiran', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2248, 'Jirapur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2249, 'Jobat', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2250, 'Joura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2251, 'Kailaras', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2252, 'Kaimur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2253, 'Kakarhati', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2254, 'Kalichhapar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2255, 'Kanad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2256, 'Kannod', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2257, 'Kantaphod', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2258, 'Kareli', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2259, 'Karera', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2260, 'Kari', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2261, 'Karnawad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2262, 'Karrapur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2263, 'Kasrawad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2264, 'Katangi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2265, 'Katni', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2266, 'Kelhauri', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2267, 'Khachrod', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2268, 'Khajuraho', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2269, 'Khamaria', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2270, 'Khand', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2271, 'Khandwa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2272, 'Khaniyadhana', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2273, 'Khargapur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2274, 'Khargone', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2275, 'Khategaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2276, 'Khetia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2277, 'Khilchipur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2278, 'Khirkiya', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2279, 'Khujner', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2280, 'Khurai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2281, 'Kolaras', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2282, 'Kotar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2283, 'Kothi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2284, 'Kotma', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2285, 'Kukshi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2286, 'Kumbhraj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2287, 'Kurwai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2288, 'Lahar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2289, 'Lakhnadon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2290, 'Lateri', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2291, 'Laundi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2292, 'Lidhora Khas', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2293, 'Lodhikheda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2294, 'Loharda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2295, 'Machalpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2296, 'Madhogarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2297, 'Maharajpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2298, 'Maheshwar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2299, 'Mahidpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2300, 'Maihar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2301, 'Majholi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2302, 'Makronia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2303, 'Maksi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2304, 'Malaj Khand', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2305, 'Malanpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2306, 'Malhargarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2307, 'Manasa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2308, 'Manawar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2309, 'Mandav', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2310, 'Mandideep', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2311, 'Mandla', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2312, 'Mandleshwar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2313, 'Mandsaur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2314, 'Manegaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2315, 'Mangawan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2316, 'Manglaya Sadak', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2317, 'Manpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2318, 'Mau', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2319, 'Mauganj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2320, 'Meghnagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2321, 'Mehara Gaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2322, 'Mehgaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2323, 'Mhaugaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2324, 'Mhow', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2325, 'Mihona', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2326, 'Mohgaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2327, 'Morar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2328, 'Morena', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2329, 'Morwa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2330, 'Multai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2331, 'Mundi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2332, 'Mungaoli', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2333, 'Murwara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2334, 'Nagda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2335, 'Nagod', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2336, 'Nagri', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2337, 'Naigarhi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2338, 'Nainpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2339, 'Nalkheda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2340, 'Namli', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2341, 'Narayangarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2342, 'Narsimhapur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2343, 'Narsingarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2344, 'Narsinghpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2345, 'Narwar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2346, 'Nasrullaganj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2347, 'Naudhia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2348, 'Naugaon', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2349, 'Naurozabad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2350, 'Neemuch', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2351, 'Nepa Nagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2352, 'Neuton Chikhli Kalan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2353, 'Nimach', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2354, 'Niwari', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2355, 'Obedullaganj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2356, 'Omkareshwar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2357, 'Orachha', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2358, 'Ordinance Factory Itarsi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2359, 'Pachmarhi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2360, 'Pachmarhi Cantonment', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2361, 'Pachore', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2362, 'Palchorai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2363, 'Palda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2364, 'Palera', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2365, 'Pali', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2366, 'Panagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2367, 'Panara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2368, 'Pandaria', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2369, 'Pandhana', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2370, 'Pandhurna', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2371, 'Panna', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2372, 'Pansemal', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2373, 'Parasia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2374, 'Pasan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2375, 'Patan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2376, 'Patharia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2377, 'Pawai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2378, 'Petlawad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2379, 'Phuph Kalan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2380, 'Pichhore', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2381, 'Pipariya', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2382, 'Pipliya Mandi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2383, 'Piploda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2384, 'Pithampur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2385, 'Polay Kalan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2386, 'Porsa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2387, 'Prithvipur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2388, 'Raghogarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2389, 'Rahatgarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2390, 'Raisen', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2391, 'Rajakhedi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2392, 'Rajgarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2393, 'Rajnagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2394, 'Rajpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2395, 'Rampur Baghelan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2396, 'Rampur Naikin', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2397, 'Rampura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2398, 'Ranapur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2399, 'Ranipura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2400, 'Ratangarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2401, 'Ratlam', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2402, 'Ratlam Kasba', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2403, 'Rau', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2404, 'Rehli', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2405, 'Rehti', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2406, 'Rewa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2407, 'Sabalgarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2408, 'Sagar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2409, 'Sagar Cantonment', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2410, 'Sailana', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2411, 'Sanawad', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2412, 'Sanchi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2413, 'Sanwer', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2414, 'Sarangpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2415, 'Sardarpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2416, 'Sarni', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2417, 'Satai', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2418, 'Satna', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2419, 'Satwas', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2420, 'Sausar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2421, 'Sehore', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2422, 'Semaria', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2423, 'Sendhwa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2424, 'Seondha', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2425, 'Seoni', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2426, 'Seoni Malwa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2427, 'Sethia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2428, 'Shahdol', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2429, 'Shahgarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2430, 'Shahpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2431, 'Shahpura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2432, 'Shajapur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2433, 'Shamgarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2434, 'Sheopur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2435, 'Shivpuri', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2436, 'Shujalpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2437, 'Sidhi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2438, 'Sihora', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2439, 'Singolo', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2440, 'Singrauli', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2441, 'Sinhasa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2442, 'Sirgora', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2443, 'Sirmaur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2444, 'Sironj', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2445, 'Sitamau', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2446, 'Sohagpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2447, 'Sonkatch', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2448, 'Soyatkalan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2449, 'Suhagi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2450, 'Sultanpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2451, 'Susner', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2452, 'Suthaliya', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2453, 'Tal', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2454, 'Talen', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2455, 'Tarana', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2456, 'Taricharkalan', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2457, 'Tekanpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2458, 'Tendukheda', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2459, 'Teonthar', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2460, 'Thandia', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2461, 'Tikamgarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2462, 'Timarni', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2463, 'Tirodi', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2464, 'Udaipura', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2465, 'Ujjain', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2466, 'Ukwa', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2467, 'Umaria', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2468, 'Unchahara', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2469, 'Unhel', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2470, 'Vehicle Factory Jabalpur', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2471, 'Vidisha', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2472, 'Vijayraghavgarh', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2473, 'Waraseoni', 21, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2474, 'Achalpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2475, 'Aheri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2476, 'Ahmadnagar Cantonment', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2477, 'Ahmadpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2478, 'Ahmednagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2479, 'Ajra', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2480, 'Akalkot', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2481, 'Akkalkuwa', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2482, 'Akola', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2483, 'Akot', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2484, 'Alandi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2485, 'Alibag', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2486, 'Allapalli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2487, 'Alore', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2488, 'Amalner', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2489, 'Ambad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2490, 'Ambajogai', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2491, 'Ambernath', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2492, 'Ambivali Tarf Wankhal', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2493, 'Amgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2494, 'Amravati', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2495, 'Anjangaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2496, 'Arvi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2497, 'Ashta', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2498, 'Ashti', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2499, 'Aurangabad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2500, 'Aurangabad Cantonment', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2501, 'Ausa', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2502, 'Babhulgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2503, 'Badlapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2504, 'Balapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2505, 'Ballarpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2506, 'Baramati', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2507, 'Barshi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2508, 'Basmat', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2509, 'Beed', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2510, 'Bhadravati', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2511, 'Bhagur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2512, 'Bhandara', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2513, 'Bhigvan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2514, 'Bhingar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2515, 'Bhiwandi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2516, 'Bhokhardan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2517, 'Bhor', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2518, 'Bhosari', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2519, 'Bhum', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2520, 'Bhusawal', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2521, 'Bid', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2522, 'Biloli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2523, 'Birwadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2524, 'Boisar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2525, 'Bop Khel', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2526, 'Brahmapuri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2527, 'Budhgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2528, 'Buldana', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2529, 'Buldhana', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2530, 'Butibori', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2531, 'Chakan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2532, 'Chalisgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2533, 'Chandrapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2534, 'Chandur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2535, 'Chandur Bazar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2536, 'Chandvad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2537, 'Chicholi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2538, 'Chikhala', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2539, 'Chikhaldara', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2540, 'Chikhli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2541, 'Chinchani', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2542, 'Chinchwad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2543, 'Chiplun', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2544, 'Chopda', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2545, 'Dabhol', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2546, 'Dahance', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2547, 'Dahanu', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2548, 'Daharu', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2549, 'Dapoli Camp', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2550, 'Darwa', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2551, 'Daryapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2552, 'Dattapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2553, 'Daund', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2554, 'Davlameti', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2555, 'Deglur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2556, 'Dehu Road', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2557, 'Deolali', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2558, 'Deolali Pravara', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2559, 'Deoli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2560, 'Desaiganj', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2561, 'Deulgaon Raja', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2562, 'Dewhadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2563, 'Dharangaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2564, 'Dharmabad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2565, 'Dharur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2566, 'Dhatau', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2567, 'Dhule', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2568, 'Digdoh', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2569, 'Diglur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2570, 'Digras', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2571, 'Dombivli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2572, 'Dondaicha', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2573, 'Dudhani', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2574, 'Durgapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2575, 'Dyane', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2576, 'Edandol', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2577, 'Eklahare', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2578, 'Faizpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2579, 'Fekari', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2580, 'Gadchiroli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2581, 'Gadhinghaj', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2582, 'Gandhi Nagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2583, 'Ganeshpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2584, 'Gangakher', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2585, 'Gangapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2586, 'Gevrai', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2587, 'Ghatanji', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2588, 'Ghoti', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2589, 'Ghugus', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2590, 'Ghulewadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2591, 'Godoli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2592, 'Gondia', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2593, 'Guhagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2594, 'Hadgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2595, 'Harnai Beach', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2596, 'Hinganghat', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2597, 'Hingoli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2598, 'Hupari', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2599, 'Ichalkaranji', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2600, 'Igatpuri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2601, 'Indapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2602, 'Jaisinghpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2603, 'Jalgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2604, 'Jalna', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2605, 'Jamkhed', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2606, 'Jawhar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2607, 'Jaysingpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2608, 'Jejuri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2609, 'Jintur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2610, 'Junnar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2611, 'Kabnur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2612, 'Kagal', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2613, 'Kalamb', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2614, 'Kalamnuri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2615, 'Kalas', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2616, 'Kalmeshwar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2617, 'Kalundre', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2618, 'Kalyan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2619, 'Kamthi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2620, 'Kamthi Cantonment', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2621, 'Kandari', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2622, 'Kandhar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2623, 'Kandri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2624, 'Kandri II', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2625, 'Kanhan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2626, 'Kankavli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2627, 'Kannad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2628, 'Karad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2629, 'Karanja', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2630, 'Karanje Tarf', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2631, 'Karivali', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2632, 'Karjat', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2633, 'Karmala', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2634, 'Kasara Budruk', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2635, 'Katai', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2636, 'Katkar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2637, 'Katol', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2638, 'Kegaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2639, 'Khadkale', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2640, 'Khadki', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2641, 'Khamgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2642, 'Khapa', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2643, 'Kharadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2644, 'Kharakvasla', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2645, 'Khed', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2646, 'Kherdi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2647, 'Khoni', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2648, 'Khopoli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2649, 'Khuldabad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2650, 'Kinwat', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2651, 'Kodoli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2652, 'Kolhapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2653, 'Kon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2654, 'Kondumal', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2655, 'Kopargaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2656, 'Kopharad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2657, 'Koradi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2658, 'Koregaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2659, 'Korochi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2660, 'Kudal', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2661, 'Kundaim', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2662, 'Kundalwadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2663, 'Kurandvad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2664, 'Kurduvadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2665, 'Kusgaon Budruk', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2666, 'Lanja', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2667, 'Lasalgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2668, 'Latur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2669, 'Loha', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2670, 'Lohegaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2671, 'Lonar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2672, 'Lonavala', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2673, 'Madhavnagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2674, 'Mahabaleshwar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2675, 'Mahad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2676, 'Mahadula', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2677, 'Maindargi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2678, 'Majalgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2679, 'Malegaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2680, 'Malgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2681, 'Malkapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2682, 'Malwan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2683, 'Manadur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2684, 'Manchar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2685, 'Mangalvedhe', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2686, 'Mangrul Pir', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2687, 'Manmad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2688, 'Manor', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2689, 'Mansar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2690, 'Manwath', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2691, 'Mapuca', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2692, 'Matheran', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2693, 'Mehkar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2694, 'Mhasla', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2695, 'Mhaswad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2696, 'Mira Bhayandar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2697, 'Miraj', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2698, 'Mohpa', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2699, 'Mohpada', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2700, 'Moram', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2701, 'Morshi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2702, 'Mowad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2703, 'Mudkhed', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2704, 'Mukhed', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2705, 'Mul', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2706, 'Mulshi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2707, 'Mumbai', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2708, 'Murbad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2709, 'Murgud', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2710, 'Murtijapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2711, 'Murud', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2712, 'Nachane', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2713, 'Nagardeole', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2714, 'Nagothane', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2715, 'Nagpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2716, 'Nakoda', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2717, 'Nalasopara', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2718, 'Naldurg', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2719, 'Nanded', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2720, 'Nandgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2721, 'Nandura', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2722, 'Nandurbar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2723, 'Narkhed', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2724, 'Nashik', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2725, 'Navapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2726, 'Navi Mumbai', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2727, 'Navi Mumbai Panvel', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2728, 'Neral', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2729, 'Nigdi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2730, 'Nilanga', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2731, 'Nildoh', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2732, 'Nimbhore', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2733, 'Ojhar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2734, 'Osmanabad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2735, 'Pachgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2736, 'Pachora', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2737, 'Padagha', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2738, 'Paithan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2739, 'Palghar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2740, 'Pali', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2741, 'Panchgani', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2742, 'Pandhakarwada', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2743, 'Pandharpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2744, 'Panhala', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2745, 'Panvel', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2746, 'Paranda', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2747, 'Parbhani', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2748, 'Parli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2749, 'Parola', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2750, 'Partur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2751, 'Pasthal', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2752, 'Patan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2753, 'Pathardi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2754, 'Pathri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2755, 'Patur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2756, 'Pawni', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2757, 'Pen', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2758, 'Pethumri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2759, 'Phaltan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2760, 'Pimpri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2761, 'Poladpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2762, 'Pulgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2763, 'Pune', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2764, 'Pune Cantonment', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2765, 'Purna', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2766, 'Purushottamnagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2767, 'Pusad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2768, 'Rahimatpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2769, 'Rahta Pimplas', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2770, 'Rahuri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2771, 'Raigad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2772, 'Rajapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2773, 'Rajgurunagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2774, 'Rajur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2775, 'Rajura', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2776, 'Ramtek', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2777, 'Ratnagiri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2778, 'Ravalgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2779, 'Raver', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2780, 'Revadanda', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2781, 'Risod', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2782, 'Roha Ashtami', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2783, 'Sakri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2784, 'Sandor', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2785, 'Sangamner', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2786, 'Sangli', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2787, 'Sangole', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2788, 'Sasti', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2789, 'Sasvad', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2790, 'Satana', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2791, 'Satara', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2792, 'Savantvadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2793, 'Savda', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2794, 'Savner', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2795, 'Sawari Jawharnagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2796, 'Selu', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2797, 'Shahada', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2798, 'Shahapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2799, 'Shegaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2800, 'Shelar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2801, 'Shendurjana', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2802, 'Shirdi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2803, 'Shirgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2804, 'Shirpur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2805, 'Shirur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2806, 'Shirwal', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2807, 'Shivatkar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2808, 'Shrigonda', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2809, 'Shrirampur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2810, 'Shrirampur Rural', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2811, 'Sillewada', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2812, 'Sillod', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2813, 'Sindhudurg', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2814, 'Sindi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2815, 'Sindi Turf Hindnagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2816, 'Sindkhed Raja', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2817, 'Singnapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2818, 'Sinnar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2819, 'Sirur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2820, 'Sitasawangi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2821, 'Solapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2822, 'Sonai', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2823, 'Sonegaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2824, 'Soyagaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2825, 'Srivardhan', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2826, 'Surgana', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2827, 'Talegaon Dabhade', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2828, 'Taloda', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2829, 'Taloja', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2830, 'Talwade', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2831, 'Tarapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2832, 'Tasgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2833, 'Tathavade', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2834, 'Tekadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2835, 'Telhara', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2836, 'Thane', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2837, 'Tirira', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2838, 'Totaladoh', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2839, 'Trimbak', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2840, 'Tuljapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2841, 'Tumsar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2842, 'Uchgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2843, 'Udgir', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2844, 'Ulhasnagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2845, 'Umarga', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2846, 'Umarkhed', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2847, 'Umarsara', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2848, 'Umbar Pada Nandade', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2849, 'Umred', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2850, 'Umri Pragane Balapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2851, 'Uran', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2852, 'Uran Islampur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2853, 'Utekhol', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2854, 'Vada', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2855, 'Vadgaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2856, 'Vadgaon Kasba', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2857, 'Vaijapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2858, 'Vanvadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2859, 'Varangaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2860, 'Vasai', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2861, 'Vasantnagar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2862, 'Vashind', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2863, 'Vengurla', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2864, 'Virar', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2865, 'Visapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2866, 'Vite', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2867, 'Vithalwadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2868, 'Wadi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2869, 'Waghapur', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2870, 'Wai', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2871, 'Wajegaon', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2872, 'Walani', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2873, 'Wanadongri', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2874, 'Wani', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2875, 'Wardha', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2876, 'Warora', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2877, 'Warthi', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2878, 'Warud', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2879, 'Washim', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2880, 'Yaval', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2881, 'Yavatmal', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2882, 'Yeola', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2883, 'Yerkheda', 22, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2884, 'Andro', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2885, 'Bijoy Govinda', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2886, 'Bishnupur', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2887, 'Churachandpur', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2888, 'Heriok', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2889, 'Imphal', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2890, 'Jiribam', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2891, 'Kakching', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2892, 'Kakching Khunou', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2893, 'Khongman', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2894, 'Kumbi', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2895, 'Kwakta', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2896, 'Lamai', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2897, 'Lamjaotongba', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2898, 'Lamshang', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2899, 'Lilong', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2900, 'Mayang Imphal', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2901, 'Moirang', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2902, 'Moreh', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2903, 'Nambol', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2904, 'Naoriya Pakhanglakpa', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2905, 'Ningthoukhong', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2906, 'Oinam', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2907, 'Porompat', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2908, 'Samurou', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2909, 'Sekmai Bazar', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2910, 'Senapati', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2911, 'Sikhong Sekmai', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2912, 'Sugnu', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2913, 'Thongkhong Laxmi Bazar', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2914, 'Thoubal', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2915, 'Torban', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2916, 'Wangjing', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2917, 'Wangoi', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2918, 'Yairipok', 23, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2919, 'Baghmara', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2920, 'Cherrapunji', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2921, 'Jawai', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2922, 'Madanrting', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2923, 'Mairang', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2924, 'Mawlai', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2925, 'Nongmynsong', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2926, 'Nongpoh', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2927, 'Nongstoin', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2928, 'Nongthymmai', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2929, 'Pynthorumkhrah', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2930, 'Resubelpara', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2931, 'Shillong', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2932, 'Shillong Cantonment', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2933, 'Tura', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2934, 'Williamnagar', 24, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2935, 'Aizawl', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2936, 'Bairabi', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2937, 'Biate', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2938, 'Champhai', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2939, 'Darlawn', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2940, 'Hnahthial', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2941, 'Kawnpui', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2942, 'Khawhai', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2943, 'Khawzawl', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2944, 'Kolasib', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2945, 'Lengpui', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2946, 'Lunglei', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2947, 'Mamit', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2948, 'North Vanlaiphai', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2949, 'Saiha', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2950, 'Sairang', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2951, 'Saitul', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2952, 'Serchhip', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2953, 'Thenzawl', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2954, 'Tlabung', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2955, 'Vairengte', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2956, 'Zawlnuam', 25, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2957, 'Chumukedima', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2958, 'Dimapur', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2959, 'Kohima', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2960, 'Mokokchung', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2961, 'Mon', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2962, 'Phek', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2963, 'Tuensang', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2964, 'Wokha', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2965, 'Zunheboto', 26, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2966, 'Anandapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2967, 'Angul', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2968, 'Aska', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2969, 'Athgarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2970, 'Athmallik', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2971, 'Balagoda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2972, 'Balangir', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2973, 'Balasore', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2974, 'Baleshwar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2975, 'Balimeta', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2976, 'Balugaon', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2977, 'Banapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2978, 'Bangura', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2979, 'Banki', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2980, 'Banposh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2981, 'Barbil', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2982, 'Bargarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2983, 'Baripada', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2984, 'Barpali', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2985, 'Basudebpur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2986, 'Baudh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2987, 'Belagachhia', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2988, 'Belaguntha', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2989, 'Belpahar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2990, 'Berhampur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2991, 'Bhadrak', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2992, 'Bhanjanagar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2993, 'Bhawanipatna', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2994, 'Bhuban', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2995, 'Bhubaneswar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2996, 'Binika', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2997, 'Birmitrapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2998, 'Bishama Katek', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (2999, 'Bolangir', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3000, 'Brahmapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3001, 'Brajrajnagar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3002, 'Buguda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3003, 'Burla', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3004, 'Byasanagar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3005, 'Champua', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3006, 'Chandapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3007, 'Chandbali', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3008, 'Chandili', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3009, 'Charibatia', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3010, 'Chatrapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3011, 'Chikitigarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3012, 'Chitrakonda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3013, 'Choudwar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3014, 'Cuttack', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3015, 'Dadhapatna', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3016, 'Daitari', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3017, 'Damanjodi', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3018, 'Deogarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3019, 'Deracolliery', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3020, 'Dhamanagar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3021, 'Dhenkanal', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3022, 'Digapahandi', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3023, 'Dungamal', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3024, 'Fertilizer Corporation of Indi', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3025, 'Ganjam', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3026, 'Ghantapada', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3027, 'Gopalpur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3028, 'Gudari', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3029, 'Gunupur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3030, 'Hatibandha', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3031, 'Hinjilikatu', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3032, 'Hirakud', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3033, 'Jagatsinghapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3034, 'Jajpur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3035, 'Jalda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3036, 'Jaleswar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3037, 'Jatni', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3038, 'Jaypur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3039, 'Jeypore', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3040, 'Jharsuguda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3041, 'Jhumpura', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3042, 'Joda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3043, 'Junagarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3044, 'Kamakhyanagar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3045, 'Kantabanji', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3046, 'Kantilo', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3047, 'Karanja', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3048, 'Kashinagara', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3049, 'Kataka', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3050, 'Kavisuryanagar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3051, 'Kendrapara', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3052, 'Kendujhar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3053, 'Keonjhar', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3054, 'Kesinga', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3055, 'Khaliapali', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3056, 'Khalikote', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3057, 'Khandaparha', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3058, 'Kharhial', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3059, 'Kharhial Road', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3060, 'Khatiguda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3061, 'Khurda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3062, 'Kochinda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3063, 'Kodala', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3064, 'Konark', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3065, 'Koraput', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3066, 'Kotaparh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3067, 'Lanjigarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3068, 'Lattikata', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3069, 'Makundapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3070, 'Malkangiri', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3071, 'Mukhiguda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3072, 'Nabarangpur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3073, 'Nalco', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3074, 'Naurangapur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3075, 'Nayagarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3076, 'Nilagiri', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3077, 'Nimaparha', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3078, 'Nuapada', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3079, 'Nuapatna', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3080, 'OCL Industrialship', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3081, 'Padampur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3082, 'Paradip', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3083, 'Paradwip', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3084, 'Parlakimidi', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3085, 'Patamundai', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3086, 'Patnagarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3087, 'Phulabani', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3088, 'Pipili', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3089, 'Polasara', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3090, 'Pratapsasan', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3091, 'Puri', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3092, 'Purushottampur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3093, 'Rairangpur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3094, 'Raj Gangpur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3095, 'Rambha', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3096, 'Raurkela', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3097, 'Raurkela Civil Township', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3098, 'Rayagada', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3099, 'Redhakhol', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3100, 'Remuna', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3101, 'Rengali', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3102, 'Rourkela', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3103, 'Sambalpur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3104, 'Sinapali', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3105, 'Sonepur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3106, 'Sorada', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3107, 'Soro', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3108, 'Sunabeda', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3109, 'Sundargarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3110, 'Talcher', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3111, 'Talcher Thermal Power Station ', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3112, 'Tarabha', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3113, 'Tensa', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3114, 'Titlagarh', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3115, 'Udala', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3116, 'Udayagiri', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3117, 'Umarkot', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3118, 'Vikrampur', 29, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3119, 'Ariankuppam', 31, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3120, 'Karaikal', 31, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3121, 'Kurumbapet', 31, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3122, 'Mahe', 31, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3123, 'Ozhukarai', 31, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3124, 'Pondicherry', 31, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3125, 'Villianur', 31, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3126, 'Yanam', 31, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3127, 'Abohar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3128, 'Adampur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3129, 'Ahmedgarh', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3130, 'Ajnala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3131, 'Akalgarh', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3132, 'Alawalpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3133, 'Amloh', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3134, 'Amritsar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3135, 'Amritsar Cantonment', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3136, 'Anandpur Sahib', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3137, 'Badhni Kalan', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3138, 'Bagh Purana', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3139, 'Balachaur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3140, 'Banaur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3141, 'Banga', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3142, 'Banur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3143, 'Baretta', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3144, 'Bariwala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3145, 'Barnala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3146, 'Bassi Pathana', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3147, 'Batala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3148, 'Bathinda', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3149, 'Begowal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3150, 'Behrampur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3151, 'Bhabat', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3152, 'Bhadur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3153, 'Bhankharpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3154, 'Bharoli Kalan', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3155, 'Bhawanigarh', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3156, 'Bhikhi', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3157, 'Bhikhiwind', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3158, 'Bhisiana', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3159, 'Bhogpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3160, 'Bhuch', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3161, 'Bhulath', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3162, 'Budha Theh', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3163, 'Budhlada', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3164, 'Chima', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3165, 'Chohal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3166, 'Dasuya', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3167, 'Daulatpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3168, 'Dera Baba Nanak', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3169, 'Dera Bassi', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3170, 'Dhanaula', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3171, 'Dharam Kot', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3172, 'Dhariwal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3173, 'Dhilwan', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3174, 'Dhuri', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3175, 'Dinanagar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3176, 'Dirba', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3177, 'Doraha', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3178, 'Faridkot', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3179, 'Fateh Nangal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3180, 'Fatehgarh Churian', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3181, 'Fatehgarh Sahib', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3182, 'Fazilka', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3183, 'Firozpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3184, 'Firozpur Cantonment', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3185, 'Gardhiwala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3186, 'Garhshankar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3187, 'Ghagga', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3188, 'Ghanaur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3189, 'Giddarbaha', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3190, 'Gobindgarh', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3191, 'Goniana', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3192, 'Goraya', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3193, 'Gurdaspur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3194, 'Guru Har Sahai', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3195, 'Hajipur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3196, 'Handiaya', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3197, 'Hariana', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3198, 'Hoshiarpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3199, 'Hussainpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3200, 'Jagraon', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3201, 'Jaitu', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3202, 'Jalalabad', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3203, 'Jalandhar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3204, 'Jalandhar Cantonment', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3205, 'Jandiala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3206, 'Jugial', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3207, 'Kalanaur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3208, 'Kapurthala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3209, 'Karoran', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3210, 'Kartarpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3211, 'Khamanon', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3212, 'Khanauri', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3213, 'Khanna', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3214, 'Kharar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3215, 'Khem Karan', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3216, 'Kot Fatta', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3217, 'Kot Isa Khan', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3218, 'Kot Kapura', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3219, 'Kotkapura', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3220, 'Kurali', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3221, 'Lalru', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3222, 'Lehra Gaga', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3223, 'Lodhian Khas', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3224, 'Longowal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3225, 'Ludhiana', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3226, 'Machhiwara', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3227, 'Mahilpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3228, 'Majitha', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3229, 'Makhu', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3230, 'Malaut', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3231, 'Malerkotla', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3232, 'Maloud', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3233, 'Mandi Gobindgarh', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3234, 'Mansa', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3235, 'Maur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3236, 'Moga', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3237, 'Mohali', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3238, 'Moonak', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3239, 'Morinda', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3240, 'Mukerian', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3241, 'Muktsar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3242, 'Mullanpur Dakha', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3243, 'Mullanpur Garibdas', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3244, 'Munak', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3245, 'Muradpura', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3246, 'Nabha', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3247, 'Nakodar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3248, 'Nangal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3249, 'Nawashahr', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3250, 'Naya Nangal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3251, 'Nehon', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3252, 'Nurmahal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3253, 'Pathankot', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3254, 'Patiala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3255, 'Patti', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3256, 'Pattran', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3257, 'Payal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3258, 'Phagwara', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3259, 'Phillaur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3260, 'Qadian', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3261, 'Rahon', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3262, 'Raikot', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3263, 'Raja Sansi', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3264, 'Rajpura', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3265, 'Ram Das', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3266, 'Raman', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3267, 'Rampura', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3268, 'Rayya', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3269, 'Rupnagar', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3270, 'Rurki Kasba', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3271, 'Sahnewal', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3272, 'Samana', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3273, 'Samrala', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3274, 'Sanaur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3275, 'Sangat', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3276, 'Sangrur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3277, 'Sansarpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3278, 'Sardulgarh', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3279, 'Shahkot', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3280, 'Sham Churasi', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3281, 'Shekhpura', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3282, 'Sirhind', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3283, 'Sri Hargobindpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3284, 'Sujanpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3285, 'Sultanpur Lodhi', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3286, 'Sunam', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3287, 'Talwandi Bhai', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3288, 'Talwara', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3289, 'Tappa', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3290, 'Tarn Taran', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3291, 'Urmar Tanda', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3292, 'Zira', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3293, 'Zirakpur', 32, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3294, 'Abu Road', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3295, 'Ajmer', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3296, 'Aklera', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3297, 'Alwar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3298, 'Amet', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3299, 'Antah', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3300, 'Anupgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3301, 'Asind', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3302, 'Bagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3303, 'Bagru', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3304, 'Bahror', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3305, 'Bakani', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3306, 'Bali', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3307, 'Balotra', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3308, 'Bandikui', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3309, 'Banswara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3310, 'Baran', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3311, 'Bari', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3312, 'Bari Sadri', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3313, 'Barmer', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3314, 'Basi', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3315, 'Basni Belima', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3316, 'Baswa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3317, 'Bayana', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3318, 'Beawar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3319, 'Begun', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3320, 'Bhadasar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3321, 'Bhadra', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3322, 'Bhalariya', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3323, 'Bharatpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3324, 'Bhasawar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3325, 'Bhawani Mandi', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3326, 'Bhawri', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3327, 'Bhilwara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3328, 'Bhindar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3329, 'Bhinmal', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3330, 'Bhiwadi', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3331, 'Bijoliya Kalan', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3332, 'Bikaner', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3333, 'Bilara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3334, 'Bissau', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3335, 'Borkhera', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3336, 'Budhpura', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3337, 'Bundi', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3338, 'Chatsu', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3339, 'Chechat', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3340, 'Chhabra', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3341, 'Chhapar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3342, 'Chhipa Barod', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3343, 'Chhoti Sadri', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3344, 'Chirawa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3345, 'Chittaurgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3346, 'Chittorgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3347, 'Chomun', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3348, 'Churu', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3349, 'Daosa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3350, 'Dariba', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3351, 'Dausa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3352, 'Deoli', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3353, 'Deshnok', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3354, 'Devgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3355, 'Devli', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3356, 'Dhariawad', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3357, 'Dhaulpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3358, 'Dholpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3359, 'Didwana', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3360, 'Dig', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3361, 'Dungargarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3362, 'Dungarpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3363, 'Falna', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3364, 'Fatehnagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3365, 'Fatehpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3366, 'Gajsinghpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3367, 'Galiakot', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3368, 'Ganganagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3369, 'Gangapur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3370, 'Goredi Chancha', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3371, 'Gothra', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3372, 'Govindgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3373, 'Gulabpura', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3374, 'Hanumangarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3375, 'Hindaun', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3376, 'Indragarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3377, 'Jahazpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3378, 'Jaipur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3379, 'Jaisalmer', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3380, 'Jaiselmer', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3381, 'Jaitaran', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3382, 'Jalore', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3383, 'Jhalawar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3384, 'Jhalrapatan', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3385, 'Jhunjhunun', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3386, 'Jobner', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3387, 'Jodhpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3388, 'Kaithun', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3389, 'Kaman', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3390, 'Kankroli', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3391, 'Kanor', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3392, 'Kapasan', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3393, 'Kaprain', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3394, 'Karanpura', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3395, 'Karauli', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3396, 'Kekri', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3397, 'Keshorai Patan', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3398, 'Kesrisinghpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3399, 'Khairthal', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3400, 'Khandela', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3401, 'Khanpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3402, 'Kherli', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3403, 'Kherliganj', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3404, 'Kherwara Chhaoni', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3405, 'Khetri', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3406, 'Kiranipura', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3407, 'Kishangarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3408, 'Kishangarh Ranwal', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3409, 'Kolvi Rajendrapura', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3410, 'Kot Putli', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3411, 'Kota', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3412, 'Kuchaman', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3413, 'Kuchera', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3414, 'Kumbhalgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3415, 'Kumbhkot', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3416, 'Kumher', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3417, 'Kushalgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3418, 'Lachhmangarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3419, 'Ladnun', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3420, 'Lakheri', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3421, 'Lalsot', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3422, 'Losal', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3423, 'Madanganj', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3424, 'Mahu Kalan', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3425, 'Mahwa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3426, 'Makrana', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3427, 'Malpura', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3428, 'Mandal', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3429, 'Mandalgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3430, 'Mandawar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3431, 'Mandwa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3432, 'Mangrol', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3433, 'Manohar Thana', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3434, 'Manoharpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3435, 'Marwar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3436, 'Merta', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3437, 'Modak', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3438, 'Mount Abu', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3439, 'Mukandgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3440, 'Mundwa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3441, 'Nadbai', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3442, 'Naenwa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3443, 'Nagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3444, 'Nagaur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3445, 'Napasar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3446, 'Naraina', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3447, 'Nasirabad', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3448, 'Nathdwara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3449, 'Nawa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3450, 'Nawalgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3451, 'Neem Ka Thana', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3452, 'Neemrana', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3453, 'Newa Talai', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3454, 'Nimaj', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3455, 'Nimbahera', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3456, 'Niwai', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3457, 'Nohar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3458, 'Nokha', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3459, 'One SGM', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3460, 'Padampur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3461, 'Pali', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3462, 'Partapur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3463, 'Parvatsar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3464, 'Pasoond', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3465, 'Phalna', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3466, 'Phalodi', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3467, 'Phulera', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3468, 'Pilani', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3469, 'Pilibanga', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3470, 'Pindwara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3471, 'Pipalia Kalan', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3472, 'Pipar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3473, 'Pirawa', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3474, 'Pokaran', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3475, 'Pratapgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3476, 'Pushkar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3477, 'Raipur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3478, 'Raisinghnagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3479, 'Rajakhera', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3480, 'Rajaldesar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3481, 'Rajgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3482, 'Rajsamand', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3483, 'Ramganj Mandi', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3484, 'Ramgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3485, 'Rani', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3486, 'Raniwara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3487, 'Ratan Nagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3488, 'Ratangarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3489, 'Rawatbhata', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3490, 'Rawatsar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3491, 'Rikhabdev', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3492, 'Ringas', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3493, 'Sadri', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3494, 'Sadulshahar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3495, 'Sagwara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3496, 'Salumbar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3497, 'Sambhar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3498, 'Samdari', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3499, 'Sanchor', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3500, 'Sangariya', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3501, 'Sangod', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3502, 'Sardarshahr', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3503, 'Sarwar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3504, 'Satal Kheri', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3505, 'Sawai Madhopur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3506, 'Sewan Kalan', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3507, 'Shahpura', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3508, 'Sheoganj', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3509, 'Sikar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3510, 'Sirohi', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3511, 'Siwana', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3512, 'Sogariya', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3513, 'Sojat', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3514, 'Sojat Road', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3515, 'Sri Madhopur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3516, 'Sriganganagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3517, 'Sujangarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3518, 'Suket', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3519, 'Sumerpur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3520, 'Sunel', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3521, 'Surajgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3522, 'Suratgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3523, 'Swaroopganj', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3524, 'Takhatgarh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3525, 'Taranagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3526, 'Three STR', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3527, 'Tijara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3528, 'Toda Bhim', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3529, 'Toda Raisingh', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3530, 'Todra', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3531, 'Tonk', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3532, 'Udaipur', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3533, 'Udpura', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3534, 'Uniara', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3535, 'Vanasthali', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3536, 'Vidyavihar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3537, 'Vijainagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3538, 'Viratnagar', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3539, 'Wer', 33, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3540, 'Gangtok', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3541, 'Gezing', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3542, 'Jorethang', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3543, 'Mangan', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3544, 'Namchi', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3545, 'Naya Bazar', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3546, 'No City', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3547, 'Rangpo', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3548, 'Sikkim', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3549, 'Singtam', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3550, 'Upper Tadong', 34, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3551, 'Abiramam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3552, 'Achampudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3553, 'Acharapakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3554, 'Acharipallam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3555, 'Achipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3556, 'Adikaratti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3557, 'Adiramapattinam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3558, 'Aduturai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3559, 'Adyar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3560, 'Agaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3561, 'Agasthiswaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3562, 'Akkaraipettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3563, 'Alagappapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3564, 'Alagapuri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3565, 'Alampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3566, 'Alandur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3567, 'Alanganallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3568, 'Alangayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3569, 'Alangudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3570, 'Alangulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3571, 'Alanthurai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3572, 'Alapakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3573, 'Allapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3574, 'Alur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3575, 'Alwar Tirunagari', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3576, 'Alwarkurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3577, 'Ambasamudram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3578, 'Ambur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3579, 'Ammainaickanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3580, 'Ammaparikuppam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3581, 'Ammapettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3582, 'Ammavarikuppam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3583, 'Ammur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3584, 'Anaimalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3585, 'Anaiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3586, 'Anakaputhur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3587, 'Ananthapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3588, 'Andanappettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3589, 'Andipalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3590, 'Andippatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3591, 'Anjugramam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3592, 'Annamalainagar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3593, 'Annavasal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3594, 'Annur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3595, 'Anthiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3596, 'Appakudal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3597, 'Arachalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3598, 'Arakandanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3599, 'Arakonam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3600, 'Aralvaimozhi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3601, 'Arani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3602, 'Arani Road', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3603, 'Arantangi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3604, 'Arasiramani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3605, 'Aravakurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3606, 'Aravankadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3607, 'Arcot', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3608, 'Arimalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3609, 'Ariyalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3610, 'Ariyappampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3611, 'Ariyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3612, 'Arni', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3613, 'Arulmigu Thirumuruganpundi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3614, 'Arumanai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3615, 'Arumbavur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3616, 'Arumuganeri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3617, 'Aruppukkottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3618, 'Ashokapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3619, 'Athani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3620, 'Athanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3621, 'Athimarapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3622, 'Athipattu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3623, 'Athur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3624, 'Attayyampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3625, 'Attur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3626, 'Auroville', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3627, 'Avadattur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3628, 'Avadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3629, 'Avalpundurai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3630, 'Avaniapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3631, 'Avinashi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3632, 'Ayakudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3633, 'Ayanadaippu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3634, 'Aygudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3635, 'Ayothiapattinam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3636, 'Ayyalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3637, 'Ayyampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3638, 'Ayyampettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3639, 'Azhagiapandiapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3640, 'Balakrishnampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3641, 'Balakrishnapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3642, 'Balapallam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3643, 'Balasamudram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3644, 'Bargur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3645, 'Belur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3646, 'Berhatty', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3647, 'Bhavani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3648, 'Bhawanisagar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3649, 'Bhuvanagiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3650, 'Bikketti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3651, 'Bodinayakkanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3652, 'Brahmana Periya Agraharam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3653, 'Buthapandi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3654, 'Buthipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3655, 'Chatrapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3656, 'Chembarambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3657, 'Chengalpattu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3658, 'Chengam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3659, 'Chennai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3660, 'Chennasamudram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3661, 'Chennimalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3662, 'Cheranmadevi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3663, 'Cheruvanki', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3664, 'Chetpet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3665, 'Chettiarpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3666, 'Chettipalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3667, 'Chettipalayam Cantonment', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3668, 'Chettithangal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3669, 'Cheyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3670, 'Cheyyar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3671, 'Chidambaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3672, 'Chinalapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3673, 'Chinna Anuppanadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3674, 'Chinna Salem', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3675, 'Chinnakkampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3676, 'Chinnammanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3677, 'Chinnampalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3678, 'Chinnasekkadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3679, 'Chinnavedampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3680, 'Chitlapakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3681, 'Chittodu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3682, 'Cholapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3683, 'Coimbatore', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3684, 'Coonoor', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3685, 'Courtalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3686, 'Cuddalore', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3687, 'Dalavaipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3688, 'Darasuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3689, 'Denkanikottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3690, 'Desur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3691, 'Devadanapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3692, 'Devakkottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3693, 'Devakottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3694, 'Devanangurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3695, 'Devarshola', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3696, 'Devasthanam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3697, 'Dhalavoipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3698, 'Dhali', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3699, 'Dhaliyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3700, 'Dharapadavedu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3701, 'Dharapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3702, 'Dharmapuri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3703, 'Dindigul', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3704, 'Dusi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3705, 'Edaganasalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3706, 'Edaikodu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3707, 'Edakalinadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3708, 'Elathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3709, 'Elayirampannai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3710, 'Elumalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3711, 'Eral', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3712, 'Eraniel', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3713, 'Eriodu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3714, 'Erode', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3715, 'Erumaipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3716, 'Eruvadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3717, 'Ethapur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3718, 'Ettaiyapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3719, 'Ettimadai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3720, 'Ezhudesam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3721, 'Ganapathipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3722, 'Gandhi Nagar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3723, 'Gangaikondan', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3724, 'Gangavalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3725, 'Ganguvarpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3726, 'Gingi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3727, 'Gopalasamudram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3728, 'Gopichettipalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3729, 'Gudalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3730, 'Gudiyattam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3731, 'Guduvanchery', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3732, 'Gummidipoondi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3733, 'Hanumanthampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3734, 'Harur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3735, 'Harveypatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3736, 'Highways', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3737, 'Hosur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3738, 'Hubbathala', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3739, 'Huligal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3740, 'Idappadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3741, 'Idikarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3742, 'Ilampillai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3743, 'Ilanji', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3744, 'Iluppaiyurani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3745, 'Iluppur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3746, 'Inam Karur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3747, 'Injambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3748, 'Irugur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3749, 'Jaffrabad', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3750, 'Jagathala', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3751, 'Jalakandapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3752, 'Jalladiampet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3753, 'Jambai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3754, 'Jayankondam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3755, 'Jolarpet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3756, 'Kadambur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3757, 'Kadathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3758, 'Kadayal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3759, 'Kadayampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3760, 'Kadayanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3761, 'Kadiapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3762, 'Kalakkad', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3763, 'Kalambur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3764, 'Kalapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3765, 'Kalappanaickenpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3766, 'Kalavai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3767, 'Kalinjur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3768, 'Kaliyakkavilai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3769, 'Kallakkurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3770, 'Kallakudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3771, 'Kallidaikurichchi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3772, 'Kallukuttam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3773, 'Kallupatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3774, 'Kalpakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3775, 'Kalugumalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3776, 'Kamayagoundanpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3777, 'Kambainallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3778, 'Kambam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3779, 'Kamuthi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3780, 'Kanadukathan', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3781, 'Kanakkampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3782, 'Kanam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3783, 'Kanchipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3784, 'Kandanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3785, 'Kangayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3786, 'Kangayampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3787, 'Kangeyanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3788, 'Kaniyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3789, 'Kanjikoil', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3790, 'Kannadendal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3791, 'Kannamangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3792, 'Kannampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3793, 'Kannankurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3794, 'Kannapalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3795, 'Kannivadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3796, 'Kanyakumari', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3797, 'Kappiyarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3798, 'Karaikkudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3799, 'Karamadai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3800, 'Karambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3801, 'Karambakkudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3802, 'Kariamangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3803, 'Kariapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3804, 'Karugampattur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3805, 'Karumandi Chellipalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3806, 'Karumathampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3807, 'Karumbakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3808, 'Karungal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3809, 'Karunguzhi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3810, 'Karuppur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3811, 'Karur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3812, 'Kasipalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3813, 'Kasipalayam G', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3814, 'Kathirvedu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3815, 'Kathujuganapalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3816, 'Katpadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3817, 'Kattivakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3818, 'Kattumannarkoil', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3819, 'Kattupakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3820, 'Kattuputhur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3821, 'Kaveripakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3822, 'Kaveripattinam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3823, 'Kavundampalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3824, 'Kavundampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3825, 'Kayalpattinam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3826, 'Kayattar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3827, 'Kelamangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3828, 'Kelambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3829, 'Kembainaickenpalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3830, 'Kethi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3831, 'Kilakarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3832, 'Kilampadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3833, 'Kilkulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3834, 'Kilkunda', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3835, 'Killiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3836, 'Killlai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3837, 'Kilpennathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3838, 'Kilvelur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3839, 'Kinathukadavu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3840, 'Kiramangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3841, 'Kiranur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3842, 'Kiripatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3843, 'Kizhapavur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3844, 'Kmarasamipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3845, 'Kochadai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3846, 'Kodaikanal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3847, 'Kodambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3848, 'Kodavasal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3849, 'Kodumudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3850, 'Kolachal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3851, 'Kolappalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3852, 'Kolathupalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3853, 'Kolathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3854, 'Kollankodu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3855, 'Kollankoil', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3856, 'Komaralingam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3857, 'Komarapalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3858, 'Kombai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3859, 'Konakkarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3860, 'Konavattam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3861, 'Kondalampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3862, 'Konganapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3863, 'Koradacheri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3864, 'Korampallam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3865, 'Kotagiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3866, 'Kothinallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3867, 'Kottaiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3868, 'Kottakuppam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3869, 'Kottaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3870, 'Kottivakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3871, 'Kottur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3872, 'Kovilpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3873, 'Koyampattur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3874, 'Krishnagiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3875, 'Krishnarayapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3876, 'Krishnasamudram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3877, 'Kuchanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3878, 'Kuhalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3879, 'Kulasekarappattinam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3880, 'Kulasekarapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3881, 'Kulithalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3882, 'Kumarapalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3883, 'Kumarapalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3884, 'Kumarapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3885, 'Kumbakonam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3886, 'Kundrathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3887, 'Kuniyamuthur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3888, 'Kunnathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3889, 'Kunur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3890, 'Kuraikundu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3891, 'Kurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3892, 'Kurinjippadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3893, 'Kurudampalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3894, 'Kurumbalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3895, 'Kuthalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3896, 'Kuthappar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3897, 'Kuttalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3898, 'Kuttanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3899, 'Kuzhithurai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3900, 'Labbaikudikadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3901, 'Lakkampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3902, 'Lalgudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3903, 'Lalpet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3904, 'Llayangudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3905, 'Madambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3906, 'Madanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3907, 'Madathukulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3908, 'Madhavaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3909, 'Madippakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3910, 'Madukkarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3911, 'Madukkur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3912, 'Madurai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3913, 'Maduranthakam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3914, 'Maduravoyal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3915, 'Mahabalipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3916, 'Makkinanpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3917, 'Mallamuppampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3918, 'Mallankinaru', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3919, 'Mallapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3920, 'Mallasamudram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3921, 'Mallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3922, 'Mamallapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3923, 'Mamsapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3924, 'Manachanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3925, 'Manali', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3926, 'Manalmedu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3927, 'Manalurpet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3928, 'Manamadurai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3929, 'Manapakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3930, 'Manapparai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3931, 'Manavalakurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3932, 'Mandaikadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3933, 'Mandapam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3934, 'Mangadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3935, 'Mangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3936, 'Mangalampet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3937, 'Manimutharu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3938, 'Mannargudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3939, 'Mappilaiurani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3940, 'Maraimalai Nagar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3941, 'Marakkanam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3942, 'Maramangalathupatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3943, 'Marandahalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3944, 'Markayankottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3945, 'Marudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3946, 'Marungur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3947, 'Masinigudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3948, 'Mathigiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3949, 'Mattur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3950, 'Mayiladuthurai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3951, 'Mecheri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3952, 'Melacheval', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3953, 'Melachokkanathapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3954, 'Melagaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3955, 'Melamadai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3956, 'Melamaiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3957, 'Melanattam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3958, 'Melathiruppanthuruthi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3959, 'Melattur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3960, 'Melmananbedu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3961, 'Melpattampakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3962, 'Melur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3963, 'Melvisharam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3964, 'Mettupalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3965, 'Mettur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3966, 'Meyyanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3967, 'Milavittan', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3968, 'Minakshipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3969, 'Minambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3970, 'Minjur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3971, 'Modakurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3972, 'Mohanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3973, 'Mopperipalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3974, 'Mudalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3975, 'Mudichur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3976, 'Mudukulathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3977, 'Mukasipidariyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3978, 'Mukkudal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3979, 'Mulagumudu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3980, 'Mulakaraipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3981, 'Mulanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3982, 'Mullakkadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3983, 'Muruganpalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3984, 'Musiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3985, 'Muthupet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3986, 'Muthur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3987, 'Muttayyapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3988, 'Muttupet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3989, 'Muvarasampettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3990, 'Myladi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3991, 'Mylapore', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3992, 'Nadukkuthagai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3993, 'Naduvattam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3994, 'Nagapattinam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3995, 'Nagavakulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3996, 'Nagercoil', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3997, 'Nagojanahalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3998, 'Nallampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (3999, 'Nallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4000, 'Namagiripettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4001, 'Namakkal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4002, 'Nambiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4003, 'Nambutalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4004, 'Nandambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4005, 'Nandivaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4006, 'Nangavalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4007, 'Nangavaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4008, 'Nanguneri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4009, 'Nanjikottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4010, 'Nannilam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4011, 'Naranammalpuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4012, 'Naranapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4013, 'Narasimhanaickenpalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4014, 'Narasingapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4015, 'Narasojipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4016, 'Naravarikuppam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4017, 'Nasiyanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4018, 'Natham', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4019, 'Nathampannai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4020, 'Natrampalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4021, 'Nattam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4022, 'Nattapettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4023, 'Nattarasankottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4024, 'Navalpattu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4025, 'Nazarethpettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4026, 'Nazerath', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4027, 'Neikkarapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4028, 'Neiyyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4029, 'Nellikkuppam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4030, 'Nelliyalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4031, 'Nemili', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4032, 'Nemilicheri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4033, 'Neripperichal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4034, 'Nerkunram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4035, 'Nerkuppai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4036, 'Nerunjipettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4037, 'Neykkarappatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4038, 'Neyveli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4039, 'Nidamangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4040, 'Nilagiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4041, 'Nilakkottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4042, 'Nilankarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4043, 'Odaipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4044, 'Odaiyakulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4045, 'Oddanchatram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4046, 'Odugathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4047, 'Oggiyamduraipakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4048, 'Olagadam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4049, 'Omalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4050, 'Ooty', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4051, 'Orathanadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4052, 'Othakadai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4053, 'Othakalmandapam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4054, 'Ottapparai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4055, 'Pacode', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4056, 'Padaividu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4057, 'Padianallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4058, 'Padirikuppam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4059, 'Padmanabhapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4060, 'Padririvedu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4061, 'Palaganangudy', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4062, 'Palaimpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4063, 'Palakkodu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4064, 'Palamedu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4065, 'Palani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4066, 'Palani Chettipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4067, 'Palavakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4068, 'Palavansathu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4069, 'Palayakayal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4070, 'Palayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4071, 'Palayamkottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4072, 'Palladam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4073, 'Pallapalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4074, 'Pallapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4075, 'Pallattur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4076, 'Pallavaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4077, 'Pallikaranai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4078, 'Pallikonda', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4079, 'Pallipalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4080, 'Pallipalaiyam Agraharam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4081, 'Pallipattu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4082, 'Pammal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4083, 'Panagudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4084, 'Panaimarathupatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4085, 'Panapakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4086, 'Panboli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4087, 'Pandamangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4088, 'Pannaikadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4089, 'Pannaipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4090, 'Pannuratti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4091, 'Panruti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4092, 'Papanasam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4093, 'Pappankurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4094, 'Papparapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4095, 'Pappireddipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4096, 'Paramakkudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4097, 'Paramankurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4098, 'Paramathi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4099, 'Parangippettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4100, 'Paravai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4101, 'Pasur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4102, 'Pathamadai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4103, 'Pattinam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4104, 'Pattiviranpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4105, 'Pattukkottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4106, 'Pazhugal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4107, 'Pennadam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4108, 'Pennagaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4109, 'Pennathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4110, 'Peraiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4111, 'Peralam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4112, 'Perambalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4113, 'Peranamallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4114, 'Peravurani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4115, 'Periyakodiveri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4116, 'Periyakulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4117, 'Periyanayakkanpalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4118, 'Periyanegamam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4119, 'Periyapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4120, 'Periyasemur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4121, 'Pernambut', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4122, 'Perumagalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4123, 'Perumandi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4124, 'Perumuchi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4125, 'Perundurai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4126, 'Perungalathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4127, 'Perungudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4128, 'Perungulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4129, 'Perur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4130, 'Perur Chettipalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4131, 'Pethampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4132, 'Pethanaickenpalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4133, 'Pillanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4134, 'Pirkankaranai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4135, 'Polichalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4136, 'Pollachi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4137, 'Polur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4138, 'Ponmani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4139, 'Ponnamaravathi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4140, 'Ponnampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4141, 'Ponneri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4142, 'Porur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4143, 'Pothanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4144, 'Pothatturpettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4145, 'Pudukadai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4146, 'Pudukkottai Cantonment', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4147, 'Pudukottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4148, 'Pudupalaiyam Aghraharam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4149, 'Pudupalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4150, 'Pudupatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4151, 'Pudupattinam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4152, 'Pudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4153, 'Puduvayal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4154, 'Pulambadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4155, 'Pulampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4156, 'Puliyampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4157, 'Puliyankudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4158, 'Puliyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4159, 'Pullampadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4160, 'Puluvapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4161, 'Punamalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4162, 'Punjai Puliyampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4163, 'Punjai Thottakurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4164, 'Punjaipugalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4165, 'Puthalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4166, 'Putteri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4167, 'Puvalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4168, 'Puzhal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4169, 'Puzhithivakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4170, 'Rajapalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4171, 'Ramanathapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4172, 'Ramapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4173, 'Rameswaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4174, 'Ranipet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4175, 'Rasipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4176, 'Rayagiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4177, 'Rithapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4178, 'Rosalpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4179, 'Rudravathi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4180, 'Sadayankuppam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4181, 'Saint Thomas Mount', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4182, 'Salangapalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4183, 'Salem', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4184, 'Samalapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4185, 'Samathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4186, 'Sambavar Vadagarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4187, 'Sankaramanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4188, 'Sankarankoil', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4189, 'Sankarapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4190, 'Sankari', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4191, 'Sankarnagar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4192, 'Saravanampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4193, 'Sarcarsamakulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4194, 'Sathiyavijayanagaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4195, 'Sathuvachari', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4196, 'Sathyamangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4197, 'Sattankulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4198, 'Sattur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4199, 'Sayalgudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4200, 'Sayapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4201, 'Seithur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4202, 'Sembakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4203, 'Semmipalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4204, 'Sennirkuppam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4205, 'Senthamangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4206, 'Sentharapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4207, 'Senur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4208, 'Sethiathoppu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4209, 'Sevilimedu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4210, 'Sevugampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4211, 'Shenbakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4212, 'Shencottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4213, 'Shenkottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4214, 'Sholavandan', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4215, 'Sholinganallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4216, 'Sholingur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4217, 'Sholur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4218, 'Sikkarayapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4219, 'Singampuneri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4220, 'Singanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4221, 'Singaperumalkoil', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4222, 'Sirapalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4223, 'Sirkali', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4224, 'Sirugamani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4225, 'Sirumugai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4226, 'Sithayankottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4227, 'Sithurajapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4228, 'Sivaganga', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4229, 'Sivagiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4230, 'Sivakasi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4231, 'Sivanthipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4232, 'Sivur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4233, 'Soranjeri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4234, 'South Kannanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4235, 'South Kodikulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4236, 'Srimushnam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4237, 'Sriperumpudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4238, 'Sriramapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4239, 'Srirangam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4240, 'Srivaikuntam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4241, 'Srivilliputtur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4242, 'Suchindram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4243, 'Suliswaranpatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4244, 'Sulur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4245, 'Sundarapandiam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4246, 'Sundarapandiapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4247, 'Surampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4248, 'Surandai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4249, 'Suriyampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4250, 'Swamimalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4251, 'TNPL Pugalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4252, 'Tambaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4253, 'Taramangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4254, 'Tattayyangarpettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4255, 'Tayilupatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4256, 'Tenkasi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4257, 'Thadikombu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4258, 'Thakkolam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4259, 'Thalainayar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4260, 'Thalakudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4261, 'Thamaraikulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4262, 'Thammampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4263, 'Thanjavur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4264, 'Thanthoni', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4265, 'Tharangambadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4266, 'Thedavur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4267, 'Thenambakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4268, 'Thengampudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4269, 'Theni', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4270, 'Theni Allinagaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4271, 'Thenkarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4272, 'Thenthamaraikulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4273, 'Thenthiruperai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4274, 'Thesur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4275, 'Thevaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4276, 'Thevur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4277, 'Thiagadurgam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4278, 'Thiagarajar Colony', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4279, 'Thingalnagar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4280, 'Thiruchirapalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4281, 'Thirukarungudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4282, 'Thirukazhukundram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4283, 'Thirumalayampalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4284, 'Thirumazhisai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4285, 'Thirunagar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4286, 'Thirunageswaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4287, 'Thirunindravur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4288, 'Thirunirmalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4289, 'Thiruparankundram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4290, 'Thiruparappu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4291, 'Thiruporur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4292, 'Thiruppanandal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4293, 'Thirupuvanam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4294, 'Thiruthangal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4295, 'Thiruthuraipundi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4296, 'Thiruvaivaru', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4297, 'Thiruvalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4298, 'Thiruvarur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4299, 'Thiruvattaru', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4300, 'Thiruvenkatam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4301, 'Thiruvennainallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4302, 'Thiruvithankodu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4303, 'Thisayanvilai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4304, 'Thittacheri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4305, 'Thondamuthur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4306, 'Thorapadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4307, 'Thottipalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4308, 'Thottiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4309, 'Thudiyalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4310, 'Thuthipattu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4311, 'Thuvakudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4312, 'Timiri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4313, 'Tindivanam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4314, 'Tinnanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4315, 'Tiruchchendur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4316, 'Tiruchengode', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4317, 'Tirukkalukkundram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4318, 'Tirukkattuppalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4319, 'Tirukkoyilur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4320, 'Tirumangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4321, 'Tirumullaivasal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4322, 'Tirumuruganpundi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4323, 'Tirunageswaram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4324, 'Tirunelveli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4325, 'Tirupathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4326, 'Tirupattur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4327, 'Tiruppuvanam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4328, 'Tirupur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4329, 'Tirusulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4330, 'Tiruttani', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4331, 'Tiruvallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4332, 'Tiruvannamalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4333, 'Tiruverambur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4334, 'Tiruverkadu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4335, 'Tiruvethipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4336, 'Tiruvidaimarudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4337, 'Tiruvottiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4338, 'Tittakudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4339, 'Tondi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4340, 'Turaiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4341, 'Tuticorin', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4342, 'Udagamandalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4343, 'Udagamandalam Valley', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4344, 'Udankudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4345, 'Udayarpalayam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4346, 'Udumalaipettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4347, 'Udumalpet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4348, 'Ullur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4349, 'Ulundurpettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4350, 'Unjalaur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4351, 'Unnamalaikadai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4352, 'Uppidamangalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4353, 'Uppiliapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4354, 'Urachikkottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4355, 'Urapakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4356, 'Usilampatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4357, 'Uthangarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4358, 'Uthayendram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4359, 'Uthiramerur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4360, 'Uthukkottai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4361, 'Uttamapalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4362, 'Uttukkuli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4363, 'Vadakarai Kizhpadugai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4364, 'Vadakkanandal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4365, 'Vadakku Valliyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4366, 'Vadalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4367, 'Vadamadurai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4368, 'Vadavalli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4369, 'Vadipatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4370, 'Vadugapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4371, 'Vaithiswarankoil', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4372, 'Valangaiman', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4373, 'Valasaravakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4374, 'Valavanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4375, 'Vallam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4376, 'Valparai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4377, 'Valvaithankoshtam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4378, 'Vanavasi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4379, 'Vandalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4380, 'Vandavasi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4381, 'Vandiyur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4382, 'Vaniputhur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4383, 'Vaniyambadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4384, 'Varadarajanpettai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4385, 'Varadharajapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4386, 'Vasudevanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4387, 'Vathirairuppu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4388, 'Vattalkundu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4389, 'Vazhapadi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4390, 'Vedapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4391, 'Vedaranniyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4392, 'Vedasandur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4393, 'Velampalaiyam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4394, 'Velankanni', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4395, 'Vellakinar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4396, 'Vellakoil', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4397, 'Vellalapatti', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4398, 'Vellalur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4399, 'Vellanur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4400, 'Vellimalai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4401, 'Vellore', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4402, 'Vellottamparappu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4403, 'Velluru', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4404, 'Vengampudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4405, 'Vengathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4406, 'Vengavasal', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4407, 'Venghatur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4408, 'Venkarai', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4409, 'Vennanthur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4410, 'Veppathur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4411, 'Verkilambi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4412, 'Vettaikaranpudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4413, 'Vettavalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4414, 'Vijayapuri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4415, 'Vikramasingapuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4416, 'Vikravandi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4417, 'Vilangudi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4418, 'Vilankurichi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4419, 'Vilapakkam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4420, 'Vilathikulam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4421, 'Vilavur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4422, 'Villukuri', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4423, 'Villupuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4424, 'Viraganur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4425, 'Virakeralam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4426, 'Virakkalpudur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4427, 'Virapandi', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4428, 'Virapandi Cantonment', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4429, 'Virappanchatram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4430, 'Viravanallur', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4431, 'Virudambattu', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4432, 'Virudhachalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4433, 'Virudhunagar', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4434, 'Virupakshipuram', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4435, 'Viswanatham', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4436, 'Vriddhachalam', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4437, 'Walajabad', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4438, 'Walajapet', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4439, 'Wellington', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4440, 'Yercaud', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4441, 'Zamin Uthukuli', 35, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4442, 'Achampet', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4443, 'Adilabad', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4444, 'Armoor', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4445, 'Asifabad', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4446, 'Badepally', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4447, 'Banswada', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4448, 'Bellampalli', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4449, 'Bhadrachalam', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4450, 'Bhainsa', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4451, 'Bhongir', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4452, 'Bhupalpally', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4453, 'Bodhan', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4454, 'Bollaram', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4455, 'Devarkonda', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4456, 'Farooqnagar', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4457, 'Gadwal', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4458, 'Gajwel', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4459, 'Ghatkesar', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4460, 'Hyderabad', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4461, 'Jagtial', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4462, 'Jangaon', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4463, 'Kagaznagar', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4464, 'Kalwakurthy', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4465, 'Kamareddy', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4466, 'Karimnagar', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4467, 'Khammam', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4468, 'Kodada', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4469, 'Koratla', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4470, 'Kottagudem', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4471, 'Kyathampalle', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4472, 'Madhira', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4473, 'Mahabubabad', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4474, 'Mahbubnagar', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4475, 'Mancherial', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4476, 'Mandamarri', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4477, 'Manuguru', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4478, 'Medak', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4479, 'Medchal', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4480, 'Miryalaguda', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4481, 'Nagar Karnul', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4482, 'Nakrekal', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4483, 'Nalgonda', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4484, 'Narayanpet', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4485, 'Narsampet', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4486, 'Nirmal', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4487, 'Nizamabad', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4488, 'Palwancha', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4489, 'Peddapalli', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4490, 'Ramagundam', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4491, 'Ranga Reddy district', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4492, 'Sadasivpet', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4493, 'Sangareddy', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4494, 'Sarapaka', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4495, 'Sathupalle', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4496, 'Secunderabad', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4497, 'Siddipet', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4498, 'Singapur', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4499, 'Sircilla', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4500, 'Suryapet', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4501, 'Tandur', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4502, 'Vemulawada', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4503, 'Vikarabad', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4504, 'Wanaparthy', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4505, 'Warangal', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4506, 'Yellandu', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4507, 'Zahirabad', 36, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4508, 'Agartala', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4509, 'Amarpur', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4510, 'Ambassa', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4511, 'Badharghat', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4512, 'Belonia', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4513, 'Dharmanagar', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4514, 'Gakulnagar', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4515, 'Gandhigram', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4516, 'Indranagar', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4517, 'Jogendranagar', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4518, 'Kailasahar', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4519, 'Kamalpur', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4520, 'Kanchanpur', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4521, 'Khowai', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4522, 'Kumarghat', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4523, 'Kunjaban', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4524, 'Narsingarh', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4525, 'Pratapgarh', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4526, 'Ranir Bazar', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4527, 'Sabrum', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4528, 'Sonamura', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4529, 'Teliamura', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4530, 'Udaipur', 37, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4531, 'Achhalda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4532, 'Achhnera', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4533, 'Adari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4534, 'Afzalgarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4535, 'Agarwal Mandi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4536, 'Agra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4537, 'Agra Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4538, 'Ahraura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4539, 'Ailum', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4540, 'Air Force Area', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4541, 'Ajhuwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4542, 'Akbarpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4543, 'Alapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4544, 'Aliganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4545, 'Aligarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4546, 'Allahabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4547, 'Allahabad Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4548, 'Allahganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4549, 'Amanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4550, 'Ambahta', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4551, 'Amethi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4552, 'Amila', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4553, 'Amilo', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4554, 'Aminagar Sarai', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4555, 'Aminagar Urf Bhurbaral', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4556, 'Amraudha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4557, 'Amroha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4558, 'Anandnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4559, 'Anpara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4560, 'Antu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4561, 'Anupshahr', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4562, 'Aonla', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4563, 'Armapur Estate', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4564, 'Ashokpuram', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4565, 'Ashrafpur Kichhauchha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4566, 'Atarra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4567, 'Atasu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4568, 'Atrauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4569, 'Atraulia', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4570, 'Auraiya', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4571, 'Aurangabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4572, 'Aurangabad Bangar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4573, 'Auras', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4574, 'Awagarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4575, 'Ayodhya', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4576, 'Azamgarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4577, 'Azizpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4578, 'Azmatgarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4579, 'Babarpur Ajitmal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4580, 'Baberu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4581, 'Babina', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4582, 'Babrala', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4583, 'Babugarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4584, 'Bachhiowan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4585, 'Bachhraon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4586, 'Bad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4587, 'Badaun', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4588, 'Baghpat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4589, 'Bah', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4590, 'Bahadurganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4591, 'Baheri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4592, 'Bahjoi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4593, 'Bahraich', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4594, 'Bahsuma', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4595, 'Bahua', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4596, 'Bajna', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4597, 'Bakewar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4598, 'Bakiabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4599, 'Baldeo', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4600, 'Ballia', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4601, 'Balrampur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4602, 'Banat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4603, 'Banda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4604, 'Bangarmau', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4605, 'Banki', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4606, 'Bansdih', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4607, 'Bansgaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4608, 'Bansi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4609, 'Barabanki', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4610, 'Baragaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4611, 'Baraut', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4612, 'Bareilly', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4613, 'Bareilly Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4614, 'Barhalganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4615, 'Barhani', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4616, 'Barhapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4617, 'Barkhera', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4618, 'Barsana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4619, 'Barva Sagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4620, 'Barwar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4621, 'Basti', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4622, 'Begumabad Budhana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4623, 'Behat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4624, 'Behta Hajipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4625, 'Bela', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4626, 'Belthara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4627, 'Beniganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4628, 'Beswan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4629, 'Bewar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4630, 'Bhadarsa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4631, 'Bhadohi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4632, 'Bhagwantnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4633, 'Bharatganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4634, 'Bhargain', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4635, 'Bharthana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4636, 'Bharuhana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4637, 'Bharwari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4638, 'Bhatni Bazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4639, 'Bhatpar Rani', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4640, 'Bhawan Bahadurnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4641, 'Bhinga', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4642, 'Bhojpur Dharampur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4643, 'Bhokarhedi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4644, 'Bhongaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4645, 'Bhulepur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4646, 'Bidhuna', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4647, 'Bighapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4648, 'Bijnor', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4649, 'Bijpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4650, 'Bikapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4651, 'Bilari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4652, 'Bilaspur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4653, 'Bilgram', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4654, 'Bilhaur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4655, 'Bilram', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4656, 'Bilrayaganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4657, 'Bilsanda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4658, 'Bilsi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4659, 'Bindki', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4660, 'Bisalpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4661, 'Bisanda Buzurg', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4662, 'Bisauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4663, 'Bisharatganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4664, 'Bisokhar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4665, 'Biswan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4666, 'Bithur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4667, 'Budaun', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4668, 'Bugrasi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4669, 'Bulandshahar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4670, 'Burhana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4671, 'Chail', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4672, 'Chak Imam Ali', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4673, 'Chakeri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4674, 'Chakia', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4675, 'Chandauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4676, 'Chandausi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4677, 'Chandpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4678, 'Charkhari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4679, 'Charthawal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4680, 'Chaumuhan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4681, 'Chhaprauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4682, 'Chhara Rafatpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4683, 'Chharprauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4684, 'Chhata', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4685, 'Chhatari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4686, 'Chhibramau', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4687, 'Chhutmalpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4688, 'Chilkana Sultanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4689, 'Chirgaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4690, 'Chit Baragaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4691, 'Chitrakut Dham', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4692, 'Chopan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4693, 'Choubepur Kalan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4694, 'Chunar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4695, 'Churk Ghurma', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4696, 'Colonelganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4697, 'Dadri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4698, 'Dalmau', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4699, 'Dankaur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4700, 'Dariyabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4701, 'Dasna', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4702, 'Dataganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4703, 'Daurala', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4704, 'Dayal Bagh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4705, 'Deoband', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4706, 'Deoranian', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4707, 'Deoria', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4708, 'Dewa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4709, 'Dhampur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4710, 'Dhanauha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4711, 'Dhanauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4712, 'Dhanaura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4713, 'Dharoti Khurd', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4714, 'Dhauratanda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4715, 'Dhaurhra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4716, 'Dibai', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4717, 'Dibiyapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4718, 'Dildarnagar Fatehpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4719, 'Do Ghat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4720, 'Dohrighat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4721, 'Dostpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4722, 'Dudhinagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4723, 'Dulhipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4724, 'Dundwaraganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4725, 'Ekdil', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4726, 'Erich', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4727, 'Etah', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4728, 'Etawah', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4729, 'Faizabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4730, 'Faizabad Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4731, 'Faizganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4732, 'Farah', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4733, 'Faridnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4734, 'Faridpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4735, 'Faridpur Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4736, 'Fariha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4737, 'Farrukhabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4738, 'Fatehabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4739, 'Fatehganj Pashchimi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4740, 'Fatehganj Purvi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4741, 'Fatehgarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4742, 'Fatehpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4743, 'Fatehpur Chaurasi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4744, 'Fatehpur Sikri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4745, 'Firozabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4746, 'Gajraula', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4747, 'Ganga Ghat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4748, 'Gangapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4749, 'Gangoh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4750, 'Ganj Muradabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4751, 'Garautha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4752, 'Garhi Pukhta', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4753, 'Garhmukteshwar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4754, 'Gaura Barahaj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4755, 'Gauri Bazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4756, 'Gausganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4757, 'Gawan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4758, 'Ghatampur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4759, 'Ghaziabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4760, 'Ghazipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4761, 'Ghiror', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4762, 'Ghorawal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4763, 'Ghosi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4764, 'Ghosia Bazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4765, 'Ghughuli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4766, 'Gohand', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4767, 'Gokul', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4768, 'Gola Bazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4769, 'Gola Gokarannath', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4770, 'Gonda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4771, 'Gopamau', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4772, 'Gopiganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4773, 'Gorakhpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4774, 'Gosainganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4775, 'Govardhan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4776, 'Greater Noida', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4777, 'Gulaothi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4778, 'Gulariya', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4779, 'Gulariya Bhindara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4780, 'Gunnaur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4781, 'Gursahaiganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4782, 'Gursarai', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4783, 'Gyanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4784, 'Hafizpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4785, 'Haidergarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4786, 'Haldaur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4787, 'Hamirpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4788, 'Handia', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4789, 'Hapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4790, 'Hardoi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4791, 'Harduaganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4792, 'Hargaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4793, 'Hariharpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4794, 'Harraiya', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4795, 'Hasanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4796, 'Hasayan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4797, 'Hastinapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4798, 'Hata', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4799, 'Hathras', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4800, 'Hyderabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4801, 'Ibrahimpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4802, 'Iglas', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4803, 'Ikauna', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4804, 'Iltifatganj Bazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4805, 'Indian Telephone Industry Mank', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4806, 'Islamnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4807, 'Itaunja', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4808, 'Itimadpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4809, 'Jagner', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4810, 'Jahanabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4811, 'Jahangirabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4812, 'Jahangirpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4813, 'Jais', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4814, 'Jaithara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4815, 'Jalalabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4816, 'Jalali', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4817, 'Jalalpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4818, 'Jalaun', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4819, 'Jalesar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4820, 'Jamshila', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4821, 'Jangipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4822, 'Jansath', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4823, 'Jarwal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4824, 'Jasrana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4825, 'Jaswantnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4826, 'Jatari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4827, 'Jaunpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4828, 'Jewar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4829, 'Jhalu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4830, 'Jhansi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4831, 'Jhansi Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4832, 'Jhansi Railway Settlement', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4833, 'Jhinjhak', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4834, 'Jhinjhana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4835, 'Jhusi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4836, 'Jhusi Kohna', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4837, 'Jiyanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4838, 'Joya', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4839, 'Jyoti Khuria', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4840, 'Jyotiba Phule Nagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4841, 'Kabrai', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4842, 'Kachhauna Patseni', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4843, 'Kachhla', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4844, 'Kachhwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4845, 'Kadaura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4846, 'Kadipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4847, 'Kailashpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4848, 'Kaimganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4849, 'Kairana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4850, 'Kakgaina', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4851, 'Kakod', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4852, 'Kakori', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4853, 'Kakrala', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4854, 'Kalinagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4855, 'Kalpi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4856, 'Kamalganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4857, 'Kampil', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4858, 'Kandhla', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4859, 'Kandwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4860, 'Kannauj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4861, 'Kanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4862, 'Kant', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4863, 'Kanth', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4864, 'Kaptanganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4865, 'Karaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4866, 'Karari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4867, 'Karhal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4868, 'Karnawal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4869, 'Kasganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4870, 'Katariya', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4871, 'Katghar Lalganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4872, 'Kathera', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4873, 'Katra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4874, 'Katra Medniganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4875, 'Kauriaganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4876, 'Kemri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4877, 'Kerakat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4878, 'Khadda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4879, 'Khaga', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4880, 'Khailar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4881, 'Khair', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4882, 'Khairabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4883, 'Khairagarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4884, 'Khalilabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4885, 'Khamaria', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4886, 'Khanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4887, 'Kharela', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4888, 'Khargupur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4889, 'Khariya', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4890, 'Kharkhoda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4891, 'Khatauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4892, 'Khatauli Rural', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4893, 'Khekra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4894, 'Kheri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4895, 'Kheta Sarai', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4896, 'Khudaganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4897, 'Khurja', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4898, 'Khutar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4899, 'Kiraoli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4900, 'Kiratpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4901, 'Kishanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4902, 'Kishni', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4903, 'Kithaur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4904, 'Koiripur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4905, 'Konch', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4906, 'Kopaganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4907, 'Kora Jahanabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4908, 'Korwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4909, 'Kosi Kalan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4910, 'Kota', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4911, 'Kotra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4912, 'Kotwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4913, 'Kulpahar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4914, 'Kunda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4915, 'Kundarki', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4916, 'Kunwargaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4917, 'Kurara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4918, 'Kurawali', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4919, 'Kursath', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4920, 'Kurthi Jafarpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4921, 'Kushinagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4922, 'Kusmara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4923, 'Laharpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4924, 'Lakhimpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4925, 'Lakhna', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4926, 'Lalganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4927, 'Lalitpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4928, 'Lar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4929, 'Lawar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4930, 'Ledwa Mahuwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4931, 'Lohta', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4932, 'Loni', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4933, 'Lucknow', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4934, 'Machhlishahr', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4935, 'Madhoganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4936, 'Madhogarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4937, 'Maghar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4938, 'Mahaban', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4939, 'Maharajganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4940, 'Mahmudabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4941, 'Mahoba', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4942, 'Maholi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4943, 'Mahona', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4944, 'Mahroni', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4945, 'Mailani', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4946, 'Mainpuri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4947, 'Majhara Pipar Ehatmali', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4948, 'Majhauli Raj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4949, 'Malihabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4950, 'Mallanwam', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4951, 'Mandawar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4952, 'Manikpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4953, 'Maniyar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4954, 'Manjhanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4955, 'Mankapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4956, 'Marehra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4957, 'Mariahu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4958, 'Maruadih', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4959, 'Maswasi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4960, 'Mataundh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4961, 'Mathu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4962, 'Mathura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4963, 'Mathura Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4964, 'Mau', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4965, 'Mau Aima', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4966, 'Maudaha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4967, 'Mauranipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4968, 'Maurawan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4969, 'Mawana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4970, 'Meerut', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4971, 'Mehnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4972, 'Mehndawal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4973, 'Mendu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4974, 'Milak', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4975, 'Miranpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4976, 'Mirat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4977, 'Mirat Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4978, 'Mirganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4979, 'Mirzapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4980, 'Misrikh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4981, 'Modinagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4982, 'Mogra Badshahpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4983, 'Mohan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4984, 'Mohanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4985, 'Mohiuddinpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4986, 'Moradabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4987, 'Moth', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4988, 'Mubarakpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4989, 'Mughal Sarai', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4990, 'Mughal Sarai Railway Settlemen', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4991, 'Muhammadabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4992, 'Muhammadi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4993, 'Mukrampur Khema', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4994, 'Mundia', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4995, 'Mundora', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4996, 'Muradnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4997, 'Mursan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4998, 'Musafirkhana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (4999, 'Muzaffarnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5000, 'Nadigaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5001, 'Nagina', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5002, 'Nagram', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5003, 'Nai Bazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5004, 'Nainana Jat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5005, 'Najibabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5006, 'Nakur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5007, 'Nanaunta', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5008, 'Nandgaon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5009, 'Nanpara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5010, 'Naraini', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5011, 'Narauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5012, 'Naraura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5013, 'Naugawan Sadat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5014, 'Nautanwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5015, 'Nawabganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5016, 'Nichlaul', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5017, 'Nidhauli Kalan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5018, 'Nihtaur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5019, 'Nindaura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5020, 'Niwari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5021, 'Nizamabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5022, 'Noida', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5023, 'Northern Railway Colony', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5024, 'Nurpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5025, 'Nyoria Husenpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5026, 'Nyotini', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5027, 'Obra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5028, 'Oel Dhakwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5029, 'Orai', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5030, 'Oran', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5031, 'Ordinance Factory Muradnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5032, 'Pachperwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5033, 'Padrauna', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5034, 'Pahasu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5035, 'Paintepur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5036, 'Pali', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5037, 'Palia Kalan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5038, 'Parasi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5039, 'Parichha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5040, 'Parichhatgarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5041, 'Parsadepur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5042, 'Patala', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5043, 'Patiyali', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5044, 'Patti', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5045, 'Pawayan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5046, 'Phalauda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5047, 'Phaphund', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5048, 'Phulpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5049, 'Phulwaria', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5050, 'Pihani', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5051, 'Pilibhit', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5052, 'Pilkana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5053, 'Pilkhuwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5054, 'Pinahat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5055, 'Pipalsana Chaudhari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5056, 'Pipiganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5057, 'Pipraich', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5058, 'Pipri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5059, 'Pratapgarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5060, 'Pukhrayan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5061, 'Puranpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5062, 'Purdil Nagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5063, 'Purqazi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5064, 'Purwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5065, 'Qasimpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5066, 'Rabupura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5067, 'Radha Kund', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5068, 'Rae Bareilly', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5069, 'Raja Ka Rampur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5070, 'Rajapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5071, 'Ramkola', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5072, 'Ramnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5073, 'Rampur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5074, 'Rampur Bhawanipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5075, 'Rampur Karkhana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5076, 'Rampur Maniharan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5077, 'Rampura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5078, 'Ranipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5079, 'Rashidpur Garhi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5080, 'Rasra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5081, 'Rasulabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5082, 'Rath', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5083, 'Raya', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5084, 'Renukut', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5085, 'Reoti', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5086, 'Richha', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5087, 'Risia Bazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5088, 'Rithora', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5089, 'Robertsganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5090, 'Roza', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5091, 'Rudarpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5092, 'Rudauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5093, 'Rudayan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5094, 'Rura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5095, 'Rustamnagar Sahaspur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5096, 'Sabatwar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5097, 'Sadabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5098, 'Sadat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5099, 'Safipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5100, 'Sahanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5101, 'Saharanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5102, 'Sahaspur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5103, 'Sahaswan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5104, 'Sahawar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5105, 'Sahibabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5106, 'Sahjanwa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5107, 'Sahpau', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5108, 'Saidpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5109, 'Sainthal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5110, 'Saiyadraja', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5111, 'Sakhanu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5112, 'Sakit', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5113, 'Salarpur Khadar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5114, 'Salimpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5115, 'Salon', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5116, 'Sambhal', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5117, 'Sambhawali', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5118, 'Samdhan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5119, 'Samthar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5120, 'Sandi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5121, 'Sandila', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5122, 'Sarai Mir', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5123, 'Sarai akil', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5124, 'Sarauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5125, 'Sardhana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5126, 'Sarila', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5127, 'Sarsawan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5128, 'Sasni', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5129, 'Satrikh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5130, 'Saunkh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5131, 'Saurikh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5132, 'Seohara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5133, 'Sewal Khas', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5134, 'Sewarhi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5135, 'Shahabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5136, 'Shahganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5137, 'Shahi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5138, 'Shahjahanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5139, 'Shahjahanpur Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5140, 'Shahpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5141, 'Shamli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5142, 'Shamsabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5143, 'Shankargarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5144, 'Shergarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5145, 'Sherkot', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5146, 'Shikarpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5147, 'Shikohabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5148, 'Shisgarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5149, 'Shivdaspur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5150, 'Shivli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5151, 'Shivrajpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5152, 'Shohratgarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5153, 'Siddhanur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5154, 'Siddharthnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5155, 'Sidhauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5156, 'Sidhpura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5157, 'Sikandarabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5158, 'Sikandarpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5159, 'Sikandra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5160, 'Sikandra Rao', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5161, 'Singahi Bhiraura', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5162, 'Sirathu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5163, 'Sirsa', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5164, 'Sirsaganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5165, 'Sirsi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5166, 'Sisauli', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5167, 'Siswa Bazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5168, 'Sitapur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5169, 'Siyana', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5170, 'Som', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5171, 'Sonbhadra', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5172, 'Soron', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5173, 'Suar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5174, 'Sukhmalpur Nizamabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5175, 'Sultanpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5176, 'Sumerpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5177, 'Suriyawan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5178, 'Swamibagh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5179, 'Tajpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5180, 'Talbahat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5181, 'Talgram', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5182, 'Tambaur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5183, 'Tanda', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5184, 'Tatarpur Lallu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5185, 'Tetribazar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5186, 'Thakurdwara', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5187, 'Thana Bhawan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5188, 'Thiriya Nizamat Khan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5189, 'Tikaitnagar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5190, 'Tikri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5191, 'Tilhar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5192, 'Tindwari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5193, 'Tirwaganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5194, 'Titron', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5195, 'Tori Fatehpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5196, 'Tulsipur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5197, 'Tundla', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5198, 'Tundla Kham', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5199, 'Tundla Railway Colony', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5200, 'Ugu', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5201, 'Ujhani', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5202, 'Ujhari', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5203, 'Umri', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5204, 'Umri Kalan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5205, 'Un', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5206, 'Unchahar', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5207, 'Unnao', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5208, 'Usaihat', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5209, 'Usawan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5210, 'Utraula', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5211, 'Varanasi', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5212, 'Varanasi Cantonment', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5213, 'Vijaigarh', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5214, 'Vrindavan', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5215, 'Wazirganj', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5216, 'Zafarabad', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5217, 'Zaidpur', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5218, 'Zamania', 38, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5219, 'Almora', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5220, 'Almora Cantonment', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5221, 'Badrinathpuri', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5222, 'Bageshwar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5223, 'Bah Bazar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5224, 'Banbasa', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5225, 'Bandia', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5226, 'Barkot', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5227, 'Bazpur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5228, 'Bhim Tal', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5229, 'Bhowali', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5230, 'Chakrata', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5231, 'Chamba', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5232, 'Chamoli and Gopeshwar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5233, 'Champawat', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5234, 'Clement Town', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5235, 'Dehra Dun Cantonment', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5236, 'Dehradun', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5237, 'Dehrakhas', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5238, 'Devaprayag', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5239, 'Dhaluwala', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5240, 'Dhandera', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5241, 'Dharchula', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5242, 'Dharchula Dehat', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5243, 'Didihat', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5244, 'Dineshpur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5245, 'Doiwala', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5246, 'Dugadda', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5247, 'Dwarahat', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5248, 'Gadarpur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5249, 'Gangotri', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5250, 'Gauchar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5251, 'Haldwani', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5252, 'Haridwar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5253, 'Herbertpur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5254, 'Jaspur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5255, 'Jhabrera', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5256, 'Joshimath', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5257, 'Kachnal Gosain', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5258, 'Kaladungi', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5259, 'Kalagarh', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5260, 'Karnaprayang', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5261, 'Kashipur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5262, 'Kashirampur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5263, 'Kausani', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5264, 'Kedarnath', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5265, 'Kelakhera', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5266, 'Khatima', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5267, 'Kichha', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5268, 'Kirtinagar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5269, 'Kotdwara', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5270, 'Laksar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5271, 'Lalkuan', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5272, 'Landaura', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5273, 'Landhaura Cantonment', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5274, 'Lensdaun', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5275, 'Logahat', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5276, 'Mahua Dabra Haripura', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5277, 'Mahua Kheraganj', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5278, 'Manglaur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5279, 'Masuri', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5280, 'Mohanpur Mohammadpur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5281, 'Muni Ki Reti', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5282, 'Nagla', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5283, 'Nainital', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5284, 'Nainital Cantonment', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5285, 'Nandaprayang', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5286, 'Narendranagar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5287, 'Pauri', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5288, 'Pithoragarh', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5289, 'Pratitnagar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5290, 'Raipur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5291, 'Raiwala', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5292, 'Ramnagar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5293, 'Ranikhet', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5294, 'Ranipur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5295, 'Rishikesh', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5296, 'Rishikesh Cantonment', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5297, 'Roorkee', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5298, 'Rudraprayag', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5299, 'Rudrapur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5300, 'Rurki', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5301, 'Rurki Cantonment', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5302, 'Shaktigarh', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5303, 'Sitarganj', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5304, 'Srinagar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5305, 'Sultanpur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5306, 'Tanakpur', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5307, 'Tehri', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5308, 'Udham Singh Nagar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5309, 'Uttarkashi', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5310, 'Vikasnagar', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5311, 'Virbhadra', 39, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5312, '24 Parganas (n)', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5313, '24 Parganas (s)', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5314, 'Adra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5315, 'Ahmadpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5316, 'Aiho', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5317, 'Aistala', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5318, 'Alipur Duar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5319, 'Alipur Duar Railway Junction', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5320, 'Alpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5321, 'Amalhara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5322, 'Amkula', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5323, 'Amlagora', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5324, 'Amodghata', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5325, 'Amtala', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5326, 'Andul', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5327, 'Anksa', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5328, 'Ankurhati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5329, 'Anup Nagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5330, 'Arambagh', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5331, 'Argari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5332, 'Arsha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5333, 'Asansol', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5334, 'Ashoknagar Kalyangarh', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5335, 'Aurangabad', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5336, 'Bablari Dewanganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5337, 'Badhagachhi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5338, 'Baduria', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5339, 'Baghdogra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5340, 'Bagnan', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5341, 'Bagra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5342, 'Bagula', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5343, 'Baharampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5344, 'Bahirgram', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5345, 'Bahula', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5346, 'Baidyabati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5347, 'Bairatisal', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5348, 'Baj Baj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5349, 'Bakreswar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5350, 'Balaram Pota', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5351, 'Balarampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5352, 'Bali Chak', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5353, 'Ballavpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5354, 'Bally', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5355, 'Balurghat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5356, 'Bamunari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5357, 'Banarhat Tea Garden', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5358, 'Bandel', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5359, 'Bangaon', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5360, 'Bankra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5361, 'Bankura', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5362, 'Bansbaria', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5363, 'Banshra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5364, 'Banupur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5365, 'Bara Bamonia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5366, 'Barakpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5367, 'Barakpur Cantonment', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5368, 'Baranagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5369, 'Barasat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5370, 'Barddhaman', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5371, 'Barijhati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5372, 'Barjora', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5373, 'Barrackpore', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5374, 'Baruihuda', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5375, 'Baruipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5376, 'Barunda', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5377, 'Basirhat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5378, 'Baska', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5379, 'Begampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5380, 'Beldanga', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5381, 'Beldubi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5382, 'Belebathan', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5383, 'Beliator', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5384, 'Bhadreswar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5385, 'Bhandardaha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5386, 'Bhangar Raghunathpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5387, 'Bhangri Pratham Khanda', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5388, 'Bhanowara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5389, 'Bhatpara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5390, 'Bholar Dabri', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5391, 'Bidhannagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5392, 'Bidyadharpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5393, 'Biki Hakola', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5394, 'Bilandapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5395, 'Bilpahari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5396, 'Bipra Noapara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5397, 'Birlapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5398, 'Birnagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5399, 'Bisarpara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5400, 'Bishnupur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5401, 'Bolpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5402, 'Bongaon', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5403, 'Bowali', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5404, 'Burdwan', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5405, 'Canning', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5406, 'Cart Road', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5407, 'Chachanda', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5408, 'Chak Bankola', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5409, 'Chak Enayetnagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5410, 'Chak Kashipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5411, 'Chakalampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5412, 'Chakbansberia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5413, 'Chakdaha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5414, 'Chakpara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5415, 'Champahati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5416, 'Champdani', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5417, 'Chamrail', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5418, 'Chandannagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5419, 'Chandpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5420, 'Chandrakona', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5421, 'Chapari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5422, 'Chapui', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5423, 'Char Brahmanagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5424, 'Char Maijdia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5425, 'Charka', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5426, 'Chata Kalikapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5427, 'Chauhati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5428, 'Checha Khata', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5429, 'Chelad', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5430, 'Chhora', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5431, 'Chikrand', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5432, 'Chittaranjan', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5433, 'Contai', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5434, 'Cooch Behar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5435, 'Dainhat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5436, 'Dakshin Baguan', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5437, 'Dakshin Jhapardaha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5438, 'Dakshin Rajyadharpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5439, 'Dakshin Raypur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5440, 'Dalkola', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5441, 'Dalurband', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5442, 'Darap Pur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5443, 'Darjiling', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5444, 'Daulatpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5445, 'Debipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5446, 'Defahat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5447, 'Deora', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5448, 'Deulia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5449, 'Dhakuria', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5450, 'Dhandadihi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5451, 'Dhanyakuria', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5452, 'Dharmapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5453, 'Dhatri Gram', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5454, 'Dhuilya', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5455, 'Dhulagari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5456, 'Dhulian', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5457, 'Dhupgari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5458, 'Dhusaripara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5459, 'Diamond Harbour', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5460, 'Digha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5461, 'Dignala', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5462, 'Dinhata', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5463, 'Dubrajpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5464, 'Dumjor', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5465, 'Durgapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5466, 'Durllabhganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5467, 'Egra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5468, 'Eksara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5469, 'Falakata', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5470, 'Farakka', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5471, 'Fatellapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5472, 'Fort Gloster', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5473, 'Gabberia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5474, 'Gadigachha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5475, 'Gairkata', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5476, 'Gangarampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5477, 'Garalgachha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5478, 'Garbeta Amlagora', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5479, 'Garhbeta', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5480, 'Garshyamnagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5481, 'Garui', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5482, 'Garulia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5483, 'Gayespur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5484, 'Ghatal', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5485, 'Ghorsala', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5486, 'Goaljan', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5487, 'Goasafat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5488, 'Gobardanga', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5489, 'Gobindapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5490, 'Gopalpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5491, 'Gopinathpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5492, 'Gora Bazar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5493, 'Guma', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5494, 'Gurdaha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5495, 'Guriahati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5496, 'Guskhara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5497, 'Habra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5498, 'Haldia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5499, 'Haldibari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5500, 'Halisahar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5501, 'Haora', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5502, 'Harharia Chak', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5503, 'Harindanga', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5504, 'Haringhata', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5505, 'Haripur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5506, 'Harishpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5507, 'Hatgachha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5508, 'Hatsimla', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5509, 'Hijuli', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5510, 'Hindustan Cables Town', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5511, 'Hooghly', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5512, 'Howrah', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5513, 'Hugli-Chunchura', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5514, 'Humaipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5515, 'Ichha Pur Defence Estate', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5516, 'Ingraj Bazar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5517, 'Islampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5518, 'Jafarpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5519, 'Jagadanandapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5520, 'Jagdishpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5521, 'Jagtaj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5522, 'Jala Kendua', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5523, 'Jaldhaka', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5524, 'Jalkhura', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5525, 'Jalpaiguri', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5526, 'Jamuria', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5527, 'Jangipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5528, 'Jaygaon', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5529, 'Jaynagar-Majilpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5530, 'Jemari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5531, 'Jemari Township', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5532, 'Jetia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5533, 'Jhalida', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5534, 'Jhargram', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5535, 'Jhorhat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5536, 'Jiaganj-Azimganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5537, 'Joka', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5538, 'Jot Kamal', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5539, 'Kachu Pukur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5540, 'Kajora', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5541, 'Kakdihi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5542, 'Kakdwip', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5543, 'Kalaikunda', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5544, 'Kalara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5545, 'Kalimpong', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5546, 'Kaliyaganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5547, 'Kalna', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5548, 'Kalyani', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5549, 'Kamarhati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5550, 'Kanaipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5551, 'Kanchrapara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5552, 'Kandi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5553, 'Kanki', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5554, 'Kankuria', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5555, 'Kantlia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5556, 'Kanyanagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5557, 'Karimpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5558, 'Karsiyang', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5559, 'Kasba', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5560, 'Kasimbazar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5561, 'Katwa', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5562, 'Kaugachhi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5563, 'Kenda', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5564, 'Kendra Khottamdi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5565, 'Kendua', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5566, 'Kesabpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5567, 'Khagrabari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5568, 'Khalia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5569, 'Khalor', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5570, 'Khandra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5571, 'Khantora', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5572, 'Kharagpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5573, 'Kharagpur Railway Settlement', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5574, 'Kharar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5575, 'Khardaha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5576, 'Khari Mala Khagrabari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5577, 'Kharsarai', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5578, 'Khatra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5579, 'Khodarampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5580, 'Kodalia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5581, 'Kolaghat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5582, 'Kolaghat Thermal Power Project', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5583, 'Kolkata', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5584, 'Konardihi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5585, 'Konnogar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5586, 'Krishnanagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5587, 'Krishnapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5588, 'Kshidirpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5589, 'Kshirpai', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5590, 'Kulihanda', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5591, 'Kulti', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5592, 'Kunustara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5593, 'Kuperskem', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5594, 'Madanpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5595, 'Madhusudanpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5596, 'Madhyamgram', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5597, 'Maheshtala', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5598, 'Mahiari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5599, 'Mahikpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5600, 'Mahira', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5601, 'Mahishadal', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5602, 'Mainaguri', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5603, 'Makardaha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5604, 'Mal', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5605, 'Malda', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5606, 'Mandarbani', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5607, 'Mansinhapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5608, 'Masila', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5609, 'Maslandapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5610, 'Mathabhanga', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5611, 'Mekliganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5612, 'Memari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5613, 'Midnapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5614, 'Mirik', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5615, 'Monoharpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5616, 'Mrigala', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5617, 'Muragachha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5618, 'Murgathaul', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5619, 'Murshidabad', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5620, 'Nabadhai Dutta Pukur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5621, 'Nabagram', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5622, 'Nabgram', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5623, 'Nachhratpur Katabari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5624, 'Nadia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5625, 'Naihati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5626, 'Nalhati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5627, 'Nasra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5628, 'Natibpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5629, 'Naupala', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5630, 'Navadwip', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5631, 'Nebadhai Duttapukur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5632, 'New Barrackpore', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5633, 'Ni Barakpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5634, 'Nibra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5635, 'Noapara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5636, 'Nokpul', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5637, 'North Barakpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5638, 'Odlabari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5639, 'Old Maldah', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5640, 'Ondal', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5641, 'Pairagachha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5642, 'Palashban', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5643, 'Panchla', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5644, 'Panchpara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5645, 'Pandua', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5646, 'Pangachhiya', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5647, 'Paniara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5648, 'Panihati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5649, 'Panuhat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5650, 'Par Beliya', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5651, 'Parashkol', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5652, 'Parasia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5653, 'Parbbatipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5654, 'Parui', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5655, 'Paschim Jitpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5656, 'Paschim Punro Para', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5657, 'Patrasaer', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5658, 'Pattabong Tea Garden', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5659, 'Patuli', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5660, 'Patulia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5661, 'Phulia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5662, 'Podara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5663, 'Port Blair', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5664, 'Prayagpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5665, 'Pujali', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5666, 'Purba Medinipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5667, 'Purba Tajpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5668, 'Purulia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5669, 'Raghudebbati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5670, 'Raghudebpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5671, 'Raghunathchak', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5672, 'Raghunathpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5673, 'Raghunathpur-Dankuni', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5674, 'Raghunathpur-Magra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5675, 'Raigachhi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5676, 'Raiganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5677, 'Raipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5678, 'Rajarhat Gopalpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5679, 'Rajpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5680, 'Ramchandrapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5681, 'Ramjibanpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5682, 'Ramnagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5683, 'Rampur Hat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5684, 'Ranaghat', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5685, 'Raniganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5686, 'Ratibati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5687, 'Raypur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5688, 'Rishra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5689, 'Rishra Cantonment', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5690, 'Ruiya', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5691, 'Sahajadpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5692, 'Sahapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5693, 'Sainthia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5694, 'Salap', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5695, 'Sankarpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5696, 'Sankrail', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5697, 'Santoshpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5698, 'Saontaidih', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5699, 'Sarenga', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5700, 'Sarpi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5701, 'Satigachha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5702, 'Serpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5703, 'Shankhanagar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5704, 'Shantipur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5705, 'Shrirampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5706, 'Siduli', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5707, 'Siliguri', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5708, 'Simla', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5709, 'Singur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5710, 'Sirsha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5711, 'Siuri', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5712, 'Sobhaganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5713, 'Sodpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5714, 'Sonamukhi', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5715, 'Sonatikiri', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5716, 'Srikantabati', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5717, 'Srirampur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5718, 'Sukdal', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5719, 'Taherpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5720, 'Taki', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5721, 'Talbandha', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5722, 'Tamluk', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5723, 'Tarakeswar', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5724, 'Tentulberia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5725, 'Tentulkuli', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5726, 'Thermal Power Project', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5727, 'Tinsukia', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5728, 'Titagarh', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5729, 'Tufanganj', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5730, 'Ukhra', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5731, 'Ula', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5732, 'Ulubaria', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5733, 'Uttar Durgapur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5734, 'Uttar Goara', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5735, 'Uttar Kalas', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5736, 'Uttar Kamakhyaguri', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5737, 'Uttar Latabari', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5738, 'Uttar Mahammadpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5739, 'Uttar Pirpur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5740, 'Uttar Raypur', 41, 1, '2019-07-17 10:33:04');
INSERT INTO `lb_city` (`city_id`, `city_name`, `state_id`, `city_status`, `created_date`) VALUES (5741, 'Uttarpara-Kotrung', 41, 1, '2019-07-17 10:33:04');


#
# TABLE STRUCTURE FOR: lb_contact_query
#

DROP TABLE IF EXISTS `lb_contact_query`;

CREATE TABLE `lb_contact_query` (
  `contact_id` int(125) NOT NULL AUTO_INCREMENT,
  `contact_name` varchar(255) NOT NULL,
  `contact_email` varchar(255) DEFAULT NULL,
  `contact_phone` varchar(255) NOT NULL,
  `contact_subject` varchar(255) NOT NULL,
  `contact_message` varchar(355) NOT NULL,
  `contact_status` tinyint(1) NOT NULL DEFAULT '1',
  `contact_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_updated` datetime NOT NULL,
  PRIMARY KEY (`contact_id`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=latin1;

INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (1, 'test', 'test@test.com', '1234567890', '', 'fsdsfdfds\r\n', 1, '2024-01-04 17:34:39', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (2, 'test', 'vik18nov@gmail.com', '09999005511', '', 'dcccs', 1, '2024-01-09 12:17:48', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (3, 'test', 'test@test.com', '1234567890', '', 'test message\r\n', 1, '2024-01-09 12:34:24', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (5, 'Akash blog form ', 'guptakaas@gmail.com', '9267967579', '', 'message for testing ', 1, '2024-01-16 12:14:11', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (6, 'akash', 'guptaakash@gmail.com', '9267967579', '', 'blog page ', 1, '2024-01-16 14:48:38', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (7, 'Robertdiony', 'aserboter@gmail.com', '88764837746', '', 'The Social Network of Incognito: Community and Communication \r\nThe Escrow System of Incognito: \r\nThe Economy of the Underground: Analyzing Incognito Market\'s Impact \r\nIncognito Darknet Market is an online marketplace on the Darknet accessible through anonymous networks such as Tor. It is one of the oldest and most reliable darknet markets, providing acc', 1, '2024-02-27 21:49:27', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (8, 'WhbpgjnBA', 'pyotrgor5emd@outlook.com', '2143298765', '', 'GcPRFXLz', 1, '2024-02-28 06:30:22', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (9, 'WhbpgjnBA', 'pyotrgor5emd@outlook.com', '2143298765', '', 'GcPRFXLz', 1, '2024-02-28 06:30:24', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (10, 'lKAPTSkFuMigXB', 'pyotrgor5emd@outlook.com', '3655893143', '', 'BNtaehnMxQHp', 1, '2024-02-28 06:30:37', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (11, 'lKAPTSkFuMigXB', 'pyotrgor5emd@outlook.com', '3655893143', '', 'BNtaehnMxQHp', 1, '2024-02-28 06:30:40', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (12, 'WgdfiLet', 'sborpisemall@gmail.com', '89711934997', '', '???????? <a href=https://topshopads.com/>?????? ???????? tik tok</a> \r\nAccounts <a href=https://topshopads.com/en>selling tik tok accounts</a>', 1, '2024-02-28 08:39:44', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (13, 'UKBhxwqsf', 'DorianTroy567@aol.com', '7749118219', '', 'EHSRaxJuiIfX', 1, '2024-02-28 10:08:41', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (14, 'UKBhxwqsf', 'DorianTroy567@aol.com', '7749118219', '', 'EHSRaxJuiIfX', 1, '2024-02-28 10:08:43', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (15, 'zsBQVLhYregm', 'DorianTroy567@aol.com', '4206502797', '', 'vieLUHAQXG', 1, '2024-02-28 10:08:57', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (16, 'zsBQVLhYregm', 'DorianTroy567@aol.com', '4206502797', '', 'vieLUHAQXG', 1, '2024-02-28 10:08:59', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (17, 'HITcCtdWisP', 'grimeskennao760@gmail.com', '5981656330', '', 'TSONjrZlUMxiW', 1, '2024-02-28 14:30:05', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (18, 'HITcCtdWisP', 'grimeskennao760@gmail.com', '5981656330', '', 'TSONjrZlUMxiW', 1, '2024-02-28 14:30:09', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (19, 'eXxDyzfiIFhwasu', 'grimeskennao760@gmail.com', '3372783802', '', 'NtSFYlzb', 1, '2024-02-28 14:30:21', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (20, 'eXxDyzfiIFhwasu', 'grimeskennao760@gmail.com', '3372783802', '', 'NtSFYlzb', 1, '2024-02-28 14:30:24', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (21, 'okydpePFKEAa', 'jamese4_dob8@outlook.com', '8477584282', '', 'OUxKePTS', 1, '2024-02-28 17:48:45', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (22, 'okydpePFKEAa', 'jamese4_dob8@outlook.com', '8477584282', '', 'OUxKePTS', 1, '2024-02-28 17:48:50', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (23, 'TlosFygpamIv', 'jamese4_dob8@outlook.com', '8059599342', '', 'mtGoskOAQDcMJf', 1, '2024-02-28 17:49:19', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (24, 'TlosFygpamIv', 'jamese4_dob8@outlook.com', '8059599342', '', 'mtGoskOAQDcMJf', 1, '2024-02-28 17:49:25', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (25, 'suzettevb4', 'rochelle@pxd34.mailcatchzone.run', '88857889334', '', 'Senate staffer sex scandal everything we know so far time\r\nhttp://marki.bond.women.outfits.tiktokpornstar.com/?alicia-elisabeth\r\n\r\n black stright porn fangacy channel porn free gay porn foot fetish porn star steven st croix hardcore tied up porn \r\n\r\n', 1, '2024-02-28 22:12:45', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (26, 'yzpmlEKG', 'william92redmondsfu@outlook.com', '3409111779', '', 'WehwgfKX', 1, '2024-02-29 01:55:14', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (27, 'yzpmlEKG', 'william92redmondsfu@outlook.com', '3409111779', '', 'WehwgfKX', 1, '2024-02-29 01:55:17', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (28, 'ZzCtDpxT', 'william92redmondsfu@outlook.com', '7438689513', '', 'LwGmFBazhWKevg', 1, '2024-02-29 01:56:15', '0000-00-00 00:00:00');
INSERT INTO `lb_contact_query` (`contact_id`, `contact_name`, `contact_email`, `contact_phone`, `contact_subject`, `contact_message`, `contact_status`, `contact_created`, `created_updated`) VALUES (29, 'rx abilify', '', '89987667644', '', 'Meds prescribing information. Effects of Drug Abuse. \r\n<a href=\"https://abilifypack24.top/\">where can i buy abilify</a> \r\nAll news about drug. Read no